/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.ColorScheme;
import com.frinika.sequencer.gui.DragViewTool;
import com.frinika.sequencer.gui.EraseTool;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.MyCursors;
import com.frinika.sequencer.gui.PartGlueTool;
import com.frinika.sequencer.gui.PartSplitTool;
import com.frinika.sequencer.gui.RectZoomTool;
import com.frinika.sequencer.gui.SelectTool;
import com.frinika.sequencer.gui.ToolAdapter;
import com.frinika.sequencer.gui.WriteTool;
import com.frinika.sequencer.gui.partview.LaneHeaderPanel;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.Ghost;
import com.frinika.sequencer.model.GluePartEditAction;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MidiPlayOptions;
import com.frinika.sequencer.model.MovePartEditAction;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.ResizePartAction;
import com.frinika.sequencer.model.SplitPartAction;
import com.frinika.sequencer.model.SynthLane;
import com.frinika.sequencer.model.TextLane;
import com.frinika.sequencer.model.tempo.TempoList;
import com.frinika.sequencer.model.tempo.TempoListListener;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartView
extends ItemPanel
implements SelectionListener<Part>,
EditHistoryListener {
    private static final long serialVersionUID = 1L;
    Vector<PartImage> dragList;
    int dxTotal = 0;
    int dLaneTotal = 0;
    private MidiPart newPart;
    EditHistoryContainer editHistory;
    private LaneHeaderPanel laneHeader;
    private PartSplitTool splitTool;
    private PartGlueTool glueTool;
    private int splitX;
    private boolean splitting;
    private long splitTick;
    private Stroke dashedLineStroke;
    private TempoList tempoList;
    final Rectangle rectTmp = new Rectangle();

    public PartView(ProjectFrame project, ItemScrollPane scroller) {
        super(project, scroller, true, true, 20.0, true);
        project.getProjectContainer().getPartSelection().addSelectionListener(this);
        this.tempoList = project.getProjectContainer().getTempoList();
        this.tempoList.addTempoListListener(new TempoListListener(){

            public void notifyTempoListChange() {
                PartView.this.setDirty();
                PartView.this.repaint();
            }
        });
        this.editHistory = project.getProjectContainer().getEditHistoryContainer();
        this.editHistory.addEditHistoryListener(this);
        this.sequencer = project.getProjectContainer().getSequencer();
        this.sequencer.addSongPositionListener(new SwingSongPositionListenerWrapper(this));
        FrinikaSequence seq = (FrinikaSequence)this.sequencer.getSequence();
        this.ticksPerBeat = seq.getResolution();
        if (project.getProjectContainer().getPartViewSnapQuantization() == 0.0) {
            project.getProjectContainer().setPartViewSnapQuantization(-1.0);
        }
        this.dashedLineStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.setLayout(null);
        this.setBackground(ColorScheme.partViewBackground);
        this.addComponentListener(this);
        this.makeTools();
        this.setFocusable(true);
        this.enableEvents(16L);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.grabFocus();
        }
        super.processMouseEvent(e);
    }

    void setLaneHeader(LaneHeaderPanel head) {
        this.laneHeader = head;
        this.repaintItems();
    }

    void dispose() {
        this.project.getPartSelection().removeSelectionListener(this);
        this.editHistory.removeEditHistoryListener(this);
        this.removeComponentListener(this);
    }

    @Override
    public void dragTo(Point p) {
        int dxDragged = p.x - this.xAnchor;
        int dyDragged = p.y - this.yAnchor;
        double dt = (double)dxDragged / this.userToScreen;
        double t = (double)this.xAnchor / this.userToScreen;
        double tick = this.tempoList.getTickAtTime(t);
        double tick2 = this.tempoList.getTickAtTime(t + dt);
        double dtick = tick2 - tick;
        if (this.isSnapQuantized()) {
            double quant = this.getSnapQuantization();
            if (quant > 0.0) {
                dtick = (double)Math.round(dtick / this.getSnapQuantization()) * this.getSnapQuantization();
            } else {
                double beat = tick / (double)this.project.getTicksPerBeat();
                TimeSignatureList.TimeSignatureEvent ev = this.project.getTimeSignatureList().getEventAtBeat((int)beat);
                quant = ev.beatsPerBar * this.project.getTicksPerBeat();
                dtick = (double)Math.round(dtick / quant) * quant;
            }
        }
        int dLane = dyDragged / Layout.getLaneHeightScale();
        if (Math.abs(dtick) < 1.0E-10 && dLane == 0 && !this.altIsDown && this.dragMode != 7 && this.dragMode != 6 && this.dragMode != 5) {
            return;
        }
        int lMax = Integer.MIN_VALUE;
        int lMin = Integer.MAX_VALUE;
        int nLane = this.laneHeader.visibleLanes.getVisibleLanes().size();
        if (this.dragArmed) {
            this.startDrag();
        }
        PartImage dddPart = null;
        if (this.altIsDown && (this.dragMode == 1 || this.dragMode == 3 || this.dragMode == 2) && this.project.isPartViewSnapQuantized()) {
            double sTick;
            double refTick;
            dddPart = this.dragList.get(0);
            if (this.dragMode == 2) {
                refTick = this.tempoList.getTickAtTime(dddPart.endTimeSecs) + dtick;
                sTick = this.project.partQuantize((long)refTick);
                dtick = sTick - this.tempoList.getTickAtTime(dddPart.endTimeSecs);
            } else {
                refTick = this.tempoList.getTickAtTime(dddPart.startTimeSecs) + dtick;
                sTick = this.project.partQuantize((long)refTick);
                dtick = sTick - this.tempoList.getTickAtTime(dddPart.startTimeSecs);
            }
            if (dtick == 0.0) {
                return;
            }
        }
        if (this.dragMode == 7) {
            if (dyDragged == 0) {
                return;
            }
            for (PartImage pi : this.dragList) {
                if (!(pi.part instanceof AudioPart)) continue;
                AudioPart ap = (AudioPart)pi.part;
                ap.getEvelope().setGain((double)(pi.y + pi.height - p.y) / (double)pi.height);
                ap.refreshEnvelope();
            }
        } else if (this.dragMode == 5 || this.dragMode == 6) {
            if (dxDragged == 0) {
                return;
            }
            for (PartImage pi : this.dragList) {
                if (!(pi.part instanceof AudioPart)) continue;
                double fact = (double)(p.x - pi.x) / (double)pi.width;
                AudioPart ap = (AudioPart)pi.part;
                if (this.dragMode == 6) {
                    ap.getEvelope().setTOffRel(fact);
                } else {
                    ap.getEvelope().setTOnRel(fact);
                }
                ap.refreshEnvelope();
            }
        } else {
            for (PartImage pi : this.dragList) {
                lMax = Math.max(lMax, pi.laneId);
                lMin = Math.min(lMin, pi.laneId);
            }
            if (lMax + dLane >= nLane) {
                dLane = nLane - 1 - lMax;
            } else if (lMin + dLane < 0) {
                dLane = -lMin;
            }
            this.dragArmed = false;
            if (this.dragList == null) {
                return;
            }
            for (PartImage pi : this.dragList) {
                switch (this.dragMode) {
                    case 1: {
                        pi.setMoveByDeltaTicks(dtick);
                        pi.laneId += dLane;
                        break;
                    }
                    case 2: {
                        pi.setEndMoveByDeltaTicks(dtick);
                        dLane = 0;
                        break;
                    }
                    case 3: {
                        pi.setStartMoveByDeltaTicks(dtick);
                        dLane = 0;
                        break;
                    }
                    default: {
                        System.err.println(" unknown dragmode PartView" + this.dragMode);
                    }
                }
                pi.positionPartImage();
            }
        }
        this.yAnchor += dLane * Layout.getLaneHeightScale();
        this.repaintItems();
    }

    @Override
    public void clientClearSelection() {
        this.project.getPartSelection().clearSelection();
    }

    public void startDrag() {
        this.dragList = new Vector();
        for (Part it : this.project.getPartSelection().getSelected()) {
            PartImage pi = new PartImage(it, it.getLane().getDisplayID());
            this.dragList.add(pi);
            pi.positionPartImage();
        }
    }

    @Override
    public synchronized void selectInRect(Rectangle rect, boolean shift) {
        Vector<Part> addTmp = new Vector<Part>();
        Vector<Part> delTmp = new Vector<Part>();
        for (Lane lane : this.project.getLanes()) {
            for (Part it : lane.getParts()) {
                if (!rect.intersects(this.getBounds(it))) continue;
                if (shift) {
                    if (it.isSelected()) {
                        delTmp.add(it);
                        continue;
                    }
                    addTmp.add(it);
                    continue;
                }
                addTmp.add(it);
            }
        }
        this.project.getPartSelection().removeSelected(delTmp);
        this.project.getPartSelection().addSelected(addTmp);
        this.project.getPartSelection().notifyListeners();
    }

    final Rectangle getBounds(Part part) {
        double x1 = part.getStart(this.timeBased);
        double w = part.getDuration(this.timeBased);
        x1 = (int)this.userToScreen(x1);
        w = (int)this.userToScreen(w);
        Lane lane = part.getLane();
        int y1 = lane.getDisplayY();
        this.rectTmp.setBounds((int)x1, y1, (int)w, lane.getDisplayH());
        return this.rectTmp;
    }

    public Rectangle getPartBounds(Part part) {
        double x1 = part.getStart(this.timeBased);
        double w = part.getDuration(this.timeBased);
        x1 = (int)this.userToScreen(x1);
        w = (int)this.userToScreen(w);
        Lane lane = part.getLane();
        int y1 = lane.getDisplayY();
        return new Rectangle((int)x1, y1, (int)w, lane.getDisplayH());
    }

    @Override
    public void rightButtonPressedOnItem(int x, int y) {
        this.frame.showRightButtonPartPopup(this, x, y);
    }

    @Override
    public void rectZoomFinished() {
        ((ItemRollToolBar)this.toolBar).rectZoomFinished();
    }

    @Override
    public synchronized void writeDraggedAt(Point p) {
        if (this.newPart == null) {
            return;
        }
        long tick = this.screenToTickAbs(p.x, true);
        double tick1 = this.newPart.getStart(this.timeBased);
        double tick2 = this.newPart.getEnd(this.timeBased);
        if ((double)tick > tick2) {
            this.newPart.setEndTick(tick);
        } else if ((double)tick < tick2 && (double)tick - tick1 > this.project.getPartViewSnapQuantization()) {
            this.newPart.setEndTick(tick);
        } else {
            return;
        }
        this.repaintItems();
    }

    @Override
    protected void writeReleasedAt(Point p) {
        if (this.newPart == null) {
            return;
        }
        this.project.getPartSelection().setSelected(this.newPart);
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    protected synchronized void writePressedAt(Point p) {
        this.newPart = null;
        if (this.itemAt(p) != null) {
            System.out.println(" Can only create a Part in an empty space ");
            return;
        }
        Lane lane = this.laneAt(p.y);
        if (lane == null) {
            System.out.println(" Please create a lane first");
            return;
        }
        if (lane instanceof MidiLane) {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.lane.add_part"));
            this.newPart = (MidiPart)lane.createPart();
            long tick = this.screenToTickAbs(p.x, true);
            this.newPart.setStartTick(tick);
            long quant = (long)this.project.getPartViewSnapQuantization();
            if (quant < 0L) {
                TimeSignatureList.TimeSignatureEvent ev = this.project.getTimeSignatureList().getEventAtBeat((int)(tick / (long)this.project.getTicksPerBeat()));
                int beatPerBar = ev.beatsPerBar;
                quant = beatPerBar * this.project.getTicksPerBeat();
            }
            this.newPart.setEndTick(tick + quant);
            this.repaintItems();
        } else if (lane instanceof TextLane) {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.lane.add_part"));
            long tick = this.screenToTickAbs(p.x, true);
            ((TextLane)lane).createNewTextPart(tick);
            this.repaintItems();
        }
    }

    int mapY(int y) {
        return y;
    }

    int unmapY(int y) {
        return y;
    }

    @Override
    public Item itemAt(Point p) {
        for (Lane lane : this.project.getLanes()) {
            if (lane.getParts() == null) continue;
            for (Part part : lane.getParts()) {
                if (!this.getBounds(part).contains(p)) continue;
                return part;
            }
        }
        return null;
    }

    @Override
    public synchronized void paintImageImpl(Rectangle clipRect, Graphics2D g) {
        if (g == null) {
            return;
        }
        int w = clipRect.width;
        int x = clipRect.x;
        int y = clipRect.y;
        int h = clipRect.height;
        g.setColor(ColorScheme.partViewBackground);
        g.fill(clipRect);
        double step = this.project.getPartViewSnapQuantization() / (double)this.ticksPerBeat;
        TimeSignatureList ts = this.project.getTimeSignatureList();
        double beat1 = this.screenToTickAbs(x, true) / (long)this.ticksPerBeat;
        double beat2 = this.screenToTickAbs(x + w, true) / (long)this.ticksPerBeat;
        TimeSignatureList.QStepIterator iter = this.project.getTimeSignatureList().createQStepIterator(beat1, beat2, step);
        boolean drawSub = true;
        boolean drawBeat = true;
        while (iter.hasNext()) {
            iter.next();
            double beat = iter.getBeat();
            boolean isBar = iter.isBar();
            if (isBar) {
                g.setColor(ColorScheme.partViewLinesBar);
            } else {
                if (!drawBeat) continue;
                if (Math.abs((beat + 1.0E-7) % 1.0) < 2.0E-7) {
                    g.setColor(ColorScheme.partViewLinesBeat);
                } else {
                    if (!drawSub) continue;
                    g.setColor(ColorScheme.partViewLinesSubBeat);
                }
            }
            long tick = (long)(beat * (double)this.ticksPerBeat);
            double tt = this.project.getTempoList().getTimeAtTick(tick);
            int x1 = (int)this.userToScreen(tt);
            g.drawLine(x1, y, x1, y + h);
        }
        this.paintParts(g, clipRect);
    }

    private synchronized void paintParts(Graphics2D g, Rectangle pb) {
        int gap = 2;
        Part focus = (Part)this.project.getPartSelection().getFocus();
        for (Lane lane : this.laneHeader.visibleLanes) {
            int lastX = -1;
            if (lane.getParts() == null) continue;
            for (Part part : lane.getParts()) {
                int xx;
                Rectangle rect = this.getBounds(part);
                if (rect.isEmpty()) continue;
                rect.y += 2;
                rect.height -= 4;
                if (pb != null && !pb.intersects(rect)) {
                    if (rect.x <= pb.x + pb.width) continue;
                    lastX = -2;
                    continue;
                }
                if (lastX != -2 && (xx = rect.x + rect.width) > lastX) {
                    lastX = xx;
                }
                Color color = part.getTransparentColor();
                if (part instanceof Ghost) {
                    int a = color.getAlpha() / 4;
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), a);
                }
                g.setColor(color);
                g.fill(rect);
                if (part == focus) {
                    g.setColor(Color.BLUE);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.draw(rect);
                part.drawThumbNail(g, rect, this);
                if (!part.isSelected() || part.getLane() instanceof SynthLane || !this.splitting || part.getStartTick() >= this.splitTick || part.getEndTick() <= this.splitTick) continue;
                double time = this.tempoList.getTimeAtTick(this.splitTick);
                int xSplit = (int)this.userToScreen(time);
                g.setColor(Color.WHITE);
                g.drawLine(xSplit, rect.y - 2, xSplit, rect.y + rect.height + 2);
            }
            if (lastX < 0 || !(lane instanceof MidiLane)) continue;
            MidiPlayOptions opt = ((MidiLane)lane).getPlayOptions();
            if (!opt.looped) continue;
            g.setColor(Color.GRAY);
            Composite compositeBackup = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.666f));
            g.fillRect(lastX + 1, lane.getDisplayY() + 1, pb.width - lastX - 2, lane.getDisplayH() - 2);
            long lastTick = ((MidiLane)lane).getTrack().lastTickUsed();
            Rectangle r = new Rectangle();
            r.width = (int)this.userToScreen(opt.loopedTicks);
            r.height = lane.getDisplayH() - 2;
            r.x = (int)this.userToScreen(lastTick) + 1;
            r.y = lane.getDisplayY() + 1;
            g.setColor(Color.BLACK);
            Stroke strokeBackup = g.getStroke();
            g.setStroke(this.dashedLineStroke);
            while (pb.intersects(r)) {
                g.drawRect(r.x, r.y, r.width, r.height);
                r.x = (int)this.userToScreen(lastTick += opt.loopedTicks);
            }
            g.setStroke(strokeBackup);
            g.setComposite(compositeBackup);
        }
        if (this.dragList == null) {
            for (Part part : this.project.getPartSelection().getSelected()) {
                Rectangle rect = this.getBounds(part);
                if (part instanceof AudioPart) {
                    rect.y += 2;
                    rect.height -= 4;
                    ((AudioPart)part).drawEnvelope(g, rect, this);
                    continue;
                }
                ++rect.y;
                rect.height -= 2;
                if (part == focus) {
                    g.setColor(Color.BLUE);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.draw(rect);
                part.drawThumbNail(g, rect, this);
            }
            return;
        }
        for (PartImage partImage : this.dragList) {
            if (pb != null && !pb.intersects(partImage)) continue;
            Rectangle rect = new Rectangle(partImage);
            Part part = partImage.part;
            if ((this.dragMode == 7 || this.dragMode == 6 || this.dragMode == 5) && part instanceof AudioPart) {
                rect.y += 2;
                rect.height -= 4;
                ((AudioPart)part).drawEnvelope(g, rect, this);
                continue;
            }
            g.setColor(Color.RED);
            g.draw(rect);
            if (this.dragMode == 1 || partImage.part instanceof AudioPart) continue;
            partImage.part.drawThumbNail(g, rect, this);
        }
    }

    @Override
    public void endDrag() {
        if (this.dragList == null) {
            return;
        }
        switch (this.dragMode) {
            case 1: {
                if (!this.controlIsDown) {
                    this.editHistory.mark(CurrentLocale.getMessage("sequencer.partview.drag_move_part"));
                    break;
                }
                this.editHistory.mark(CurrentLocale.getMessage("sequencer.partview.drag_copy_part"));
                break;
            }
            case 2: 
            case 3: {
                this.editHistory.mark(CurrentLocale.getMessage("sequencer.partview.resize"));
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                System.out.println(" TODO  history for envelope dragging " + this.dragMode);
                break;
            }
            default: {
                System.err.println(" unknown dragmode " + this.dragMode);
            }
        }
        for (PartImage pi : this.dragList) {
            pi.drop();
        }
        this.dragList = null;
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
    }

    @Override
    public void erase(Item it) {
        Part part = (Part)it;
        this.editHistory.mark("sequencer.project.erase_part");
        part.getLane().remove(part);
        this.project.getPartSelection().removeSelected(part);
        this.editHistory.notifyEditHistoryListeners();
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    public boolean requiresNotificationOnEachTick() {
        return false;
    }

    @Override
    public void clientAddToSelection(Item item) {
        this.project.getPartSelection().addSelected((Part)item);
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    public void clientRemoveFromSelection(Item item) {
        this.project.getPartSelection().removeSelected((Part)item);
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    public int getHoverStateAt(Point p) {
        int endTol = 20;
        int tol = 20;
        for (Lane lane : this.laneHeader.visibleLanes) {
            if (lane.getParts() == null) continue;
            for (Part part : lane.getParts()) {
                int ret;
                Rectangle rect = this.getBounds(part);
                if (!rect.contains(p)) continue;
                if (part instanceof AudioPart && (ret = ((AudioPart)part).getHoverState(p, rect)) != -1) {
                    return ret;
                }
                if (rect.width < 100) {
                    tol = rect.width / 3;
                }
                if (p.x - rect.x <= tol) {
                    return 3;
                }
                if (rect.x + rect.width - p.x <= tol) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    void makeTools() {
        Cursor c = new Cursor(0);
        this.selectTool = new SelectTool(c);
        this.rectZoomTool = new RectZoomTool(c);
        this.writeTool = new WriteTool(MyCursors.getCursor("pencil"));
        this.eraseTool = new EraseTool(MyCursors.getCursor("eraser"));
        this.dragViewTool = new DragViewTool(MyCursors.getCursor("move"));
        this.splitTool = new PartSplitTool(Cursor.getDefaultCursor());
        this.glueTool = new PartGlueTool(MyCursors.getCursor("glue"));
    }

    Lane laneAt(int yy) {
        int y = this.unmapY(yy);
        for (Lane lane : this.laneHeader.visibleLanes) {
            if (lane.getDisplayY() > y || lane.getDisplayY() + lane.getDisplayH() <= y) continue;
            return lane;
        }
        return null;
    }

    @Override
    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryActions) {
        this.repaintItems();
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Part> src) {
        this.repaintItems();
    }

    @Override
    protected void paintImageImplLabel(Graphics2D graphics) {
    }

    @Override
    public double getSnapQuantization() {
        return this.project.getPartViewSnapQuantization();
    }

    @Override
    public void setSnapQuantization(double quant) {
        this.project.setPartViewSnapQuantization(quant);
        this.repaintItems();
    }

    @Override
    public boolean isSnapQuantized() {
        return this.project.isPartViewSnapQuantized();
    }

    @Override
    public void setSnapQuantized(boolean b) {
        this.project.setPartViewSnapQuantized(b);
    }

    @Override
    public void setFocus(Item item) {
        this.project.getPartSelection().setFocus((Part)item);
    }

    @Override
    public ToolAdapter getTool(String name) {
        this.splitting = false;
        if (name.equals("split")) {
            this.splitting = true;
            return this.splitTool;
        }
        if (name.equals("glue")) {
            return this.glueTool;
        }
        return super.getTool(name);
    }

    public void splitIsOver(Point p) {
        long tick = this.screenToTickAbs(p.x, true);
        if (this.splitTick == tick) {
            return;
        }
        this.splitTick = tick;
        this.repaintItems();
    }

    public void splitAt(Point p) {
        SplitPartAction act = new SplitPartAction(this.project, this.screenToTickAbs(p.x, this.project.isPartViewSnapQuantized()));
        this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.partview.split.part"));
        act.redo();
        this.project.getEditHistoryContainer().push(act);
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getPartSelection().notifyListeners();
    }

    public void gluePart(Item item) {
        GluePartEditAction act = new GluePartEditAction((MidiPart)item);
        this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.partview.glue.part"));
        act.redo();
        this.project.getEditHistoryContainer().push(act);
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getPartSelection().notifyListeners();
    }

    public void selectAll() {
        Vector<Part> list = new Vector<Part>();
        for (Lane lane : this.laneHeader.visibleLanes) {
            for (Part part : lane.getParts()) {
                list.add(part);
            }
        }
        this.project.getPartSelection().setSelected(list);
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    public void clientNotifySelectionChange() {
        this.project.getPartSelection().notifyListeners();
    }

    @Override
    public void setTimeAtX(int x) {
        long tick = this.project.partQuantize(this.screenToTickAbs(x, false));
        this.sequencer.setTickPosition(tick);
    }

    public class PartImage
    extends Rectangle {
        private double endTimeSecs;
        private double endTimeDelta;
        private double startTimeSecs;
        private double startTimeDelta;
        public Color color;
        private static final long serialVersionUID = 1L;
        int laneId;
        Part part;

        PartImage(Part part, int laneId) {
            this.color = part.getColor();
            this.startTimeSecs = part.getStartInSecs();
            this.endTimeSecs = part.getEndInSecs();
            this.laneId = laneId;
            this.part = part;
        }

        private void print(String txt) {
            if (txt != null) {
                System.out.println(txt);
            }
            TimeUtils tu = PartView.this.project.getTimeUtils();
            System.out.println(" start=" + tu.tickToBarBeatTick((long)PartView.this.tempoList.getTickAtTime(this.startTimeSecs + this.startTimeDelta)));
            System.out.println("   end=" + tu.tickToBarBeatTick((long)PartView.this.tempoList.getTickAtTime(this.endTimeSecs + this.endTimeDelta)));
        }

        public void setEndMoveByDeltaTicks(double dtick) {
            double endTick = PartView.this.tempoList.getTickAtTime(this.endTimeSecs);
            this.endTimeDelta = PartView.this.tempoList.getTimeAtTick(endTick + dtick) - this.endTimeSecs;
        }

        public void setMoveByDeltaTicks(double dtick) {
            if (this.part instanceof MidiPart) {
                this.setStartMoveByDeltaTicks(dtick);
                this.setEndMoveByDeltaTicks(dtick);
            } else {
                this.setStartMoveByDeltaTicks(dtick);
                this.endTimeDelta = this.startTimeDelta;
            }
        }

        public void setStartMoveByDeltaTicks(double dtick) {
            double startTick = PartView.this.tempoList.getTickAtTime(this.startTimeSecs);
            this.startTimeDelta = PartView.this.tempoList.getTimeAtTick(startTick + dtick) - this.startTimeSecs;
        }

        void drop() {
            switch (PartView.this.dragMode) {
                case 1: {
                    Lane lane = this.part.getLane();
                    Lane destLane = ((PartView)PartView.this).laneHeader.visibleLanes.getVisibleLanes().get(this.laneId);
                    if (!(lane.getClass() == destLane.getClass() || destLane instanceof AudioLane && lane instanceof SynthLane && PartView.this.controlIsDown)) {
                        System.out.println(" Lanes must be the same type to copy a part");
                        return;
                    }
                    if (lane.getDisplayID() == this.laneId) assert (destLane == lane);
                    double dTick = PartView.this.tempoList.getTickAtTime(this.startTimeSecs + this.startTimeDelta) - PartView.this.tempoList.getTickAtTime(this.startTimeSecs);
                    if (!PartView.this.controlIsDown) {
                        MovePartEditAction act = new MovePartEditAction(this.part, dTick, destLane);
                        act.redo();
                        PartView.this.editHistory.push(act);
                        break;
                    }
                    this.part.copyBy(dTick, destLane);
                    try {
                        if (MidiPart.class.isInstance(this.part)) {
                            ((MidiPart)this.part).rebuildMultiEventEndTickComparables();
                            break;
                        }
                        this.part.onLoad();
                    }
                    catch (Exception e) {
                        System.err.println(" SHOULD NEVER HAPPEN ");
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: 
                case 3: {
                    ResizePartAction act = new ResizePartAction(this.part, this.startTimeSecs + this.startTimeDelta, this.endTimeSecs + this.endTimeDelta);
                    act.redo();
                    PartView.this.editHistory.push(act);
                    break;
                }
                default: {
                    System.err.println(" unknown dragmode In PARTVIEW PartImage drop" + PartView.this.dragMode);
                }
            }
        }

        private void positionPartImage() {
            double x1 = this.startTimeSecs + this.startTimeDelta;
            double w = this.endTimeSecs + this.endTimeDelta - this.startTimeSecs - this.startTimeDelta;
            x1 = (int)PartView.this.userToScreen(x1);
            w = (int)PartView.this.userToScreen(w);
            Lane lane = ((PartView)PartView.this).laneHeader.visibleLanes.getVisibleLanes().get(this.laneId);
            int y1 = lane.getDisplayY();
            this.x = (int)x1;
            this.y = y1;
            this.width = (int)w;
            this.height = lane.getDisplayH();
        }
    }
}

