/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.partview.LaneHeaderItem;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.partview.PartViewEditor;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.ProjectLane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoicePartViewSplitPane
extends JPanel
implements SelectionListener<Lane> {
    private static final long serialVersionUID = 1L;
    LaneView laneView;
    PartViewEditor partViewEditor;
    ProjectFrame project;
    JSplitPane splitPane = new JSplitPane();
    LaneView nullView = new LaneView(null);
    boolean showVoiceView = true;
    boolean dockmode;

    public JComponent getLaneView() {
        return this;
    }

    public JComponent getPartViewEditor() {
        return this.partViewEditor;
    }

    public VoicePartViewSplitPane(ProjectFrame project, boolean dockmode) {
        this.project = project;
        this.dockmode = dockmode;
        this.setLayout(new BorderLayout());
        this.partViewEditor = new PartViewEditor(project);
        ProjectLane lane = project.getProjectContainer().getProjectLane();
        this.laneView = new LaneView(lane);
        this.laneView.setEnabled(false);
        if (dockmode) {
            this.add(this.laneView);
        } else {
            this.add((Component)this.splitPane, "Center");
            this.splitPane.add((Component)this.partViewEditor, "right");
            this.splitPane.setResizeWeight(0.0);
            this.splitPane.add((Component)this.laneView, "left");
        }
        project.getProjectContainer().getLaneSelection().addSelectionListener(this);
    }

    public void toggleVoiceView() {
        if (this.dockmode) {
            return;
        }
        boolean bl = this.showVoiceView = !this.showVoiceView;
        if (this.showVoiceView) {
            this.remove(this.partViewEditor);
            this.add((Component)this.splitPane, "Center");
            this.splitPane.add((Component)this.partViewEditor, "right");
        } else {
            this.splitPane.remove(this.partViewEditor);
            this.remove(this.splitPane);
            this.add((Component)this.partViewEditor, "Center");
        }
        this.validate();
    }

    void dispose() {
        this.project.getProjectContainer().getLaneSelection().removeSelectionListener(this);
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Lane> src) {
        Lane lane = src.getFocus();
        if (lane == null) {
            return;
        }
        LaneHeaderItem header = null;
        for (Component c : this.partViewEditor.laneHeaderPanel.getComponents()) {
            if (!(c instanceof LaneHeaderItem)) continue;
            LaneHeaderItem h = (LaneHeaderItem)c;
            Lane il = h.lane;
            if (il != lane) continue;
            header = h;
            break;
        }
        LaneView newVoiceView = this.nullView;
        if (header != null) {
            newVoiceView = header.voiceView;
        }
        if (this.laneView != newVoiceView) {
            if (this.dockmode) {
                if (this.laneView != null) {
                    this.remove(this.laneView);
                }
                this.laneView = newVoiceView;
                if (this.laneView != null) {
                    this.add(this.laneView);
                    this.laneView.setEnabled(true);
                }
                this.validate();
                this.repaint();
                this.partViewEditor.repaint();
            } else {
                this.remove(this.laneView);
                this.laneView = newVoiceView;
                this.splitPane.setTopComponent(this.laneView);
                this.laneView.setEnabled(true);
                this.repaint();
            }
        }
    }

    public PartView getPartview() {
        return this.partViewEditor.getPartView();
    }
}

