/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.ColorScheme;
import com.frinika.sequencer.gui.DragViewTool;
import com.frinika.sequencer.gui.EraseTool;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.MyCursors;
import com.frinika.sequencer.gui.RectZoomTool;
import com.frinika.sequencer.gui.SelectTool;
import com.frinika.sequencer.gui.WriteTool;
import com.frinika.sequencer.gui.pianoroll.ControllerHandle;
import com.frinika.sequencer.gui.pianoroll.ItemPanelMultiEventListener;
import com.frinika.sequencer.gui.pianoroll.ItemPanelPartListener;
import com.frinika.sequencer.gui.pianoroll.PianoRollPanelAdapter;
import com.frinika.sequencer.gui.selection.DragList;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.util.EventFilter;
import com.frinika.sequencer.model.util.EventsInPartsIterator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerView
extends PianoRollPanelAdapter
implements AdjustmentListener {
    int defaultLength;
    int pitchTop = 127;
    int noteItemHeight;
    int yScreenBot;
    int velocity = 100;
    int channel = 1;
    private static final long serialVersionUID = 1L;
    private static final Color selCol = new Color(127, 127, 127, 200);
    private static final Color noteCol = Color.RED;
    private static final Color dragCol = Color.BLACK;
    EditHistoryContainer editHistory;
    Vector<MultiEvent> notesUnder;
    private ItemPanelMultiEventListener multiEventListener;
    private ItemPanelPartListener partListener;
    private int panelHeight;
    private int xLast;
    private ControllerHandle cntrl;
    private boolean velocityMode;
    MultiEvent dragEvent;
    Iterable<MultiEvent> eventsOnScreen;
    Iterable<MultiEvent> eventsInFocus;
    private int dValLast;
    final Rectangle tmpRect = new Rectangle();

    public ControllerView(ProjectFrame frame, ItemScrollPane scroller) {
        super(frame, scroller, false, false);
        final ProjectContainer project = frame.getProjectContainer();
        this.sequencer = project.getSequencer();
        this.multiEventListener = new ItemPanelMultiEventListener(this);
        this.partListener = new ItemPanelPartListener(this);
        this.eventsOnScreen = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                return new EventsInPartsIterator(project.getPartSelection().getSelected(), (EventFilter)ControllerView.this);
            }
        };
        this.eventsInFocus = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                Part focus = (Part)project.getPartSelection().getFocus();
                if (focus == null) {
                    return null;
                }
                return new EventsInPartsIterator((Part)project.getPartSelection().getFocus(), (EventFilter)ControllerView.this);
            }
        };
        project.getMultiEventSelection().addSelectionListener(this.multiEventListener);
        project.getPartSelection().addSelectionListener(this.partListener);
        this.sequencer.addSongPositionListener(new SwingSongPositionListenerWrapper(this));
        FrinikaSequence seq = (FrinikaSequence)this.sequencer.getSequence();
        this.editHistory = project.getEditHistoryContainer();
        this.editHistory.addEditHistoryListener(this);
        this.defaultLength = this.ticksPerBeat = seq.getResolution();
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.repaintItems();
        this.addComponentListener(this);
        this.makeTools();
    }

    public void dispose() {
        this.project.getMultiEventSelection().removeSelectionListener(this.multiEventListener);
        this.project.getPartSelection().removeSelectionListener(this.partListener);
        this.editHistory.removeEditHistoryListener(this);
    }

    @Override
    public void dragTo(Point p) {
        if (this.dragArmed) {
            this.dValLast = 0;
        }
        int dyDragged = p.y - this.yAnchor;
        int dValToT = 0;
        dValToT = -(dyDragged * (this.cntrl.maxVal - this.cntrl.minVal)) / this.panelHeight;
        int dVal = dValToT - this.dValLast;
        if (dVal == 0) {
            return;
        }
        if (this.dragArmed) {
            this.dragStart();
        }
        this.dragArmed = false;
        this.dValLast = dValToT;
        DragList dragList = this.project.getDragList();
        if (dVal != 0) {
            int valLim = dVal > 0 ? this.cntrl.minVal : this.cntrl.maxVal;
            for (Item ev1 : dragList) {
                MultiEvent ev = (MultiEvent)ev1;
                int pitch = ev.getValueUI() + dVal;
                if (dVal > 0) {
                    valLim = Math.max(pitch, valLim);
                    continue;
                }
                valLim = Math.min(pitch, valLim);
            }
            if (dVal > 0 && valLim > this.cntrl.maxVal) {
                dVal -= valLim - this.cntrl.maxVal;
            } else if (dVal < 0 && valLim < this.cntrl.minVal) {
                dVal -= valLim - this.cntrl.minVal;
            }
        }
        if (dVal == 0) {
            return;
        }
        boolean first = true;
        long dt = 0L;
        Object dev = null;
        boolean velMode = this.cntrl.name.equals("velocity");
        block6: for (Item ev1 : dragList) {
            MultiEvent ev = (MultiEvent)ev1;
            switch (this.dragMode) {
                case 4: {
                    int val = ev.getValueUI() + dVal;
                    ev.setValue(val);
                    continue block6;
                }
            }
            try {
                throw new Exception(" unknown dragmode " + this.dragMode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.project.getDragList().notifyDragEventListeners();
        this.project.getDragList().notifyFeedbackItemListeners();
        this.repaintItems();
    }

    @Override
    public void clientClearSelection() {
        this.project.getMultiEventSelection().clearSelection();
    }

    public void dragStart() {
        this.project.getDragList().startDrag(this.dragItem);
    }

    @Override
    public synchronized void selectInRect(Rectangle rect, boolean shift) {
        Vector<MultiEvent> addTmp = new Vector<MultiEvent>();
        Vector<MultiEvent> delTmp = new Vector<MultiEvent>();
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        Iterable<MultiEvent> list = focusPart != null ? this.eventsInFocus : this.eventsOnScreen;
        for (MultiEvent note : list) {
            if (!this.isValidEvent(note) || !rect.intersects(this.getItemBounds(note))) continue;
            if (shift) {
                if (note.isSelected()) {
                    delTmp.add(note);
                    continue;
                }
                addTmp.add(note);
                continue;
            }
            addTmp.add(note);
        }
        this.project.getMultiEventSelection().removeSelected(delTmp);
        this.project.getMultiEventSelection().addSelected(addTmp);
        this.project.getMultiEventSelection().notifyListeners();
    }

    @Override
    public void writeDraggedAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (focusPart == null || !(focusPart instanceof MidiPart)) {
            System.out.println(" Please slectect a part ");
            return;
        }
        int x1 = Math.min(this.xLast, p.x);
        int x2 = Math.max(this.xLast, p.x);
        long tick1 = 0L;
        long tick2 = 0L;
        if (this.velocityMode) {
            this.notesUnder = this.eventsUnderScreen(x1, x2);
            if (this.notesUnder.size() == 0) {
                return;
            }
        } else {
            tick1 = this.screenToTickAbs(x1, true);
            tick2 = this.screenToTickAbs(x2, true) + (long)this.project.getPianoRollSnapQuantization();
            this.notesUnder = this.eventsUnderTime(tick1, tick2);
        }
        int val = this.screenToValue(p.y);
        this.xLast = p.x;
        val = Math.max(val, this.cntrl.minVal);
        val = Math.min(val, this.cntrl.maxVal);
        if (this.velocityMode) {
            this.setValue(this.notesUnder, val);
            this.project.getDragList().notifyFeedbackItemListeners(this.notesUnder.firstElement());
        } else {
            if (this.notesUnder.size() != 0) {
                for (MultiEvent ev : this.notesUnder) {
                    ev.getPart().remove(ev);
                }
            }
            MultiEvent ev = null;
            long tick = tick1;
            while (tick < tick2) {
                ev = this.cntrl.createEvent((MidiPart)focusPart, tick, val);
                ((MidiPart)focusPart).add(ev);
                tick = (long)((double)tick + this.project.getPianoRollSnapQuantization());
            }
            if (ev != null) {
                this.project.getDragList().notifyFeedbackItemListeners(ev);
            }
        }
        this.repaintItems();
    }

    @Override
    protected synchronized void writePressedAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        this.velocityMode = this.cntrl.isVelocity();
        if (focusPart == null || !(focusPart instanceof MidiPart)) {
            System.out.println(" Please slectect a part ");
            return;
        }
        if (this.velocityMode) {
            this.notesUnder = this.eventsUnderScreen(p.x, p.x);
        } else {
            long tick = this.screenToTickAbs(p.x, true);
            long tick2 = tick + (long)this.project.getPianoRollSnapQuantization();
            this.notesUnder = this.eventsUnderTime(tick, tick2);
        }
        this.xLast = p.x;
        int val = this.screenToValue(p.y);
        val = Math.max(val, this.cntrl.minVal);
        val = Math.min(val, this.cntrl.maxVal);
        if (this.velocityMode) {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.controllerview.adjust_velocity"));
            if (this.notesUnder.size() != 0) {
                this.setValue(this.notesUnder, val);
                this.project.getDragList().notifyFeedbackItemListeners(this.notesUnder.firstElement());
            }
        } else {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.controllerview.write_control"));
            if (this.notesUnder.size() != 0) {
                for (MultiEvent ev : this.notesUnder) {
                    ev.getPart().remove(ev);
                }
            }
            long tick = this.screenToTickAbs(p.x, true);
            MultiEvent ev = this.cntrl.createEvent((MidiPart)focusPart, tick, val);
            ((MidiPart)focusPart).add(ev);
            this.project.getDragList().notifyFeedbackItemListeners(ev);
        }
        this.repaintItems();
    }

    void setValue(Vector<MultiEvent> notes, int val) {
        for (MultiEvent note : notes) {
            if (note.getValueUI() == val) continue;
            MidiPart p = note.getPart();
            p.remove(note);
            note.setValue(val);
            p.add(note);
        }
        this.repaintItems();
    }

    private int screenToValue(int y) {
        return this.cntrl.minVal + (this.panelHeight - y) * (this.cntrl.maxVal - this.cntrl.minVal) / this.panelHeight;
    }

    private int valueToScreen(int val) {
        return this.panelHeight - (val - this.cntrl.minVal) * this.panelHeight / (this.cntrl.maxVal - this.cntrl.minVal);
    }

    private Vector<MultiEvent> eventsUnderScreen(int x1, int x2) {
        Vector<MultiEvent> noteEvents = new Vector<MultiEvent>();
        for (MultiEvent note : ((MidiPart)this.project.getPartSelection().getFocus()).getMultiEvents()) {
            if (!this.isValidEvent(note)) continue;
            Rectangle rect = this.getItemBounds(note);
            int x11 = rect.x;
            int x22 = rect.x + rect.width;
            if (!(x1 <= x22 && x1 >= x11 || x2 <= x22 && x2 >= x11) && (x1 > x11 || x2 < x22)) continue;
            noteEvents.add(note);
        }
        return noteEvents;
    }

    private Vector<MultiEvent> eventsUnderTime(long tick1, long tick2) {
        Vector<MultiEvent> noteEvents = new Vector<MultiEvent>();
        for (MultiEvent note : ((MidiPart)this.project.getPartSelection().getFocus()).getMultiEvents()) {
            long tick;
            if (!this.isValidEvent(note) || tick1 > (tick = note.getStartTick()) || tick >= tick2) continue;
            noteEvents.add(note);
        }
        return noteEvents;
    }

    private int screenToPitch(int y) {
        return this.pitchTop - y / this.noteItemHeight;
    }

    @Override
    public Item itemAt(Point p) {
        MultiEvent at = null;
        for (MultiEvent note : this.eventsOnScreen) {
            if (!this.isValidEvent(note) || !this.getItemBounds(note).contains(p)) continue;
            if (note.isSelected()) {
                return note;
            }
            if (at != null) continue;
            at = note;
        }
        return at;
    }

    @Override
    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryActions) {
        this.repaintItems();
    }

    @Override
    public synchronized void paintImageImpl(Rectangle visibleRect, Graphics2D g) {
        if (g == null) {
            return;
        }
        if (this.cntrl == null) {
            return;
        }
        this.noteItemHeight = Layout.getNoteItemHeight();
        this.yScreenBot = this.pitchTop * this.noteItemHeight;
        this.velocityMode = this.cntrl.isVelocity();
        if (this.velocityMode) {
            this.paintImageImplVel(visibleRect, g);
        } else {
            this.paintImageImplCntrl(visibleRect, g);
        }
    }

    @Override
    public synchronized void paintImageImplLabel(Graphics2D g) {
        if (g == null) {
            return;
        }
        if (this.cntrl == null) {
            return;
        }
        String label = this.cntrl.getName();
        TextLayout tl = new TextLayout(label, g.getFont(), g.getFontRenderContext());
        Rectangle2D bounds = tl.getBounds();
        int margin = 3;
        Point2D.Float locBB = new Point2D.Float(0.0f, (float)tl.getBounds().getHeight() + (float)(2 * margin));
        Point2D.Float locTEXT = new Point2D.Float(margin, locBB.y - (float)margin);
        bounds.setRect(0.0, 0.0, bounds.getWidth() + (double)(margin * 2), bounds.getHeight() + (double)(margin * 2));
        g.setColor(Color.WHITE);
        g.fill(bounds);
        g.setColor(Color.BLACK);
        g.draw(bounds);
        tl.draw(g, (float)((Point2D)locTEXT).getX(), (float)((Point2D)locTEXT).getY());
    }

    private synchronized void paintImageImplCntrl(Rectangle visibleRect, Graphics2D g) {
        int w = visibleRect.width;
        int x = visibleRect.x;
        int y = visibleRect.y;
        this.panelHeight = visibleRect.height;
        int yBot = this.yScreenBot;
        g.setColor(Color.WHITE);
        g.fill(visibleRect);
        double tick1 = this.screenToTickAbs(x, true);
        int x1 = (int)this.userToScreen((long)tick1);
        if (x1 < x) {
            x1 = (int)this.userToScreen((long)(tick1 += this.project.getPianoRollSnapQuantization()));
        }
        assert (x1 >= x);
        while (x1 < x + w) {
            if (Math.abs((tick1 + 1.0) % (double)this.ticksPerBeat) < 2.0) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine(x1, y, x1, y + this.panelHeight);
            x1 = (int)this.userToScreen((long)(tick1 += this.project.getPianoRollSnapQuantization()));
        }
        g.setColor(Color.lightGray);
        int inc = 10;
        for (int i = 0; i < 127; i += inc) {
            if (i % 10 != 0) continue;
            int yy = this.panelHeight - i * this.panelHeight / (this.cntrl.maxVal - this.cntrl.minVal);
            g.drawLine(x, yy, x + w, yy);
        }
        Part fc = (Part)this.project.getPartSelection().getFocus();
        if (fc != null && !(fc instanceof MidiPart)) {
            return;
        }
        MidiPart focusPart = (MidiPart)fc;
        MultiEvent evPrev = null;
        MultiEvent evNext = null;
        int valPrev = 0;
        int valNext = 0;
        int xNext = 0;
        int xPrev = 0;
        if (focusPart == null) {
            return;
        }
        Iterator<MultiEvent> iter = this.eventsInFocus.iterator();
        if (!iter.hasNext()) {
            return;
        }
        Iterator diter = null;
        DragList dragList = this.project.getDragList();
        if (!dragList.isEmpty()) {
            diter = dragList.iterator();
        }
        boolean doit = true;
        boolean highLightNext = false;
        Rectangle rect = new Rectangle();
        do {
            valPrev = valNext;
            evPrev = evNext;
            xPrev = xNext;
            boolean hilight = highLightNext;
            if (iter.hasNext()) {
                MultiEvent ev = iter.next();
                if (!this.isValidEvent(ev)) continue;
                if (ev.isSelected()) {
                    highLightNext = true;
                    if (diter != null) {
                        ev = (MultiEvent)diter.next();
                    }
                } else {
                    highLightNext = false;
                }
                evNext = ev;
                xNext = (int)this.userToScreen(evNext.getStartTick());
                valNext = evNext.getValueUI();
                if (xNext < visibleRect.x) {
                    continue;
                }
            } else {
                xNext = visibleRect.x + visibleRect.width;
                doit = false;
            }
            if (valPrev == this.cntrl.minVal) continue;
            rect.y = this.valueToScreen(valPrev);
            rect.height = this.panelHeight - rect.y;
            if (xNext > visibleRect.x + visibleRect.width) {
                xNext = visibleRect.x + visibleRect.width;
            }
            rect.x = xPrev;
            rect.width = xNext - xPrev;
            if (evPrev != null) {
                if (hilight) {
                    g.setColor(ColorScheme.selectedColor);
                    g.fill(rect);
                    evPrev = evNext;
                } else {
                    MidiLane myLane = (MidiLane)focusPart.getLane();
                    if (myLane == null) {
                        g.setColor(Color.BLACK);
                    } else {
                        g.setColor(focusPart.getColor());
                    }
                    g.fill(rect);
                }
            }
            evPrev = evNext;
        } while (doit);
    }

    public synchronized void paintImageImplVel(Rectangle visibleRect, Graphics2D g) {
        MidiLane myLane;
        Rectangle noteRect;
        int w = visibleRect.width;
        int x = visibleRect.x;
        int y = visibleRect.y;
        this.panelHeight = visibleRect.height;
        int yBot = this.yScreenBot;
        g.setColor(Color.WHITE);
        g.fill(visibleRect);
        double tick1 = this.screenToTickAbs(x, true);
        double snaptoQuantization = this.project.getPianoRollSnapQuantization();
        int x1 = (int)this.userToScreen((long)tick1);
        if (snaptoQuantization <= 0.0) {
            snaptoQuantization = this.project.getTicksPerBeat();
        }
        if (x1 < x) {
            x1 = (int)this.userToScreen((long)(tick1 += snaptoQuantization));
        }
        assert (x1 >= x);
        while (x1 < x + w) {
            if (Math.abs((tick1 + 1.0) % (double)this.ticksPerBeat) < 2.0) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine(x1, y, x1, y + this.panelHeight);
            x1 = (int)this.userToScreen((long)(tick1 += snaptoQuantization));
        }
        g.setColor(Color.lightGray);
        int inc = 10;
        for (int i = 0; i < 127; i += inc) {
            if (i % 10 != 0) continue;
            int yy = this.valueToScreen(i);
            g.drawLine(x, yy, x + w, yy);
        }
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        DragList dragList = this.project.getDragList();
        if (!(focusPart instanceof MidiPart)) {
            return;
        }
        for (MultiEvent note : this.eventsOnScreen) {
            if (!this.isValidEvent(note) || focusPart != null && note.getPart() == focusPart) continue;
            noteRect = this.getItemBounds(note);
            if (visibleRect != null && !visibleRect.intersects(noteRect)) continue;
            if (note.isSelected()) {
                if (dragList.isEmpty()) continue;
                g.setColor(ColorScheme.selectedColor);
                g.fill(noteRect);
                continue;
            }
            myLane = (MidiLane)note.getPart().getLane();
            if (myLane == null) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(note.getPart().getColor());
            }
            g.fill(noteRect);
        }
        if (focusPart != null) {
            for (MultiEvent note : ((MidiPart)focusPart).getMultiEvents()) {
                if (!this.isValidEvent(note)) continue;
                noteRect = this.getItemBounds(note);
                if (visibleRect != null && !visibleRect.intersects(noteRect)) continue;
                if (note.isSelected()) {
                    if (dragList.isEmpty()) {
                        g.setColor(selCol);
                        g.fill(noteRect);
                    }
                } else {
                    myLane = (MidiLane)note.getPart().getLane();
                    if (myLane == null) {
                        g.setColor(Color.BLACK);
                    } else {
                        g.setColor(note.getPart().getColor());
                    }
                    g.fill(noteRect);
                }
                g.setColor(Color.BLACK);
                g.draw(noteRect);
            }
        }
        for (Item it : dragList) {
            MultiEvent note = (MultiEvent)it;
            Rectangle noteRect2 = this.getItemBounds(note);
            if (visibleRect != null && !visibleRect.intersects(noteRect2)) continue;
            g.setColor(selCol);
            g.fill(noteRect2);
            g.setColor(Color.RED);
            g.draw(noteRect2);
        }
    }

    private Rectangle getItemBounds(Item it) {
        MultiEvent e = (MultiEvent)it;
        long tick = e.getStartTick();
        int h1 = 0;
        h1 = (e.getValueUI() - this.cntrl.minVal) * this.panelHeight / (this.cntrl.maxVal - this.cntrl.minVal);
        int x1 = (int)this.userToScreen(tick);
        int w = 5;
        this.tmpRect.setBounds(x1, this.panelHeight - h1, w, h1);
        return this.tmpRect;
    }

    @Override
    public void endDrag() {
        if (this.dragArmed) {
            this.dragArmed = false;
            return;
        }
        this.project.getDragList().endDragController();
    }

    @Override
    public void erase(Item it) {
        MultiEvent note = (MultiEvent)it;
        this.velocityMode = this.cntrl.isVelocity();
        if (this.velocityMode) {
            this.editHistory.mark("erase note");
        } else {
            this.editHistory.mark("erase event");
        }
        note.getPart().remove(note);
        this.editHistory.notifyEditHistoryListeners();
    }

    @Override
    public void rightButtonPressedOnItem(int x, int y) {
        System.out.println(" Right button pressed (so what?) ");
    }

    @Override
    public void clientAddToSelection(Item item) {
        this.project.getMultiEventSelection().addSelected((MultiEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    @Override
    public void clientRemoveFromSelection(Item item) {
        this.project.getMultiEventSelection().removeSelected((MultiEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    @Override
    public int getHoverStateAt(Point p) {
        int endTol = 20;
        int tol = 20;
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (!(focusPart instanceof MidiPart)) {
            return 0;
        }
        Iterable<MultiEvent> list = focusPart == null ? this.eventsOnScreen : this.eventsInFocus;
        for (MultiEvent e : list) {
            assert (this.isValidEvent(e));
            Rectangle rect = this.getItemBounds(e);
            if (!rect.contains(p)) continue;
            return 4;
        }
        return 0;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent arg0) {
        this.setX(arg0.getValue());
    }

    void makeTools() {
        Cursor c = new Cursor(0);
        this.selectTool = new SelectTool(c);
        this.rectZoomTool = new RectZoomTool(c);
        this.writeTool = new WriteTool(MyCursors.getCursor("pencil"));
        this.eraseTool = new EraseTool(MyCursors.getCursor("eraser"));
        this.dragViewTool = new DragViewTool(MyCursors.getCursor("move"));
    }

    public void setControllerType(ControllerHandle handle) {
        this.cntrl = handle;
        this.setDirty();
        this.repaintItems();
    }

    @Override
    public final boolean isValidEvent(MultiEvent ev) {
        if (this.cntrl == null) {
            return false;
        }
        return this.cntrl.isValid(ev);
    }

    @Override
    protected void writeReleasedAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (focusPart == null || !(focusPart instanceof MidiPart)) {
            return;
        }
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
    }

    public void selectAll() {
        Part focus = (Part)this.project.getPartSelection().getFocus();
        if (focus == null) {
            return;
        }
        Vector<MultiEvent> events = new Vector<MultiEvent>();
        for (MultiEvent e : this.eventsInFocus) {
            events.add(e);
        }
        this.project.getMultiEventSelection().setSelected(events);
        this.project.getMultiEventSelection().notifyListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NoteOnScreenIterator
    implements Iterator<MultiEvent> {
        Iterator<Part> partIter = null;
        Iterator<MultiEvent> noteIter = null;

        NoteOnScreenIterator() {
            this.partIter = ControllerView.this.project.getPartSelection().getSelected().iterator();
            this.advanceToNextMidiPart();
        }

        private boolean advanceToNextMidiPart() {
            Part part = null;
            while (this.partIter.hasNext()) {
                part = this.partIter.next();
                if (!(part instanceof MidiPart)) continue;
                this.noteIter = ((MidiPart)part).getMultiEvents().iterator();
                return true;
            }
            this.noteIter = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.noteIter == null) {
                return false;
            }
            if (this.noteIter.hasNext()) {
                return true;
            }
            return this.advanceToNextMidiPart();
        }

        @Override
        public MultiEvent next() {
            if (this.noteIter.hasNext()) {
                MultiEvent ev = this.noteIter.next();
                return ev;
            }
            if (this.advanceToNextMidiPart()) {
                return this.next();
            }
            return null;
        }

        @Override
        public void remove() {
            assert (false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NoteOnScreenCollection
    implements Collection<MultiEvent> {
        NoteOnScreenCollection() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<MultiEvent> iterator() {
            return new NoteOnScreenIterator();
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean add(MultiEvent o) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends MultiEvent> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }
    }
}

