/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.sequencer.gui.MyAbstractTableModel;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.MultiEventChangeRecorder;
import com.frinika.sequencer.model.NoteEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteEventTableModel
extends MyAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] ColumnNames = new String[]{"Time", "Note", "Vel", "Len"};
    static final int COLUMN_TIME = 0;
    static final int COLUMN_NOTEORCC = 1;
    static final int COLUMN_VELORVAL = 2;
    static final int COLUMN_LEN = 3;
    static final int COLUMNS = ColumnNames.length;
    NoteEvent note;
    long startTick;
    int ticksPerBeat;
    int quantize;

    public NoteEventTableModel(NoteEvent note, int quantize, int ticksPerBeat) {
        this.note = note;
        this.quantize = quantize;
        this.ticksPerBeat = ticksPerBeat;
    }

    void setNote(NoteEvent note) {
        this.note = note;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        return ColumnNames[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMNS;
    }

    @Override
    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 10;
    }

    @Override
    public Object getValueAt(int row, int columnIndex) {
        if (this.note == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return (double)this.note.getStartTick() / (double)this.ticksPerBeat;
            }
            case 1: {
                return this.note.getNoteName();
            }
            case 2: {
                return this.note.getVelocity();
            }
            case 3: {
                return (double)this.note.getDuration() / (double)this.ticksPerBeat;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(final Object value, int row, int columnIndex) {
        if (this.note == null) {
            return;
        }
        NoteEvent me = this.note;
        switch (columnIndex) {
            case 0: {
                final long newTick = (long)((Double)value * (double)this.ticksPerBeat);
                new MultiEventChangeRecorder("move event", me){

                    public void doChange(MultiEvent me) {
                        NoteEventTableModel.this.note.setStartTick(newTick);
                    }
                };
                break;
            }
            case 2: {
                new MultiEventChangeRecorder("change velocity", me){

                    public void doChange(MultiEvent me) {
                        ((NoteEvent)me).setVelocity((Integer)value);
                    }
                };
                break;
            }
            case 3: {
                new MultiEventChangeRecorder("change duration", me){

                    public void doChange(MultiEvent me) {
                        NoteEventTableModel.this.note.setDuration((long)((Double)value * (double)NoteEventTableModel.this.ticksPerBeat));
                    }
                };
            }
        }
        System.out.println(value + " " + row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}

