/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.pianoroll.PianoRoll;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.JPanel;

public class VirtualPianoVert
extends JPanel
implements MouseListener,
AdjustmentListener {
    private static final long serialVersionUID = 1L;
    final int ON = 0;
    final int OFF = 1;
    final Color jfcBlue = new Color(204, 204, 255);
    final Color pink = new Color(255, 175, 175);
    Vector<Key> blackKeys = new Vector();
    Key[] keys = new Key[128];
    Vector<Key> whiteKeys = new Vector();
    Key prevKey;
    int lastKeyPress = 0;
    final int nNote = 128;
    final int nWhiteNote = 75;
    final int nOctave = 11;
    int whiteKeyWidth;
    int blackKeyDepth = 20;
    int keyDepth = 30;
    int blackWhiteGap;
    PianoRoll pianoRoll;
    int timePanelHeight;
    private int yScroll;
    int yBot;
    int noteItemHeight;
    Config config = null;

    public VirtualPianoVert(Config config) {
        super(false);
        this.config = config;
        this.pianoRoll = null;
        this.timePanelHeight = 0;
        this.yScroll = 0;
        this.resizeKeys();
        this.addMouseListener(this);
        this.setBackground(Color.ORANGE);
    }

    public VirtualPianoVert(PianoRoll pr, int yTop, int yScroll) {
        super(false);
        this.pianoRoll = pr;
        this.timePanelHeight = yTop;
        this.yScroll = yScroll;
        this.resizeKeys();
        this.addMouseListener(this);
        this.setBackground(Color.ORANGE);
    }

    private void resizeKeys() {
        int keyNum;
        this.blackKeys.clear();
        this.whiteKeys.clear();
        if (this.config == null) {
            this.noteItemHeight = Layout.getNoteItemHeight();
        } else {
            this.noteItemHeight = this.config.noteHeight;
            this.keyDepth = this.config.keyDepth;
        }
        this.whiteKeyWidth = this.noteItemHeight * 12 / 7;
        this.blackWhiteGap = this.whiteKeyWidth / 3;
        int[] whiteIDs = new int[]{0, 2, 4, 5, 7, 9, 11};
        this.yBot = 129 * this.noteItemHeight - this.whiteKeyWidth;
        this.setSize(new Dimension(this.keyDepth, this.yBot));
        this.setPreferredSize(new Dimension(this.keyDepth, this.yBot));
        this.setMaximumSize(new Dimension(this.keyDepth, 20000));
        int y = 0;
        for (int i = 0; i < 11; ++i) {
            int keyNum2;
            int j = 0;
            while (j < 7 && (keyNum2 = i * 12 + whiteIDs[j]) < 128) {
                this.whiteKeys.add(new Key(0, this.yBot - y, this.keyDepth, this.whiteKeyWidth, keyNum2));
                ++j;
                y += this.whiteKeyWidth;
            }
        }
        int halfGap = this.blackWhiteGap / 2;
        int yBot1 = this.yBot + 7 * this.whiteKeyWidth / 8;
        int blackKeyWidth = 2 * this.whiteKeyWidth / 3;
        int i = 0;
        int y2 = 0;
        while (i < 11 && (keyNum = i * 12) < 127) {
            this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap / 2, this.blackKeyDepth, blackKeyWidth, keyNum + 1));
            if (keyNum >= 125) break;
            this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - 3 * halfGap / 2, this.blackKeyDepth, blackKeyWidth, keyNum + 3));
            if (keyNum >= 122) break;
            y2 += this.whiteKeyWidth;
            this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap / 2 + 1, this.blackKeyDepth, blackKeyWidth, keyNum + 6));
            if (keyNum >= 120) break;
            this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap, this.blackKeyDepth, blackKeyWidth, keyNum + 8));
            if (keyNum >= 118) break;
            this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - 3 * halfGap / 2 - 1, this.blackKeyDepth, blackKeyWidth, keyNum + 10));
            ++i;
            y2 += this.whiteKeyWidth;
        }
        Iterator<Key> i$ = this.blackKeys.iterator();
        while (i$.hasNext()) {
            Key key;
            this.keys[key.kNum] = key = i$.next();
        }
        i$ = this.whiteKeys.iterator();
        while (i$.hasNext()) {
            Key key;
            this.keys[key.kNum] = key = i$.next();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.prevKey = this.getKey(e.getPoint());
        if (this.prevKey != null) {
            this.prevKey.on();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
            this.prevKey = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public Key getKey(Point point) {
        point.translate(0, -this.timePanelHeight + this.yScroll);
        for (Key key : this.blackKeys) {
            if (key == null || !key.contains(point)) continue;
            return key;
        }
        for (Key key : this.whiteKeys) {
            if (key == null || !key.contains(point)) continue;
            return key;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        Key key;
        int i;
        super.paintComponent(g);
        if (this.config == null && this.noteItemHeight != Layout.getNoteItemHeight() || this.config != null && this.noteItemHeight != this.config.noteHeight) {
            this.resizeKeys();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(0, this.timePanelHeight - this.yScroll);
        g2.setColor(Color.PINK);
        g2.fillRect(0, 0, this.keyDepth, this.yBot);
        for (i = 0; i < this.whiteKeys.size(); ++i) {
            key = this.whiteKeys.get(i);
            if (key.isNoteOn() || this.config != null && key.kNum == this.lastKeyPress) {
                g2.setColor(this.jfcBlue);
                g2.fill(key);
            }
            g2.setColor(Color.black);
            g2.draw(key);
            if (key.kNum % 12 != 0) continue;
            g2.setColor(Color.BLACK);
            g2.drawString(String.valueOf(key.kNum / 12), this.keyDepth - 15, key.y + key.height - 1);
        }
        for (i = 0; i < this.blackKeys.size(); ++i) {
            key = this.blackKeys.get(i);
            if (key.isNoteOn() || this.config != null && key.kNum == this.lastKeyPress) {
                g2.setColor(this.jfcBlue);
                g2.fill(key);
                g2.setColor(Color.black);
                g2.draw(key);
                continue;
            }
            g2.setColor(Color.black);
            g2.fill(key);
        }
        g2.translate(0, -(this.timePanelHeight - this.yScroll));
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.yScroll = e.getValue();
        this.repaint();
    }

    public int getLastKeytPress() {
        return this.lastKeyPress;
    }

    public Key getKey(int i) {
        return this.keys[i];
    }

    public class Key
    extends Rectangle {
        private static final long serialVersionUID = 1L;
        Receiver recv;
        int chan;
        int noteState;
        int kNum;

        public Key(int x, int y, int width, int height, int num) {
            super(x, y, width, height);
            this.recv = null;
            this.chan = 0;
            this.noteState = 1;
            this.kNum = num;
        }

        public boolean isNoteOn() {
            return this.noteState == 0;
        }

        public void on() {
            this.setNoteState(0);
            if (VirtualPianoVert.this.config == null) {
                if (VirtualPianoVert.this.pianoRoll == null) {
                    return;
                }
                Part focusPart = (Part)VirtualPianoVert.this.pianoRoll.getProjectContainer().getPartSelection().getFocus();
                if (focusPart == null || !(focusPart instanceof MidiPart)) {
                    return;
                }
                MidiLane lane = (MidiLane)focusPart.getLane();
                this.recv = lane.getReceiver();
                this.chan = lane.getMidiChannel();
            } else {
                this.recv = VirtualPianoVert.this.config.recv;
                this.chan = VirtualPianoVert.this.config.lane.getMidiChannel();
            }
            if (this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(144, this.chan, this.kNum, 100);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.recv.send(shm, -1L);
        }

        public void off() {
            this.setNoteState(1);
            if (this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(144, this.chan, this.kNum, 0);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.recv.send(shm, -1L);
            this.recv = null;
        }

        public void setNoteState(int state) {
            this.noteState = state;
            if (state == 0) {
                VirtualPianoVert.this.lastKeyPress = this.kNum;
            }
        }
    }

    public static class Config {
        final int noteHeight;
        final int keyDepth;
        public Receiver recv;
        public MidiLane lane;

        public Config(int keyDepth, int noteHeight, Receiver recv, MidiLane lane) {
            this.noteHeight = noteHeight;
            this.keyDepth = keyDepth;
            this.recv = recv;
            this.lane = lane;
        }

        public void setReceiver(Receiver recv2) {
            this.recv = recv2;
        }
    }
}

