/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.selection;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.pianoroll.DragEventListener;
import com.frinika.sequencer.gui.pianoroll.FeedbackEventListener;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragList
extends Vector<Item> {
    private ProjectContainer project;
    transient Vector<DragEventListener> dragEventListeners;
    transient Vector<FeedbackEventListener> feedbackEventListeners;
    private Item dragItem;

    public DragList(ProjectContainer project) {
        this.project = project;
        this.dragEventListeners = new Vector();
        this.feedbackEventListeners = new Vector();
    }

    public void endDrag(boolean copy) {
        if (this.project.getMultiEventSelection().getSelected().isEmpty()) {
            System.out.println(" Selected list empty in pianoroll endDrag (why did you bother dragging nothing ?) ");
            this.project.getDragList().clear();
            return;
        }
        if (!copy) {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.drag_move_notes"));
            Iterator iter = this.project.getDragList().iterator();
            Vector list = new Vector(this.project.getMultiEventSelection().getSelected());
            for (MultiEvent ev : list) {
                ev.getPart().remove(ev);
                ev.restoreFromClone((MultiEvent)iter.next());
                ev.getPart().add(ev);
            }
            assert (!iter.hasNext());
            this.project.getMultiEventSelection().setSelected(list);
        } else {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.drag_copy_notes"));
            Iterator iter = this.project.getDragList().iterator();
            for (MultiEvent ev : this.project.getMultiEventSelection().getSelected()) {
                ev.getPart().add((MultiEvent)iter.next());
            }
            this.project.getMultiEventSelection().setSelected(this.project.getDragList());
            assert (!iter.hasNext());
        }
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getMultiEventSelection().notifyListeners();
        this.clear();
        this.notifyFeedbackItemListeners((Item)this.project.getMultiEventSelection().getFocus());
        this.notifyDragEventListeners();
    }

    public void endDragController() {
        if (this.project.getMultiEventSelection().getSelected().isEmpty()) {
            System.out.println(" Selected list empty in controllerview endDrag (why did you bother dragging nothing ? ) ");
            return;
        }
        this.project.getEditHistoryContainer().mark("drag velocity");
        Iterator iter = this.iterator();
        Vector list = new Vector(this.project.getMultiEventSelection().getSelected());
        for (MultiEvent ev : list) {
            ev.getPart().remove(ev);
            ev.restoreFromClone((MultiEvent)iter.next());
            ev.getPart().add(ev);
        }
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.clear();
    }

    public void startDrag(Item dragItemRef) {
        DragList dragList = this.project.getDragList();
        dragList.clear();
        for (MultiEvent it : this.project.getMultiEventSelection().getSelected()) {
            if (!(it instanceof NoteEvent)) continue;
            try {
                NoteEvent dragNote = (NoteEvent)it.clone();
                dragList.add(dragNote);
                if (it != dragItemRef) continue;
                this.dragItem = dragNote;
                this.notifyFeedbackItemListeners(dragNote);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public void addDragEventListener(DragEventListener o) {
        this.dragEventListeners.add(o);
    }

    public void removeDragEventListener(DragEventListener o) {
        this.dragEventListeners.add(o);
    }

    public void notifyDragEventListeners() {
        for (DragEventListener l : this.dragEventListeners) {
            l.update();
        }
    }

    public void addFeedbackItemListener(FeedbackEventListener o) {
        this.feedbackEventListeners.add(o);
    }

    public void removeFeedbackItemListener(FeedbackEventListener o) {
        this.feedbackEventListeners.add(o);
    }

    public void notifyFeedbackItemListeners(Item ev) {
        for (FeedbackEventListener l : this.feedbackEventListeners) {
            l.notifyFeedbackItemChanged(ev);
        }
    }

    public void notifyFeedbackItemListeners() {
        for (FeedbackEventListener l : this.feedbackEventListeners) {
            l.notifyFeedbackItemChanged(this.dragItem);
        }
    }
}

