/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.selection;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.selection.MultiEventSelection;
import com.frinika.sequencer.gui.selection.PartSelection;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiSelection
extends MultiEventSelection
implements SelectionListener {
    protected Collection<JMenuItem> menuItems = new ArrayList<JMenuItem>();

    public MidiSelection(ProjectContainer project) {
        super(project);
        project.getPartSelection().addSelectionListener(this);
        project.getMultiEventSelection().addSelectionListener(this);
    }

    public void selectionChanged(SelectionContainer sc) {
        MultiEventSelection mes;
        Vector r = null;
        if (sc instanceof PartSelection && (mes = this.project.getMultiEventSelection()) != null) {
            r = (Vector)mes.getSelected();
            if (!r.isEmpty()) {
                sc = mes;
            } else {
                r = null;
            }
        }
        if (r == null) {
            Collection<Selectable> sel = sc.getSelected();
            r = MidiSelection.getMultiEventsFromSelection(sel);
        }
        this.selectedList = !r.isEmpty() ? r : null;
        this.updateItems();
        this.dirty = true;
        this.notifyListeners();
    }

    @Override
    public void setMetaFocus() {
    }

    public boolean isSelectionAvailable() {
        boolean b = this.selectedList != null && !this.selectedList.isEmpty();
        return b;
    }

    public MidiPart getMidiPart() {
        Part p;
        Collection partSelection = this.project.getPartSelection().getSelected();
        if (partSelection != null && !partSelection.isEmpty() && (p = (Part)partSelection.iterator().next()) instanceof MidiPart) {
            return (MidiPart)p;
        }
        if (this.selectedList != null && !this.selectedList.isEmpty()) {
            MultiEvent event = (MultiEvent)this.selectedList.firstElement();
            return event.getMidiPart();
        }
        return null;
    }

    public MidiLane getMidiLane() {
        MidiPart p = this.getMidiPart();
        if (p != null) {
            return (MidiLane)p.getLane();
        }
        return null;
    }

    protected static Vector<MultiEvent> getMultiEventsFromSelection(Collection<Selectable> sel) {
        Vector<MultiEvent> c = new Vector<MultiEvent>();
        for (Selectable o : sel) {
            if (o instanceof MidiPart) {
                for (MultiEvent me : ((MidiPart)o).getMultiEvents()) {
                    c.add(me);
                }
                continue;
            }
            if (!(o instanceof MultiEvent)) continue;
            c.add((MultiEvent)o);
        }
        return c;
    }

    public void addMenuItem(JMenuItem item) {
        this.menuItems.add(item);
        item.setEnabled(this.isSelectionAvailable());
    }

    protected void updateItems() {
        boolean b = this.isSelectionAvailable();
        for (JMenuItem item : this.menuItems) {
            item.setEnabled(b);
        }
    }
}

