/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.tracker;

import com.frinika.sequencer.gui.tracker.TrackerPanel;
import com.frinika.sequencer.gui.virtualkeyboard.NoteKeyThread;
import com.frinika.sequencer.gui.virtualkeyboard.VirtualKeyboard;
import java.awt.event.KeyEvent;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class MultiEventCellComponent
extends JTextField {
    private static final long serialVersionUID = 1L;
    public static final int EVENT_VALUE_DELETE = -2101;
    public static final int EVENT_VALUE_PITCH_BEND = -128;
    public static final int EVENT_VALUE_SYSEX = -129;
    private Integer eventValue = -2808;
    private TrackerPanel trackerPanel;
    private NoteKeyThread[] noteKeyThreads = new NoteKeyThread[128];

    public MultiEventCellComponent(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        try {
            if (e.getKeyCode() == 127) {
                this.eventValue = -2101;
            } else if (e.isControlDown() && e.getKeyChar() >= '0' && e.getKeyChar() <= '9') {
                if (pressed) {
                    if (this.getText().length() <= 3) {
                        this.setText("CC0" + e.getKeyChar());
                    } else {
                        this.setText("CC" + this.getText().charAt(3) + "" + e.getKeyChar());
                    }
                    this.eventValue = -1 * Integer.parseInt(this.getText().substring(2));
                }
            } else if (e.isControlDown() && e.getKeyCode() == 80) {
                this.setText("PB");
                this.eventValue = -128;
            } else if (e.isControlDown() && e.isAltDown() && e.getKeyCode() == 83) {
                this.setText("SYX");
                this.eventValue = -129;
            } else if (e.getModifiers() == 0) {
                final int note = VirtualKeyboard.keyToInt(e.getKeyChar());
                this.eventValue = note;
                if (this.trackerPanel.getAutomaticRowJump() > 0) {
                    JTable trackerTable = this.trackerPanel.getTable();
                    trackerTable.getCellEditor().stopCellEditing();
                    trackerTable.changeSelection(trackerTable.getSelectedRow() + this.trackerPanel.getAutomaticRowJump(), trackerTable.getSelectedColumn(), false, false);
                    new Thread(){

                        public void run() {
                            VirtualKeyboard.noteOn(MultiEventCellComponent.this.getReceiver(), note, MultiEventCellComponent.this.trackerPanel.getPart().getMidiChannel(), MultiEventCellComponent.this.trackerPanel.getTableModel().getEditVelocity());
                            try {
                                Thread.sleep(300L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            VirtualKeyboard.noteOff(MultiEventCellComponent.this.getReceiver(), note, MultiEventCellComponent.this.trackerPanel.getPart().getMidiChannel());
                        }
                    }.start();
                } else if (this.noteKeyThreads[note] == null) {
                    if (this.getReceiver() != null) {
                        this.noteKeyThreads[note] = new NoteKeyThread(this.noteKeyThreads, this.getReceiver(), note, this.trackerPanel.getPart().getMidiChannel(), this.trackerPanel.getTableModel().getEditVelocity());
                    }
                    this.setText(VirtualKeyboard.getNoteString(note));
                } else {
                    this.noteKeyThreads[note].addKeyEvent(e);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }

    private Receiver getReceiver() {
        try {
            MidiDevice midiDevice = this.trackerPanel.getPart().getTrack().getMidiDevice();
            if (midiDevice != null) {
                return midiDevice.getReceiver();
            }
            return null;
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getEventValue() {
        return this.eventValue;
    }
}

