/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.sysex;

import com.frinika.sequencer.midi.sysex.E70SysexMacroAbstract;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

public class E70fx
extends E70SysexMacroAbstract {
    public static final int ADDR_OFFSET_REVERB = 21;
    public static final int ADDR_OFFSET_CHORUS = 22;
    public static final String[] REVERB_TYPES = new String[]{"Off", "Room1", "Room2", "Room3", "Hall1", "Hall2", "Plate", "Delay", "Panning"};
    public static final String[] CHORUS_TYPES = new String[]{"Off", "Chorus1", "Chorus2", "Chorus3", "Chorus4", "Feedback", "Flanger", "Delay1", "Delay2"};

    public String usage() {
        return "Usage: e70fx <reverb-type> <reverb-intensity> <chorus-type> <chorus-intensity>  [ <user-prg> ] [ <use-prg-change> ]";
    }

    public MidiMessage[] parseMessages(String macro) throws InvalidMidiDataException {
        String[] args = E70fx.splitArgs(macro);
        int usrPrg = 0;
        int chn = 15;
        if (args.length > 4) {
            usrPrg = E70fx.parseInt(args[4], 10);
        }
        if (args.length > 5) {
            chn = E70fx.parseInt(args[5], 10);
        }
        byte[] data = this.parse(args);
        SysexMessage syxm = new SysexMessage();
        syxm.setMessage(data, data.length);
        if (chn >= 0 && chn <= 15) {
            int otherUsrPrg = usrPrg == 0 ? 1 : 0;
            MidiMessage[] prgChg = E70fx.usrPrgChg(otherUsrPrg, chn);
            MidiMessage[] prgChgBack = E70fx.usrPrgChg(usrPrg, chn);
            MidiMessage[] mm = new MidiMessage[]{prgChg[0], prgChg[1], prgChg[2], syxm, prgChgBack[0], prgChgBack[1], prgChgBack[2]};
            return mm;
        }
        return new MidiMessage[]{syxm};
    }

    public byte[] parse(String[] args) throws InvalidMidiDataException {
        if (args.length < 4) {
            this.error("At least 4 parameters are required.");
        }
        int reverbType = this.parseType(args[0], REVERB_TYPES);
        int reverbIntensity = E70fx.parseInt(args[1], 10, 1, 8);
        int chorusType = this.parseType(args[2], CHORUS_TYPES);
        int chorusIntensity = E70fx.parseInt(args[3], 10, 1, 8);
        int usrPrg = 0;
        if (args.length > 4) {
            usrPrg = E70fx.parseInt(args[4], 10, 0, 99);
        }
        if (reverbIntensity > 0) {
            --reverbIntensity;
        }
        if (chorusIntensity > 0) {
            --chorusIntensity;
        }
        byte reverbData = (byte)(reverbType << 4 & 0xF0 | reverbIntensity & 0xF);
        byte chorusData = (byte)(chorusType << 4 & 0xF0 | chorusIntensity & 0xF);
        return this.e70UserProgramSet(usrPrg, 21, new byte[]{reverbData, chorusData});
    }
}

