/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.sysex;

import com.frinika.sequencer.model.AbstractSysexMacro;

abstract class RolandSysexMacroAbstract
extends AbstractSysexMacro {
    public static final byte DEVICE_ID_ROLAND = 16;
    public static final byte COMMAND_SYSEX_SET = 18;
    public static final byte COMMAND_SYSEX_REQUEST = 17;

    RolandSysexMacroAbstract() {
    }

    public void checksum(byte[] data) {
        byte c;
        int l = data.length;
        data[l - 2] = c = RolandSysexMacroAbstract.calculateChecksum(data, 5, l - 3);
    }

    protected byte[] rolandSysexSet(byte modelId, int addr, byte[] data) {
        data = RolandSysexMacroAbstract.nibblize(data);
        return this.rolandSysexSetRaw(modelId, addr, data);
    }

    protected byte[] rolandSysexSetRaw(byte modelId, int addr, byte[] data) {
        byte[] a = new byte[10 + data.length];
        int deviceId = 16;
        int cmd = 18;
        a[0] = -16;
        a[1] = 65;
        a[2] = deviceId;
        a[3] = modelId;
        a[4] = cmd;
        a[5] = (byte)(addr >> 16 & 0xFF);
        a[6] = (byte)(addr >> 8 & 0xFF);
        a[7] = (byte)(addr & 0xFF);
        System.arraycopy(data, 0, a, 8, data.length);
        a[a.length - 1] = -9;
        this.checksum(a);
        return a;
    }

    protected byte[] rolandSysexReq(byte modelId, int addr, int size) {
        byte[] a = new byte[13];
        a[0] = -16;
        a[1] = 65;
        a[2] = 16;
        a[3] = modelId;
        a[4] = 17;
        a[5] = (byte)(addr >> 16 & 0xFF);
        a[6] = (byte)(addr >> 8 & 0xFF);
        a[7] = (byte)(addr & 0xFF);
        a[8] = (byte)(size >> 16 & 0xFF);
        a[9] = (byte)(size >> 8 & 0xFF);
        a[10] = (byte)(size & 0xFF);
        a[12] = -9;
        this.checksum(a);
        return a;
    }

    public static byte[] nibblize(byte[] data) {
        byte[] nibbles = new byte[2 * data.length];
        int j = 0;
        boolean up = false;
        int b = 0;
        for (int i = 0; i < nibbles.length; ++i) {
            if (up) {
                nibbles[i] = (byte)(b >> 4 & 0xF);
                up = false;
                continue;
            }
            b = data[j++];
            nibbles[i] = (byte)(b & 0xF);
            up = true;
        }
        return nibbles;
    }

    public static byte[] denibblize(byte[] nibbles) {
        byte[] data = new byte[nibbles.length / 2];
        int j = 0;
        boolean up = true;
        byte b = nibbles[0];
        for (int i = 1; i < nibbles.length; ++i) {
            if (up) {
                data[j++] = (byte)(b | nibbles[i] << 4);
                up = false;
                continue;
            }
            b = nibbles[i];
            up = true;
        }
        return data;
    }

    public static byte calculateChecksum(byte[] data, int from, int to) {
        int sum = 0;
        for (int i = from; i <= to; ++i) {
            sum += data[i];
        }
        return (byte)(128 - sum % 128);
    }
}

