/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.gui.OptionsEditor;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.gui.menu.RepeatAction;
import com.frinika.sequencer.gui.menu.SplitSelectedPartsAction;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.CommitListener;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.EditHistoryRecorder;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.MultiEventEndTickComparable;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.PitchBendEvent;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.SubsetMultiEvent;
import com.frinika.sequencer.model.tempo.TempoList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiPart
extends Part
implements EditHistoryRecorder<MultiEvent> {
    private static final long serialVersionUID = 1L;
    String name;
    TreeSet<MultiEvent> multiEvents = new TreeSet();
    Collection<CommitListener> commitListeners = null;
    transient TreeSet<MultiEventEndTickComparable> multiEventEndTickComparables = new TreeSet();

    public MidiPart() {
    }

    public MidiPart(MidiLane lane) {
        super(lane);
    }

    public void setBoundsFromEvents() {
        if (this.multiEvents.size() > 0) {
            this.setStartTick(this.multiEvents.first().getStartTick());
            if (this.multiEventEndTickComparables.size() > 0) {
                this.setEndTick(this.multiEventEndTickComparables.last().getMultiEvent().getEndTick());
            } else {
                this.setEndTick(this.multiEvents.last().getStartTick());
            }
        } else {
            System.err.println(" Warning attempt to set bounds for an empty part");
            this.setStartTick(0.0);
            this.setEndTick(1.0);
        }
    }

    public void importFromMidiTrack(long startTickArg, long endTickArg) {
        HashMap<Integer, NoteEvent> pendingNoteEvents = new HashMap<Integer, NoteEvent>();
        FrinikaTrackWrapper track = ((MidiLane)this.lane).getTrack();
        for (int n = 0; n < track.size(); ++n) {
            MidiEvent event = track.get(n);
            try {
                if (!(event.getMessage() instanceof ShortMessage)) continue;
                ShortMessage shm = (ShortMessage)event.getMessage();
                if (shm.getCommand() == 144 || shm.getCommand() == 128) {
                    if (shm.getCommand() == 128 || shm.getData2() == 0) {
                        NoteEvent noteEvent = (NoteEvent)pendingNoteEvents.get(shm.getChannel() << 8 | shm.getData1());
                        if (noteEvent == null) {
                            System.err.println("NoteOff event without start event, PLEASE FIX ME  in MidiPart ");
                            continue;
                        }
                        noteEvent.setEndEvent(event);
                        pendingNoteEvents.remove(shm.getChannel() << 8 | shm.getData1());
                        this.multiEvents.add(noteEvent);
                    } else if (event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                        pendingNoteEvents.put(shm.getChannel() << 8 | shm.getData1(), new NoteEvent(this, event));
                    }
                } else if (shm.getCommand() == 176) {
                    if (event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                        this.multiEvents.add(new ControllerEvent(this, event.getTick(), shm.getData1(), shm.getData2()));
                    }
                } else if (shm.getCommand() == 224 && event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                    this.multiEvents.add(new PitchBendEvent(this, event.getTick(), (shm.getData1() | shm.getData2() << 7) & Short.MAX_VALUE));
                }
                if (event.getTick() < endTickArg || pendingNoteEvents.size() != 0) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pendingNoteEvents.size() != 0) {
            System.err.println(" Some notes did not have a noteoff event ");
        }
        for (MultiEvent e : this.multiEvents) {
            e.zombie = false;
            if (!(e instanceof NoteEvent)) continue;
            ((NoteEvent)e).validate();
        }
        this.rebuildMultiEventEndTickComparables();
        this.setBoundsFromEvents();
    }

    public void importFromMidiTrack(Track track, long startTickArg, long endTickArg) {
        HashMap<Integer, NoteEvent> pendingNoteEvents = new HashMap<Integer, NoteEvent>();
        for (int n = 0; n < track.size(); ++n) {
            MidiEvent event = track.get(n);
            try {
                if (!(event.getMessage() instanceof ShortMessage)) continue;
                ShortMessage shm = (ShortMessage)event.getMessage();
                if (shm.getCommand() == 144 || shm.getCommand() == 128) {
                    if (shm.getCommand() == 128 || shm.getData2() == 0) {
                        NoteEvent noteEvent = (NoteEvent)pendingNoteEvents.get(shm.getChannel() << 8 | shm.getData1());
                        if (noteEvent == null) {
                            System.err.println("NoteOff event without start event, PLEASE FIX ME  in MidiPart ");
                            continue;
                        }
                        noteEvent.setEndEvent(event);
                        pendingNoteEvents.remove(shm.getChannel() << 8 | shm.getData1());
                        this.multiEvents.add(noteEvent);
                    } else if (event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                        pendingNoteEvents.put(shm.getChannel() << 8 | shm.getData1(), new NoteEvent(this, event));
                    }
                } else if (shm.getCommand() == 176) {
                    if (event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                        this.multiEvents.add(new ControllerEvent(this, event.getTick(), shm.getData1(), shm.getData2()));
                    }
                } else if (shm.getCommand() == 224 && event.getTick() >= startTickArg && event.getTick() < endTickArg) {
                    this.multiEvents.add(new PitchBendEvent(this, event.getTick(), (shm.getData1() | shm.getData2() << 7) & Short.MAX_VALUE));
                }
                if (event.getTick() < endTickArg || pendingNoteEvents.size() != 0) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pendingNoteEvents.size() != 0) {
            System.err.println(" Some notes did not have a noteoff event ");
        }
        for (MultiEvent e : this.multiEvents) {
            e.zombie = false;
            if (!(e instanceof NoteEvent)) continue;
            ((NoteEvent)e).validate();
        }
        this.rebuildMultiEventEndTickComparables();
        this.setBoundsFromEvents();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void add(MultiEvent ev) {
        ev.part = this;
        ev.commitAdd();
        this.multiEvents.add(ev);
        if (this.multiEventEndTickComparables != null) {
            this.multiEventEndTickComparables.add(ev.getMultiEventEndTickComparable());
        }
        if (this.lane != null) {
            this.getEditHistoryContainer().push(this, 0, ev);
        }
    }

    @Override
    public void remove(MultiEvent multiEvent) {
        multiEvent.commitRemove();
        this.multiEvents.remove(multiEvent);
        if (this.multiEventEndTickComparables != null) {
            this.multiEventEndTickComparables.remove(multiEvent.getMultiEventEndTickComparable());
        }
        this.lane.project.getMultiEventSelection().removeSelected(multiEvent);
        this.getEditHistoryContainer().push(this, 1, multiEvent);
    }

    @Override
    public void commitEventsRemove() {
        if (this.multiEvents == null) {
            return;
        }
        for (MultiEvent e : this.multiEvents) {
            if (e.isZombie()) continue;
            e.commitRemove();
        }
    }

    public SortedSet<MultiEvent> getMultiEvents() {
        return this.multiEvents;
    }

    public SortedSet<MultiEvent> getMultiEventSubset(long startTick, long endTick) {
        return this.multiEvents.subSet(new SubsetMultiEvent(startTick), new SubsetMultiEvent(endTick));
    }

    public FrinikaTrackWrapper getTrack() {
        return ((MidiLane)this.lane).getTrack();
    }

    public int getMidiChannel() {
        return this.getTrack().getMidiChannel();
    }

    public EditHistoryContainer getEditHistoryContainer() {
        return this.getLane().getProject().getEditHistoryContainer();
    }

    @Override
    protected void moveItemsBy(long deltaTick) {
        Vector<MultiEvent> list = new Vector<MultiEvent>();
        for (MultiEvent ev : this.multiEvents) {
            list.add(ev);
        }
        for (MultiEvent ev : list) {
            long newTick = deltaTick + ev.getStartTick();
            this.remove(ev);
            ev.setStartTick(newTick);
            this.add(ev);
        }
    }

    @Override
    public void moveContentsBy(double dTick, Lane dstLane) {
        this.setStartTick((double)this.getStartTick() + dTick);
        this.setEndTick((double)this.getEndTick() + dTick);
        this.commitEventsRemove();
        if (dstLane != this.lane) {
            this.lane.getParts().remove(this);
            dstLane.getParts().add(this);
            this.lane = dstLane;
        }
        for (MultiEvent ev : this.multiEvents) {
            long newTick = (long)(dTick + (double)ev.getStartTick());
            ev.setStartTick(newTick);
        }
        this.commitEventsAdd();
    }

    @Override
    public void restoreFromClone(EditHistoryRecordable o) {
        MidiPart clone = (MidiPart)o;
        this.lane = clone.lane;
        this.setStartTick(clone.getStartTick());
        this.setEndTick(clone.getEndTick());
        this.selected = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MidiPart clone = new MidiPart();
        clone.lane = this.lane;
        clone.setStartTick(this.getStartTick());
        clone.setEndTick(this.getEndTick());
        clone.selected = false;
        return clone;
    }

    @Override
    public void commitEventsAdd() {
        if (this.multiEvents == null) {
            return;
        }
        for (MultiEvent multiEvent : this.multiEvents) {
            long tick = multiEvent.getStartTick();
            if (tick < this.getStartTick() || tick >= this.getEndTick()) continue;
            multiEvent.commitAdd();
        }
    }

    @Override
    public void copyBy(double deltaTick, Lane dst) {
        MidiPart part = new MidiPart((MidiLane)dst);
        SortedSet<MultiEvent> events = this.getMultiEvents();
        part.setStartTick((double)this.getStartTick() + deltaTick);
        part.setEndTick((double)this.getEndTick() + deltaTick);
        for (MultiEvent ev : events) {
            try {
                MultiEvent newEv = (MultiEvent)ev.clone();
                double newTick = deltaTick + (double)ev.getStartTick();
                newEv.setStartTick((long)newTick);
                part.add(newEv);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Selectable deepCopy(Selectable parent) {
        MidiPart clone = parent != null ? (MidiPart)((MidiLane)parent).createPart() : new MidiPart();
        clone.setStartTick(this.getStartTick());
        clone.setEndTick(this.getEndTick());
        if (parent == null) {
            clone.lane = this.lane;
        }
        clone.name = "Copy of " + this.name;
        clone.color = this.color;
        for (MultiEvent ev : this.multiEvents) {
            clone.multiEvents.add((MultiEvent)ev.deepCopy(clone));
        }
        return clone;
    }

    @Override
    public void deepMove(long tick) {
        SortedSet<MultiEvent> events = this.getMultiEvents();
        for (MultiEvent ev : events) {
            ev.deepMove(tick);
        }
        this.setStartTick(this.getStartTick() + tick);
        this.setEndTick(this.getEndTick() + tick);
    }

    public void rebuildMultiEventEndTickComparables() {
        this.multiEventEndTickComparables = new TreeSet();
        for (MultiEvent multiEvent : this.multiEvents) {
            this.multiEventEndTickComparables.add(multiEvent.getMultiEventEndTickComparable());
        }
    }

    public int[] getPitchRange() {
        int low = 128;
        int high = 0;
        for (MultiEvent ev : this.multiEvents) {
            if (ev.isZombie() || !(ev instanceof NoteEvent)) continue;
            int pit = ((NoteEvent)ev).getNote();
            if (pit > high) {
                high = pit;
            }
            if (pit >= low) continue;
            low = pit;
        }
        int[] ret = new int[]{low, high};
        return ret;
    }

    @Override
    public void onLoad() {
        this.commitEventsAdd();
        this.rebuildMultiEventEndTickComparables();
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public void drawThumbNail(Graphics2D g, Rectangle rect, PartView panel) {
        TempoList tl = this.lane.getProject().getTempoList();
        for (MultiEvent e : this.getMultiEvents()) {
            double x = tl.getTimeAtTick(e.getStartTick());
            if (!(e instanceof NoteEvent)) continue;
            double w = tl.getTimeAtTick(e.getEndTick());
            int note = ((NoteEvent)e).getNote();
            int y = (int)((double)rect.y + (double)(rect.height * (128 - note)) / 128.0);
            if (e.isZombie()) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine((int)panel.userToScreen(x), y, (int)panel.userToScreen(w), y);
        }
    }

    public void addCommitListener(CommitListener l) {
        if (this.commitListeners == null) {
            this.commitListeners = new HashSet<CommitListener>();
        }
        this.commitListeners.add(l);
    }

    public void removeCommitListener(CommitListener l) {
        this.commitListeners.remove(l);
    }

    void fireCommitAdd(MultiEvent event) {
        if (this.commitListeners == null) {
            return;
        }
        for (CommitListener l : this.commitListeners) {
            l.commitAddPerformed(event);
        }
    }

    void fireCommitRemove(MultiEvent event) {
        if (this.commitListeners == null) {
            return;
        }
        for (CommitListener l : this.commitListeners) {
            l.commitRemovePerformed(event);
        }
    }

    @Override
    protected void initContextMenu(ProjectFrame frame, JPopupMenu popup) {
        JMenuItem item = new JMenuItem(new RepeatAction(frame));
        item.setMnemonic(82);
        item.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        popup.add(item);
        item = new JMenuItem(new SplitSelectedPartsAction(frame));
        popup.add(item);
        super.initContextMenu(frame, popup);
    }

    @Override
    protected OptionsEditor createPropertiesPanel(ProjectFrame frame) {
        return new MidiPartPropertiesPanel(frame);
    }

    protected class MidiPartPropertiesPanel
    extends Part.PropertiesPanel {
        protected MidiPartPropertiesPanel(ProjectFrame frame) {
            super(MidiPart.this, frame);
        }

        protected void initComponents() {
            super.initComponents();
        }

        public void refresh() {
            super.refresh();
        }

        public void update() {
            super.update();
        }
    }
}

