/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.gui.OptionsDialog;
import com.frinika.gui.OptionsEditor;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MenuPlugable;
import com.frinika.sequencer.model.MenuPlugin;
import com.frinika.sequencer.model.Selectable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class Part
implements Item,
Selectable,
EditHistoryRecordable,
Serializable,
MenuPlugable {
    private static final long serialVersionUID = -7282369887900349287L;
    protected Lane lane;
    private long startTick = 0L;
    private long endTick = 0L;
    Color color;
    transient Color transColor;
    protected transient boolean selected = false;
    static MenuPlugin menuPlugin = null;

    protected Part() {
        this.color = Color.lightGray;
    }

    public Part(Lane lane) {
        this.lane = lane;
        if (lane != null) {
            this.lane.add(this);
            this.color = lane.color;
        }
    }

    public Lane getLane() {
        return this.lane;
    }

    public long getDurationInTicks() {
        if (this.startTick > this.endTick) {
            return 0L;
        }
        return this.endTick - this.startTick;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public long getEndTick() {
        return this.endTick;
    }

    public double getDurationInSecs() {
        if (this.startTick > this.endTick) {
            return 0.0;
        }
        return this.lane.project.getTempoList().getTimeAtTick(this.endTick) - this.lane.project.getTempoList().getTimeAtTick(this.startTick);
    }

    public double getStartInSecs() {
        return this.lane.project.getTempoList().getTimeAtTick(this.startTick);
    }

    public double getEndInSecs() {
        return this.lane.project.getTempoList().getTimeAtTick(this.endTick);
    }

    public double getDuration(boolean sampleBased) {
        if (sampleBased) {
            return this.getDurationInSecs();
        }
        return this.getDurationInTicks();
    }

    public double getStart(boolean sampleBased) {
        if (sampleBased) {
            return this.getStartInSecs();
        }
        return this.getStartTick();
    }

    public double getEnd(boolean sampleBased) {
        if (sampleBased) {
            return this.getEndInSecs();
        }
        return this.getEndTick();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setStartTick(double tick) {
        this.startTick = (long)tick;
    }

    public void setEndTick(double tick) {
        this.endTick = (long)tick;
    }

    public void setStartInSecs(double start) {
        this.startTick = (long)this.lane.getProject().getTempoList().getTickAtTime(start);
    }

    public void setEndInSecs(double end) {
        this.endTick = (long)this.lane.getProject().getTempoList().getTickAtTime(end);
    }

    public void moveBy(long deltaTick) {
        this.startTick += deltaTick;
        this.endTick += deltaTick;
        this.moveItemsBy(deltaTick);
    }

    protected abstract void moveItemsBy(long var1);

    public abstract Object clone() throws CloneNotSupportedException;

    public abstract void commitEventsAdd();

    public abstract void commitEventsRemove();

    public abstract void copyBy(double var1, Lane var3);

    public abstract void moveContentsBy(double var1, Lane var3);

    public void removeFromModel() {
        this.lane.remove(this);
    }

    public void addToModel() {
        this.lane.add(this);
    }

    public long leftTickForMove() {
        return this.getStartTick();
    }

    public long rightTickForMove() {
        return this.getEndTick();
    }

    public Rectangle getEventBounds() {
        return null;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    public abstract void onLoad() throws Exception;

    public abstract void attach();

    public abstract void detach();

    public abstract void drawThumbNail(Graphics2D var1, Rectangle var2, PartView var3);

    public void displayStructure(String prefix, PrintStream out) {
        out.println(prefix + this.toString());
    }

    public boolean showRightButtonMenu(Component invoker, int x, int y) {
        return false;
    }

    public static void setPluginRightButtonMenu(MenuPlugin menuPlugin) {
        Part.menuPlugin = menuPlugin;
    }

    public void showContextMenu(ProjectFrame frame, Component invoker, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        if (menuPlugin != null) {
            menuPlugin.initContextMenu(popup, this);
        }
        this.initContextMenu(frame, popup);
        popup.show(invoker, x, y);
    }

    protected void initContextMenu(final ProjectFrame frame, JPopupMenu popup) {
        if (popup.getComponentCount() > 0) {
            popup.addSeparator();
        }
        JMenuItem item = new JMenuItem(CurrentLocale.getMessage("project.menu.properties") + "...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Part.this.showPropertiesDialog(frame);
            }
        });
        popup.add(item);
    }

    public Color getTransparentColor() {
        Color c = this.getColor();
        if (this.transColor == null) {
            this.transColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 204);
        }
        return this.transColor;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = Color.RED;
        }
        return this.color;
    }

    public void setColor(Color col) {
        this.color = col;
        this.transColor = null;
    }

    public void showPropertiesDialog(ProjectFrame frame) {
        this.createPropertiesDialog(frame).show();
        frame.repaintPartView();
    }

    protected JDialog createPropertiesDialog(ProjectFrame frame) {
        final OptionsEditor contentEditor = this.createPropertiesPanel(frame);
        final OptionsEditor backup = this.createPropertiesPanel(frame);
        backup.refresh();
        OptionsDialog dialog = new OptionsDialog(frame, (JComponent)((Object)contentEditor), "Part Properties"){

            public void ok() {
                super.ok();
                ProjectContainer project = this.frame.getProjectContainer();
                project.getEditHistoryContainer().mark(CurrentLocale.getMessage("project.menu.edit_properties"));
                EditHistoryAction action = new EditHistoryAction(){

                    public void redo() {
                        contentEditor.update();
                        frame.repaintPartView();
                    }

                    public void undo() {
                        backup.update();
                        frame.repaintPartView();
                    }
                };
                project.getEditHistoryContainer().push(action);
                project.getEditHistoryContainer().notifyEditHistoryListeners();
            }

            public void cancel() {
                backup.update();
                super.cancel();
                this.frame.repaintPartView();
            }
        };
        return dialog;
    }

    protected OptionsEditor createPropertiesPanel(ProjectFrame frame) {
        return new PropertiesPanel(frame);
    }

    protected class PropertiesPanel
    extends JPanel
    implements OptionsEditor {
        protected ProjectFrame frame;
        protected TimeSelector startTimeSelector;
        protected TimeSelector endTimeSelector;
        protected TimeSelector lengthTimeSelector;

        protected PropertiesPanel(ProjectFrame frame) {
            this.frame = frame;
            this.setLayout(new GridBagLayout());
            this.initComponents();
        }

        protected void initComponents() {
            JLabel startLabel = new JLabel("Start:");
            this.startTimeSelector = new TimeSelector(Part.this.startTick, this.frame.getProjectContainer(), TimeFormat.BAR_BEAT_TICK);
            JLabel endLabel = new JLabel("End:");
            JLabel lengthLabel = new JLabel("Duration:");
            this.endTimeSelector = new TimeSelector(Part.this.endTick, this.frame.getProjectContainer(), TimeFormat.BAR_BEAT_TICK);
            this.lengthTimeSelector = new TimeSelector(Part.this.getDurationInTicks(), this.frame.getProjectContainer(), TimeFormat.BEAT_TICK);
            this.startTimeSelector.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    long d = Part.this.getDurationInTicks();
                    Part.this.startTick = PropertiesPanel.this.startTimeSelector.getTicks();
                    Part.this.endTick = Part.this.startTick + d;
                    PropertiesPanel.this.endTimeSelector.setTicks(Part.this.endTick);
                    PropertiesPanel.this.frame.repaintPartView();
                }
            });
            this.endTimeSelector.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    Part.this.endTick = PropertiesPanel.this.endTimeSelector.getTicks();
                    PropertiesPanel.this.lengthTimeSelector.setTicks(Part.this.getDurationInTicks());
                    PropertiesPanel.this.frame.repaintPartView();
                }
            });
            this.lengthTimeSelector.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    long t = PropertiesPanel.this.lengthTimeSelector.getTicks();
                    Part.this.endTick = Part.this.startTick + t;
                    PropertiesPanel.this.endTimeSelector.setTicks(Part.this.endTick);
                    PropertiesPanel.this.frame.repaintPartView();
                }
            });
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 17;
            this.add((Component)startLabel, gc);
            this.add((Component)this.startTimeSelector, gc);
            this.add((Component)endLabel, gc);
            gc.gridwidth = 0;
            gc.anchor = 13;
            this.add((Component)this.endTimeSelector, gc);
            gc.anchor = 17;
            gc.gridwidth = 2;
            this.add((Component)new JPanel(), gc);
            gc.gridwidth = 1;
            this.add((Component)lengthLabel, gc);
            gc.gridwidth = 0;
            gc.anchor = 13;
            this.add((Component)this.lengthTimeSelector, gc);
            gc.anchor = 17;
            gc.gridwidth = 1;
        }

        public void refresh() {
            this.startTimeSelector.setTicks(Part.this.startTick);
            this.endTimeSelector.setTicks(Part.this.endTick);
            this.lengthTimeSelector.setTicks(Part.this.getDurationInTicks());
        }

        public void update() {
            Part.this.startTick = this.startTimeSelector.getTicks();
            Part.this.endTick = this.endTimeSelector.getTicks();
        }
    }
}

