/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class ProgramChangeEvent
extends ChannelEvent {
    transient MidiEvent programEvent;
    transient MidiEvent msbEvent;
    transient MidiEvent lsbEvent;
    int prog;
    int msb;
    int lsb;
    private static final long serialVersionUID = 1L;

    public ProgramChangeEvent(MidiPart part, long startTick, int prog, int msb, int lsb) {
        super(part, startTick);
    }

    public long getEndTick() {
        return 0L;
    }

    void commitRemoveImpl() {
        this.getTrack().remove(this.msbEvent);
        this.getTrack().remove(this.lsbEvent);
        this.getTrack().remove(this.programEvent);
    }

    public void commitAddImpl() {
        try {
            ShortMessage shm = new ShortMessage();
            shm.setMessage(176, this.channel, 0, this.msb);
            this.msbEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.msbEvent);
            shm = new ShortMessage();
            shm.setMessage(176, this.channel, 32, this.lsb);
            this.lsbEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.lsbEvent);
            shm = new ShortMessage();
            shm.setMessage(192, this.channel, this.prog, 0);
            this.programEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.programEvent);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        ProgramChangeEvent evt = (ProgramChangeEvent)object;
        this.part = evt.part;
        this.startTick = evt.startTick;
        this.prog = evt.prog;
        this.msb = evt.msb;
        this.lsb = evt.lsb;
    }

    public void setProgram(int prog2, int msb2, int lsb2) {
        this.prog = prog2;
        this.msb = msb2;
        this.lsb = lsb2;
    }
}

