/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.global.Toolbox;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.TextPart;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextLane
extends Lane {
    private static final long serialVersionUID = 1L;
    protected transient ArrayList<ChangeListener> changeListeners = new ArrayList();
    static Icon iconTextLane = new ImageIcon(TextLane.class.getResource("/icons/new_track_text.gif"));
    static int nameCount = 0;

    public TextLane(ProjectContainer project) {
        super("Text " + nameCount++, project);
        long ticks = project.getSequencer().getTickPosition();
        this.createNewTextPart(ticks);
    }

    public TextPart createNewTextPart(long ticks) {
        TextPart part = new TextPart(this);
        part.setStartTick(ticks);
        part.setEndTick(ticks + 10240L);
        return part;
    }

    public Selectable deepCopy(Selectable parent) {
        return null;
    }

    public void deepMove(long tick) {
    }

    public void restoreFromClone(EditHistoryRecordable object) {
    }

    public String getAllText(String delim) {
        ArrayList<String> l = new ArrayList<String>();
        for (Part p : this.getParts()) {
            String s = ((TextPart)p).getText().trim();
            l.add(s);
        }
        while (!l.isEmpty() && l.get(l.size() - 1).equals("...")) {
            l.remove(l.size() - 1);
        }
        return Toolbox.joinStrings(l, delim);
    }

    public void setAllText(String text, String delim) {
        List<String> stringParts = Toolbox.splitString(text, delim);
        List<Part> textParts = this.getParts();
        Iterator<Part> iterator = new ArrayList<Part>(textParts).iterator();
        long lastTick = 0L;
        for (String s : stringParts) {
            TextPart textPart = iterator.hasNext() ? (TextPart)iterator.next() : this.createNewTextPart(lastTick + 512L);
            textPart.setText(s);
            lastTick = textPart.getEndTick();
        }
        while (iterator.hasNext()) {
            TextPart textPart = (TextPart)iterator.next();
            textPart.setText("...");
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.changeListeners = new ArrayList();
    }

    public Part createPart() {
        assert (false);
        return null;
    }

    public Icon getIcon() {
        return iconTextLane;
    }
}

