/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.ProjectLane;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewableLaneList
implements Iterable<Lane> {
    ProjectContainer project;
    Vector<Lane> lanes;
    int y;
    int id;

    public ViewableLaneList(ProjectContainer project) {
        this.project = project;
        this.rebuild();
    }

    public void rebuild() {
        this.lanes = new Vector();
        this.y = 0;
        this.id = 0;
        ProjectLane root = this.project.getProjectLane();
        this.rebuild(root);
    }

    private void rebuild(Lane root) {
        if (!root.isHidden()) {
            int height = root.getHeight() * Layout.getLaneHeightScale();
            root.setDisplayPos(this.y, height, this.id++);
            this.y += height;
            this.lanes.add(root);
        }
        if (root.isOpen() && root.getChildren() != null) {
            for (Lane child : root.getChildren()) {
                this.rebuild(child);
            }
        }
    }

    public List<Lane> getVisibleLanes() {
        return this.lanes;
    }

    @Override
    public Iterator<Lane> iterator() {
        return this.lanes.iterator();
    }
}

