/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.sequencer.model.audio.DAudioReader;
import com.frinika.sequencer.model.audio.DoubleDataSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class AudioClipReader
implements DoubleDataSource,
AudioProcess {
    DAudioReader reader;
    byte[] byteBuffer;
    float[][] bPtr = new float[2][];
    private int nch;
    private long startFrame;

    public AudioClipReader(File clipFile, long startFrame) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(clipFile, "r");
        this.reader = new DAudioReader(raf);
        this.reader.seekFrame(0L);
        this.nch = this.reader.getChannels();
        System.out.println(" Channels = " + this.nch);
        this.startFrame = startFrame;
    }

    public void readNextDouble(double[] buffer, int offSet, int nFrame) {
        int nByte = nFrame * this.nch * 2;
        if (this.byteBuffer == null || this.byteBuffer.length != nByte) {
            this.byteBuffer = new byte[nByte];
        }
        try {
            this.reader.read(this.byteBuffer, 0, nByte);
            if (this.nch == 2) {
                for (int n = 0; n < 2 * nFrame; ++n) {
                    buffer[offSet + n] = (float)((short)((0xFF & this.byteBuffer[n * 2 + 0]) + (0xFF & this.byteBuffer[n * 2 + 1]) * 256)) / 32768.0f;
                }
            } else {
                for (int n = 0; n < nFrame; ++n) {
                    double val;
                    buffer[offSet + n] = val = (double)((float)((short)((0xFF & this.byteBuffer[2 * n]) + (0xFF & this.byteBuffer[2 * n + 1]) * 256)) / 32768.0f);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int processAudio(AudioBuffer buffer) {
        int nFrame = buffer.getSampleCount();
        int nByte = nFrame * this.nch * 2;
        if (this.byteBuffer == null || this.byteBuffer.length != nByte) {
            this.byteBuffer = new byte[nByte];
        }
        for (int i = 0; i < buffer.getChannelCount(); ++i) {
            this.bPtr[i] = buffer.getChannel(i);
        }
        try {
            this.reader.read(this.byteBuffer, 0, nByte);
            for (int ch = 0; ch < this.nch; ++ch) {
                for (int n = 0; n < nFrame; ++n) {
                    int ptr = (n * this.nch + ch) * 2;
                    this.bPtr[ch][n] = (float)((short)((0xFF & this.byteBuffer[ptr + 0]) + (0xFF & this.byteBuffer[ptr + 1]) * 256)) / 32768.0f;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void seekFrameInClip(long pos) {
        try {
            this.reader.seekFrame(pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void seekFrame(long pos) {
        try {
            this.reader.seekFrame(pos - this.startFrame);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean endOfFile() {
        return this.reader.eof();
    }

    public int getChannels() {
        return this.nch;
    }

    public AudioFormat getFormat() {
        return this.reader.getFormat();
    }

    public void open() {
    }

    public void close() {
    }

    public long getCurrentFrame() {
        return this.reader.getCurrentFrame();
    }

    public long getLengthInFrames() {
        return this.reader.getLengthInFrames();
    }
}

