/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.sequencer.model.audio.BufferedRandomAccessFile;
import java.io.IOException;
import java.util.Vector;

public class BufferedRandomAccessFileManager
implements Runnable {
    Vector<BufferedRandomAccessFile> files = new Vector();
    Vector<BufferedRandomAccessFile> filesToFill = new Vector();
    Thread thread = new Thread(this);
    private boolean sleeping = false;

    public BufferedRandomAccessFileManager() {
        this.thread.setPriority(10);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(BufferedRandomAccessFile file) {
        BufferedRandomAccessFileManager bufferedRandomAccessFileManager = this;
        synchronized (bufferedRandomAccessFileManager) {
            this.files.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(BufferedRandomAccessFile file) {
        BufferedRandomAccessFileManager bufferedRandomAccessFileManager = this;
        synchronized (bufferedRandomAccessFileManager) {
            this.files.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean workToDo = false;
        while (true) {
            BufferedRandomAccessFileManager bufferedRandomAccessFileManager = this;
            synchronized (bufferedRandomAccessFileManager) {
                this.filesToFill.clear();
                for (BufferedRandomAccessFile file : this.files) {
                    if (file.isFull()) continue;
                    this.filesToFill.add(file);
                }
                if (!this.filesToFill.isEmpty()) {
                    for (BufferedRandomAccessFile file : this.filesToFill) {
                        try {
                            file.fillBuffer();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        this.sleeping = true;
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.sleeping = false;
                    }
                }
            }
        }
    }

    public void wakeup() {
        if (this.sleeping) {
            this.thread.interrupt();
        }
    }
}

