/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.audio.AudioReader;
import com.frinika.sequencer.model.audio.RandomAccessFileIF;
import java.io.IOException;
import uk.org.toot.audio.core.AudioBuffer;

public class EnvelopedAudioReader
extends AudioReader {
    protected double gain = 1.0;
    protected long attackEnd;
    protected long decayStart;

    public EnvelopedAudioReader(RandomAccessFileIF fis) throws IOException {
        super(fis);
    }

    public void setEvelope(AudioPart.Envelope e) {
        this.setBoundsInMicros(e.getTOn(), e.getTOff());
        this.gain = e.getGain();
        this.attackEnd = this.startByte + this.milliToByte(e.getTRise());
        this.decayStart = this.endByte - this.milliToByte(e.getTFall());
        if (this.attackEnd > this.decayStart) {
            long av = (this.attackEnd + this.decayStart) / 2L;
            this.attackEnd = this.decayStart = av / (long)(this.nChannels * 2) * (long)this.nChannels * 2L;
        }
    }

    protected void processAudioImp(AudioBuffer buffer, int startChunk, int endChunk) {
        long fPtr1 = this.fPtrBytes + (long)startChunk;
        long fPtr2 = this.fPtrBytes + (long)endChunk;
        if (fPtr1 <= this.decayStart && fPtr2 >= this.attackEnd) {
            this.fillConstantGain(buffer, startChunk, endChunk, this.gain);
        } else if (fPtr1 < this.attackEnd && fPtr2 >= this.attackEnd) {
            double gainNow = this.gain * (double)(fPtr1 - this.startByte) / (double)(this.attackEnd - this.startByte);
            this.fillLinearInterpolate(buffer, startChunk, endChunk, gainNow, this.gain);
        } else if (fPtr1 < this.attackEnd) {
            double gainNow = this.gain * (double)(fPtr1 - this.startByte) / (double)(this.attackEnd - this.startByte);
            double gainNext = this.gain * (double)(fPtr2 - this.startByte) / (double)(this.attackEnd - this.startByte);
            this.fillLinearInterpolate(buffer, startChunk, endChunk, gainNow, gainNext);
        } else if (fPtr1 <= this.decayStart && fPtr2 > this.decayStart) {
            double gainNext = this.gain * (double)(this.endByte - fPtr2) / (double)(this.endByte - this.decayStart);
            this.fillLinearInterpolate(buffer, startChunk, endChunk, this.gain, gainNext);
        } else {
            assert (fPtr1 > this.decayStart);
            double gainNow = this.gain * (double)(this.endByte - fPtr1) / (double)(this.endByte - this.decayStart);
            double gainNext = this.gain * (double)(this.endByte - fPtr2) / (double)(this.endByte - this.decayStart);
            this.fillLinearInterpolate(buffer, startChunk, endChunk, gainNow, gainNext);
        }
    }
}

