/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.audio.Voice;
import com.frinika.audio.VoiceServer;
import java.util.Arrays;
import rasmus.interpreter.sampled.util.Freeverb;

public class MasterVoice
extends Voice {
    Freeverb freeverb = null;
    double[] reverbBufferIn = null;
    double[] reverbBufferOut = null;
    static MasterVoice defaultInstance = new MasterVoice();

    public final void addToReverb(int startBufferPos, int endBufferPos, float[] buffer) {
        if (this.freeverb != null && (this.reverbBufferIn == null || this.reverbBufferIn.length != buffer.length)) {
            this.reverbBufferIn = new double[buffer.length];
            this.reverbBufferOut = new double[buffer.length];
        }
        for (int n = startBufferPos; n < endBufferPos; ++n) {
            int n2 = n;
            this.reverbBufferIn[n2] = this.reverbBufferIn[n2] + (double)buffer[n];
        }
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        if (this.reverbBufferIn != null) {
            this.freeverb.processReplace(this.reverbBufferIn, this.reverbBufferOut, startBufferPos, endBufferPos, 2);
            for (int n = startBufferPos; n < endBufferPos; ++n) {
                int n2 = n;
                buffer[n2] = buffer[n2] + (float)this.reverbBufferOut[n];
            }
            Arrays.fill(this.reverbBufferIn, 0.0);
        }
    }

    public final void initialize(VoiceServer voiceServer) {
        this.freeverb = new Freeverb((double)voiceServer.getSampleRate(), 1.0);
        this.freeverb.setdry(0.0f);
        this.freeverb.setroomsize(0.9f);
        this.freeverb.setdamp(0.9f);
        this.freeverb.setwet(1.0f);
        voiceServer.addTransmitter(this);
    }

    public static final MasterVoice getDefaultInstance() {
        return defaultInstance;
    }
}

