/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.global.FrinikaConfig;
import com.frinika.synth.MasterVoice;
import com.frinika.synth.Oscillator;
import com.frinika.synth.Overdrive;
import com.frinika.synth.Pan;
import com.frinika.synth.Synth;
import com.frinika.synth.envelope.MidiVolume;

public class PostOscillator
extends Oscillator {
    int overDriveAmount = 0;
    float echoAmount = 0.0f;
    int echoLength = 48;
    float volume = MidiVolume.midiVolumeToAmplitudeRatio(100);
    float[] echoBuffer = null;
    int echoBufferPos = 0;
    Pan pan = new Pan(0.5f);
    float reverb = MidiVolume.midiVolumeToAmplitudeRatio(0);

    public PostOscillator(Synth synth) {
        super(synth);
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        if (this.synth.preOscillator == null) {
            System.out.println("FATAL: preOscillator is null - please add this line as comment to http://sourceforge.net/tracker/index.php?func=detail&aid=1450319&group_id=131823&atid=722343");
            return;
        }
        if (this.synth.preOscillator.sampleBuffer == null) {
            System.out.println("FATAL: preOscillator.sampleBuffer is null - please add this line as comment to http://sourceforge.net/tracker/index.php?func=detail&aid=1450319&group_id=131823&atid=722343");
            return;
        }
        int n = startBufferPos;
        while (n < endBufferPos) {
            float sample = this.synth.preOscillator.sampleBuffer[n];
            if (this.overDriveAmount > 0) {
                sample = Overdrive.process(this.synth.preOscillator.sampleBuffer[n], this.overDriveAmount);
            }
            if (this.echoBuffer != null) {
                this.echoBufferPos %= this.echoBuffer.length;
                int n2 = this.echoBufferPos;
                this.echoBuffer[n2] = this.echoBuffer[n2] * this.echoAmount;
                float echoBufferSample = this.echoBuffer[this.echoBufferPos];
                int n3 = this.echoBufferPos++;
                this.echoBuffer[n3] = this.echoBuffer[n3] + sample;
                sample += echoBufferSample;
            }
            sample *= this.volume;
            sample = (n & 1) == 0 ? (sample *= this.pan.getLeftLevel()) : (sample *= this.pan.getRightLevel());
            this.synth.preOscillator.sampleBuffer[n] = sample * this.reverb;
            int n4 = n++;
            buffer[n4] = buffer[n4] + sample;
        }
        if (this.reverb > 0.0f) {
            MasterVoice.getDefaultInstance().addToReverb(startBufferPos, endBufferPos, this.synth.preOscillator.sampleBuffer);
        }
    }

    public void setOverDriveAmount(int overDriveAmount) {
        this.overDriveAmount = overDriveAmount;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setReverb(float reverb) {
        this.reverb = reverb;
    }

    public void setEchoAmount(int echoAmount) {
        if (echoAmount > 0) {
            float ticksPerSecond = this.synth.getFrinikaSynth().getTempoBPM() / 60.0f * 32.0f;
            if (this.echoBuffer == null) {
                this.setEchoLength(this.echoLength);
            }
        } else {
            this.echoBuffer = null;
        }
        this.echoAmount = (float)echoAmount / 127.0f;
    }

    public void setEchoLength(int echoLength) {
        this.echoLength = echoLength;
        float ticksPerSecond = this.synth.getFrinikaSynth().getTempoBPM() / 60.0f * 32.0f;
        int echoBufferSize = (int)((float)echoLength / ticksPerSecond * (float)FrinikaConfig.sampleRate);
        this.echoBuffer = (float[])(echoBufferSize > 0 ? new float[echoBufferSize] : null);
    }

    public void setPan(int position) {
        this.pan = new Pan((float)position / 127.0f);
    }
}

