/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.audio.VoiceInterrupt;
import com.frinika.synth.Oscillator;
import com.frinika.synth.PitchCents;
import com.frinika.synth.Synth;
import com.frinika.synth.waveforms.Sinus;

public class PreOscillator
extends Oscillator {
    int amount = 0;
    float[] lfoBuffer;
    public float[] sampleBuffer = null;
    public int pitchBend;
    public float pitchBendFactor = 1.0f;
    float lastLfoSample = 0.0f;

    public PreOscillator(Synth synth) {
        super(synth);
        this.frequency = 7.0f;
        this.updateIncrement();
    }

    public void setVibratoAmount(final int amount) {
        this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                PreOscillator.this.amount = amount;
            }
        });
    }

    protected void updateIncrement() {
        this.increment = (float)(Math.PI * 2 * (double)this.frequency) / (float)this.sampleRate;
    }

    public final float[] getLfoBuffer() {
        return this.lfoBuffer;
    }

    public void setVibratoFrequency(final float frequency) {
        this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                PreOscillator.this.frequency = frequency;
                PreOscillator.this.updateIncrement();
            }
        });
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        if (this.sampleBuffer == null || this.sampleBuffer.length != buffer.length) {
            this.lfoBuffer = new float[buffer.length / 2];
            this.sampleBuffer = new float[buffer.length];
        }
        for (int n = startBufferPos / 2; n < endBufferPos / 2; ++n) {
            this.lfoBuffer[n] = this.amount != 0 ? PitchCents.getPitchCent((int)(Sinus.getSin(this.position += this.increment) * (float)this.amount)) * this.pitchBendFactor : this.pitchBendFactor;
            this.sampleBuffer[n * 2] = 0.0f;
            this.sampleBuffer[n * 2 + 1] = 0.0f;
        }
    }

    public final int getAmount() {
        return this.amount;
    }
}

