/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.sampler;

import com.frinika.audio.JavaSoundVoiceServer;
import com.frinika.localization.CurrentLocale;
import com.frinika.sequencer.gui.AudioDeviceHandle;
import com.frinika.synth.InstrumentNameListener;
import com.frinika.synth.Synth;
import com.frinika.synth.importers.wav.WavImporter;
import com.frinika.synth.synths.MySampler;
import com.frinika.synth.synths.sampler.RecorderGUI;
import com.frinika.synth.synths.sampler.SampleEditor;
import com.frinika.synth.synths.sampler.SampleMapTableModel;
import com.frinika.synth.synths.sampler.SampleMapTableRenderer;
import com.frinika.synth.synths.sampler.settings.SampledSoundSettings;
import com.frinika.tools.MyFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.sampled.TargetDataLine;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SamplerGUI
extends JFrame
implements InstrumentNameListener {
    private static final long serialVersionUID = 1L;
    TableModel sampleMapTableModel;
    JTable sampleMapTable;
    RecorderGUI recorderGUI;
    SampleMapTableRenderer sampleMapTableRenderer = new SampleMapTableRenderer();
    MySampler sampler;
    static boolean stereo = false;
    static TargetDataLine lineIn = null;
    static AudioDeviceHandle audioInDevice = null;

    public SamplerGUI(final MySampler sampler) {
        JMenu audioInputMenu;
        this.sampler = sampler;
        this.setLayout(new BorderLayout());
        JPanel layersPanel = new JPanel();
        final JComboBox<Integer> layerComboBox = new JComboBox<Integer>();
        for (int n = 1; n <= 6; ++n) {
            layerComboBox.addItem(new Integer(n));
        }
        layerComboBox.setSelectedIndex(sampler.getSamplerSettings().getLayers() - 1);
        layerComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                sampler.getSamplerSettings().setLayers(layerComboBox.getSelectedIndex() + 1);
            }
        });
        layersPanel.add(new JLabel("Layers: "));
        layersPanel.add(layerComboBox);
        final JSlider freqSpreadSlider = new JSlider(0, 0, 1000, (int)(sampler.getSamplerSettings().getFreqSpread() * 80.0f));
        freqSpreadSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                sampler.getSamplerSettings().setFreqSpread((float)freqSpreadSlider.getValue() / 80.0f);
            }
        });
        layersPanel.add(new JLabel("Frequency spread:"));
        layersPanel.add(freqSpreadSlider);
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BorderLayout());
        midPanel.add((Component)layersPanel, "North");
        this.sampleMapTableModel = new SampleMapTableModel(sampler);
        this.sampleMapTable = new JTable(this.sampleMapTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (column == 0) {
                    switch (row % 12) {
                        case 0: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 1: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 2: {
                            c.setBackground(Color.BLACK);
                            c.setForeground(Color.WHITE);
                            break;
                        }
                        case 3: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 4: {
                            c.setBackground(Color.BLACK);
                            c.setForeground(Color.WHITE);
                            break;
                        }
                        case 5: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 6: {
                            c.setBackground(Color.BLACK);
                            c.setForeground(Color.WHITE);
                            break;
                        }
                        case 7: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 8: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 9: {
                            c.setBackground(Color.BLACK);
                            c.setForeground(Color.WHITE);
                            break;
                        }
                        case 10: {
                            c.setBackground(Color.WHITE);
                            c.setForeground(Color.BLACK);
                            break;
                        }
                        case 11: {
                            c.setBackground(Color.BLACK);
                            c.setForeground(Color.WHITE);
                        }
                    }
                } else if (!SamplerGUI.this.sampleMapTable.isCellSelected(row, column)) {
                    c.setBackground(null);
                    c.setForeground(null);
                }
                return c;
            }
        };
        this.sampleMapTable.getColumnModel().getColumn(0).setHeaderValue("Note/Vel");
        this.sampleMapTable.setIntercellSpacing(new Dimension(0, 0));
        this.sampleMapTable.setShowGrid(false);
        this.sampleMapTable.setFont(new Font(this.sampleMapTable.getFont().getFontName(), this.sampleMapTable.getFont().getStyle(), 9));
        for (int n = 1; n < this.sampleMapTable.getColumnCount(); ++n) {
            TableColumn col = this.sampleMapTable.getColumnModel().getColumn(n);
            col.setHeaderValue(128 - n);
            col.setCellRenderer(this.sampleMapTableRenderer);
            col.setMinWidth(5);
            col.setPreferredWidth(5);
        }
        this.sampleMapTable.getTableHeader().setReorderingAllowed(false);
        this.sampleMapTable.getTableHeader().setResizingAllowed(false);
        this.sampleMapTable.setColumnSelectionAllowed(true);
        this.sampleMapTable.setAutoResizeMode(0);
        JScrollPane sampleMapPane = new JScrollPane(this.sampleMapTable);
        midPanel.add((Component)sampleMapPane, "Center");
        this.add((Component)midPanel, "Center");
        this.sampleMapTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    new SampleEditor((SampledSoundSettings)SamplerGUI.this.sampleMapTableModel.getValueAt(SamplerGUI.this.sampleMapTable.getSelectedRow(), SamplerGUI.this.sampleMapTable.getSelectedColumn()));
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.add((Component)menuBar, "North");
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem renameMenuItem = new JMenuItem("Rename");
        renameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sampler.setInstrumentName(JOptionPane.showInputDialog("Enter new name", (Object)sampler.getInstrumentName()));
            }
        });
        fileMenu.add(renameMenuItem);
        JMenuItem importSFMenuItem = new JMenuItem("Import SoundFont V2");
        importSFMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sampler.sfi.showGUI();
            }
        });
        fileMenu.add(importSFMenuItem);
        JMenuItem importWavMenuItem = new JMenuItem("Import Wav");
        importWavMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Import wav");
                    chooser.setFileFilter(new MyFileFilter(".wav", "Wav files"));
                    if (chooser.showOpenDialog(SamplerGUI.this) == 0) {
                        SampledSoundSettings sampledSound = new WavImporter().importWav(chooser.getSelectedFile());
                        sampledSound.setRootKey(SamplerGUI.this.getLowestNotenumberInSelection());
                        SamplerGUI.this.insertSampleToSelection(sampledSound);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        fileMenu.add(importWavMenuItem);
        JMenu recordMenu = new JMenu("Record");
        menuBar.add(recordMenu);
        if (sampler.getAudioOutput() instanceof JavaSoundVoiceServer) {
            audioInputMenu = new JMenu(CurrentLocale.getMessage("sampler.menu.audio_inputs"));
            recordMenu.add(audioInputMenu);
            try {
                throw new Exception("FIXME");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            audioInputMenu = new JMenu(CurrentLocale.getMessage("sampler.menu.audio_inputs"));
            recordMenu.add(audioInputMenu);
            ButtonGroup audioInGroup = new ButtonGroup();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Mono (left)");
            item.setSelected(!stereo);
            audioInGroup.add(item);
            audioInputMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    stereo = false;
                }
            });
            item = new JRadioButtonMenuItem("Stereo");
            item.setSelected(stereo);
            audioInGroup.add(item);
            audioInputMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    stereo = true;
                }
            });
        }
        JMenuItem recordMenuItem = new JMenuItem("Record to key");
        recordMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sampler.recordMode = 0;
                SamplerGUI.this.startSampler();
            }
        });
        recordMenu.add(recordMenuItem);
        JMenuItem recordAllKeysMenuItem = new JMenuItem("Record to all keys");
        recordAllKeysMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sampler.recordMode = 1;
                SamplerGUI.this.startSampler();
            }
        });
        recordMenu.add(recordAllKeysMenuItem);
        JMenuItem recordToSelectionMenuItem = new JMenuItem("Record to selection");
        recordToSelectionMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sampler.recordMode = 2;
                SamplerGUI.this.startSampler();
            }
        });
        recordMenu.add(recordToSelectionMenuItem);
        this.setSize(700, 500);
        this.setVisible(true);
        this.setTitle(sampler.getInstrumentName());
        sampler.addInstrumentNameListener(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                sampler.removeInstrumentNameListener(SamplerGUI.this);
            }
        });
    }

    void startSampler() {
        try {
            this.sampler.samplerOscillator.startMonitor(lineIn, stereo);
            this.openRecorderGUI();
            JOptionPane.showMessageDialog(this, "Your input is now being monitored. Recording will start on MIDI Note ON and stop on MIDI Note OFF.");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, CurrentLocale.getMessage("sampler.menu.audio_input_error"));
        }
    }

    void openRecorderGUI() {
        if (this.recorderGUI != null) {
            this.recorderGUI.dispose();
        }
        this.recorderGUI = new RecorderGUI(this.sampler.samplerOscillator);
    }

    public void insertSampleToSelection(SampledSoundSettings sampledSound) {
        for (int x : this.sampleMapTable.getSelectedColumns()) {
            for (int y : this.sampleMapTable.getSelectedRows()) {
                this.sampleMapTable.setValueAt(sampledSound, y, x);
            }
        }
    }

    public static void main(String[] args) {
        new SamplerGUI(null);
    }

    public int getLowestNotenumberInSelection() {
        int row = 0;
        for (int n : this.sampleMapTable.getSelectedRows()) {
            if (n <= row) continue;
            row = n;
        }
        return 96 - row;
    }

    public boolean isNoteInSelection(int noteNumber, int velocity) {
        return this.sampleMapTable.isCellSelected(96 - noteNumber, 128 - velocity);
    }

    public void instrumentNameChange(Synth synth, String instrumentName) {
        this.setTitle(instrumentName);
    }
}

