/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.tools;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.tools.MyMidiRenderer;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioClient;

public class BufferedPlayback
implements Runnable {
    private ProjectContainer project;
    private JFrame frame;
    MyMidiRenderer midiRenderer;
    volatile boolean active = false;
    Thread thread = null;
    Thread playthread = null;
    AudioBuffer buffer;
    AudioProcess outputprocess;
    byte[] bytebuffer;
    int pipeSize = 882000;
    int pipeWaitSize = 882000;
    byte[] circularbuffer = new byte[this.pipeSize];
    int circularbuffer_read_pos = 0;
    int circularbuffer_write_pos = 0;
    int circularbuffer_avail = 0;
    AudioClient client = new AudioClient(){
        boolean startProcessing = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(byte[] byteBuffer) {
            byte[] byArray = BufferedPlayback.this.circularbuffer;
            synchronized (BufferedPlayback.this.circularbuffer) {
                if (!this.startProcessing) {
                    if (BufferedPlayback.this.circularbuffer_avail < BufferedPlayback.this.pipeWaitSize) {
                        Arrays.fill(byteBuffer, (byte)0);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    this.startProcessing = true;
                }
                if (BufferedPlayback.this.circularbuffer_avail < byteBuffer.length) {
                    System.out.println("Buffer underrun : " + BufferedPlayback.this.circularbuffer_avail + " < " + byteBuffer.length);
                    this.startProcessing = false;
                    Arrays.fill(byteBuffer, (byte)0);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                for (int i = 0; i < byteBuffer.length; ++i) {
                    byteBuffer[i] = BufferedPlayback.this.circularbuffer[BufferedPlayback.this.circularbuffer_read_pos];
                    BufferedPlayback.this.circularbuffer_read_pos = (BufferedPlayback.this.circularbuffer_read_pos + 1) % BufferedPlayback.this.pipeSize;
                    --BufferedPlayback.this.circularbuffer_avail;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void work(int bufSize) {
            this.read(BufferedPlayback.this.bytebuffer);
            float[] left = BufferedPlayback.this.buffer.getChannel(0);
            float[] right = BufferedPlayback.this.buffer.getChannel(1);
            for (int n = 0; n < BufferedPlayback.this.buffer.getSampleCount() * 2; ++n) {
                float sample = (float)((short)((0xFF & BufferedPlayback.this.bytebuffer[n * 2 + 1]) + (0xFF & BufferedPlayback.this.bytebuffer[n * 2 + 0]) * 256)) / 32768.0f;
                if (n % 2 == 0) {
                    left[n / 2] = sample;
                    continue;
                }
                right[n / 2] = sample;
            }
            BufferedPlayback.this.outputprocess.processAudio(BufferedPlayback.this.buffer);
        }

        public void setEnabled(boolean b) {
        }
    };

    public BufferedPlayback(JFrame frame, ProjectContainer project) {
        this.frame = frame;
        this.project = project;
        this.buffer = project.getAudioServer().createAudioBuffer("BufferPlayback");
        this.outputprocess = project.getOutputProcess();
        this.bytebuffer = new byte[this.buffer.getSampleCount() * 2 * 2];
    }

    public void start() {
        if (this.thread != null) {
            this.stop();
        }
        this.active = true;
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
        Object[] options = new String[]{"STOP"};
        JOptionPane.showOptionDialog(this.frame, "To stop playback press STOP", "Buffered Playback, ", -1, 1, null, options, options[0]);
        this.stop();
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        if (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        FrinikaAudioSystem.stealAudioServer(this, this.client);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        long startTick = this.project.getSequencer().getTickPosition();
        this.midiRenderer = new MyMidiRenderer(this.project.getMixer(), this.project.getSequencer(), startTick, Integer.MAX_VALUE, this.project.getAudioServer().getSampleRate());
        FrinikaSequencer sequencer = this.project.getSequencer();
        sequencer.setRealtime(false);
        sequencer.start();
        byte[] buffer = new byte[256];
        try {
            block8: while (this.active) {
                int ret = this.midiRenderer.read(buffer);
                boolean repeat = true;
                int i = 0;
                while (true) {
                    byte[] byArray = this.circularbuffer;
                    // MONITORENTER : this.circularbuffer
                    while (i < buffer.length && this.circularbuffer_avail != this.pipeSize) {
                        this.circularbuffer[this.circularbuffer_write_pos] = buffer[i];
                        this.circularbuffer_write_pos = (this.circularbuffer_write_pos + 1) % this.pipeSize;
                        ++this.circularbuffer_avail;
                        ++i;
                    }
                    // MONITOREXIT : byArray
                    if (i == buffer.length) continue block8;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue block8;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sequencer.stop();
        sequencer.setRealtime(true);
        this.project.getMixer().getMainBus().setOutputProcess((AudioProcess)this.project.getOutputProcess());
        FrinikaAudioSystem.returnAudioServer(this);
    }
}

