/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.tracker;

import com.frinika.synth.GlobalInstrumentNameListener;
import com.frinika.synth.SynthRack;
import javax.swing.JComboBox;

public class ChannelComboBox
extends JComboBox
implements GlobalInstrumentNameListener {
    private SynthRack synth;

    public ChannelComboBox(SynthRack synth) {
        this.synth = synth;
        for (int n = 0; n < 16; ++n) {
            String itemName = n + "";
            if (synth.getSynth(n) != null) {
                itemName = itemName + " " + synth.getSynth(n).getInstrumentName();
            }
            this.addItem(n + "");
        }
        this.setSelectedIndex(0);
        synth.addGlobalInstrumentNameListener(this);
    }

    public void instrumentNameChange(int synthIndex, String instrumentName) {
        boolean isSelected = false;
        if (this.getSelectedIndex() == synthIndex) {
            isSelected = true;
        }
        this.removeItemAt(synthIndex);
        this.insertItemAt(synthIndex + " " + instrumentName, synthIndex);
        if (isSelected) {
            this.setSelectedIndex(synthIndex);
        }
    }
}

