/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class BufferedAudioProcess {
    public static final int OVERFLOW = -1;
    float[] buff;
    int cacheSize;
    long inPtr = 0L;
    long outPtr = 0L;
    Thread outBlockingThread = null;
    public final AudioProcess in = new In();
    public final AudioProcess out = new Out();
    private int required;
    private boolean itWasMe = false;
    private boolean disconnected = false;
    int overflowCount = 0;
    private boolean blocking = false;

    public BufferedAudioProcess(int cacheSize) {
        this.cacheSize = cacheSize;
        this.buff = new float[cacheSize];
    }

    public int getLag() {
        return (int)(this.inPtr - this.outPtr);
    }

    class OverflowException
    extends Exception {
        OverflowException() {
        }

        public String toString() {
            return " BufferedAuioProcess:  Overflow ";
        }
    }

    class Out
    implements AudioProcess {
        Out() {
        }

        public synchronized int processAudio(AudioBuffer buffer) {
            BufferedAudioProcess.this.required = buffer.getSampleCount();
            if (BufferedAudioProcess.this.inPtr - BufferedAudioProcess.this.outPtr < (long)BufferedAudioProcess.this.required) {
                BufferedAudioProcess.this.outBlockingThread = Thread.currentThread();
                try {
                    do {
                        Thread.currentThread();
                    } while (Thread.interrupted());
                    BufferedAudioProcess.this.blocking = true;
                    this.wait();
                }
                catch (InterruptedException e) {
                    BufferedAudioProcess.this.blocking = false;
                    if (BufferedAudioProcess.this.itWasMe) {
                        BufferedAudioProcess.this.itWasMe = false;
                    }
                    e.printStackTrace();
                    e.getCause().printStackTrace();
                    BufferedAudioProcess.this.inPtr = 0L;
                    BufferedAudioProcess.this.outPtr = 0L;
                    BufferedAudioProcess.this.itWasMe = false;
                    return 20;
                }
                assert (BufferedAudioProcess.this.inPtr - BufferedAudioProcess.this.outPtr >= (long)BufferedAudioProcess.this.required);
            }
            int outCy0 = (int)(BufferedAudioProcess.this.outPtr % (long)BufferedAudioProcess.this.cacheSize);
            int outCy1 = (int)((BufferedAudioProcess.this.outPtr + (long)BufferedAudioProcess.this.required) % (long)BufferedAudioProcess.this.cacheSize);
            if (outCy1 > outCy0) {
                System.arraycopy(BufferedAudioProcess.this.buff, outCy0, buffer.getChannel(0), 0, BufferedAudioProcess.this.required);
            } else {
                System.arraycopy(BufferedAudioProcess.this.buff, outCy0, buffer.getChannel(0), 0, BufferedAudioProcess.this.required - outCy1);
                System.arraycopy(BufferedAudioProcess.this.buff, 0, buffer.getChannel(0), BufferedAudioProcess.this.required - outCy1, outCy1);
            }
            BufferedAudioProcess.this.outPtr += (long)BufferedAudioProcess.this.required;
            return 0;
        }

        public void close() throws Exception {
        }

        public void open() throws Exception {
        }
    }

    class In
    implements AudioProcess {
        int cnt;

        In() {
        }

        public void close() throws Exception {
        }

        public void open() throws Exception {
        }

        public int processAudio(AudioBuffer buffer) {
            int n = buffer.getSampleCount();
            if (BufferedAudioProcess.this.inPtr + (long)n - BufferedAudioProcess.this.outPtr > (long)BufferedAudioProcess.this.cacheSize) {
                System.out.println(" OVERFLOW " + BufferedAudioProcess.this.overflowCount++);
                return -1;
            }
            int inCy1 = (int)((BufferedAudioProcess.this.inPtr + (long)n) % (long)BufferedAudioProcess.this.cacheSize);
            int inCy0 = (int)(BufferedAudioProcess.this.inPtr % (long)BufferedAudioProcess.this.cacheSize);
            if (inCy1 > inCy0) {
                System.arraycopy(buffer.getChannel(0), 0, BufferedAudioProcess.this.buff, inCy0, n);
            } else {
                System.arraycopy(buffer.getChannel(0), 0, BufferedAudioProcess.this.buff, inCy0, n - inCy1);
                System.arraycopy(buffer.getChannel(0), n - inCy1, BufferedAudioProcess.this.buff, 0, inCy1);
            }
            BufferedAudioProcess.this.inPtr += (long)n;
            if (BufferedAudioProcess.this.blocking && BufferedAudioProcess.this.inPtr - BufferedAudioProcess.this.outPtr > (long)BufferedAudioProcess.this.required) {
                BufferedAudioProcess.this.itWasMe = true;
                BufferedAudioProcess.this.outBlockingThread.interrupt();
            }
            return 0;
        }
    }
}

