/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.priority;

import java.io.File;

public class Priority {
    static {
        String libJJackFileName = null;
        try {
            System.loadLibrary("jjack");
            System.out.println("native priority library loaded using system library path");
        }
        catch (Throwable e) {
            try {
                File file = new File("lib/" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/libpriority.so");
                libJJackFileName = file.getAbsolutePath();
                System.load(libJJackFileName);
                System.out.println("loaded priority native library " + libJJackFileName);
            }
            catch (Throwable e2) {
                System.out.println("Problem loading priority library.");
                System.out.println("Tried system library path and " + libJJackFileName);
                e.printStackTrace();
                e2.printStackTrace();
            }
        }
    }

    public static native void setPriorityRR(int var0);

    public static native void setPriorityFIFO(int var0);

    public static native void setPriorityOTHER(int var0);

    public static native void display();

    public static double sleepTest() throws Exception {
        double maxM = 0.0;
        int nanoSleep = 5000000;
        int i = 0;
        while (i < 500) {
            long t1 = System.nanoTime();
            Thread.sleep(nanoSleep / 1000000, nanoSleep % 1000000);
            long t = System.nanoTime() - t1;
            double millis = (double)(t - (long)nanoSleep) / 1000000.0;
            maxM = Math.max(maxM, Math.abs(millis));
            ++i;
        }
        return maxM;
    }

    public static void main(String[] args) throws Exception {
        Priority.display();
        System.out.println("error =" + Priority.sleepTest());
        Priority.setPriorityRR(80);
        Priority.display();
        System.out.println("error =" + Priority.sleepTest());
        Priority.setPriorityFIFO(80);
        Priority.display();
        System.out.println("error =" + Priority.sleepTest());
        Priority.setPriorityOTHER(80);
        Priority.display();
        System.out.println("error =" + Priority.sleepTest());
    }
}

