/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;

class JavaSoundDevice {
    protected byte[] byteBuffer;
    protected Mixer mixer;
    protected AudioFormat af;
    protected DataLine.Info info;
    protected DataLine line;
    protected long bufferSizeInFrames;
    int bytesPerFrame;

    public JavaSoundDevice(Mixer mixer, AudioFormat af, DataLine.Info info, int bufferSizeInFrames) {
        this.mixer = mixer;
        this.af = af;
        this.info = info;
        this.line = null;
        this.bytesPerFrame = 2 * af.getChannels();
        this.byteBuffer = new byte[bufferSizeInFrames * this.bytesPerFrame];
    }

    public String toString() {
        if (this.af.getChannels() == 1) {
            return String.valueOf(this.mixer.getMixerInfo().getName()) + " (MONO)";
        }
        if (this.af.getChannels() == 2) {
            return String.valueOf(this.mixer.getMixerInfo().getName()) + " (STEREO)";
        }
        return String.valueOf(this.mixer.getMixerInfo().getName()) + "(" + this.af.getChannels() + ")";
    }

    public int getChannels() {
        return this.af.getChannels();
    }

    public AudioFormat getFormat() {
        return this.af;
    }

    public boolean isOpen() {
        if (this.line == null) {
            return false;
        }
        return this.line.isOpen();
    }

    public String getName() {
        return this.toString();
    }

    public boolean isActive() {
        if (this.line == null) {
            return false;
        }
        return this.line.isActive();
    }

    public byte[] getBuffer() {
        return this.byteBuffer;
    }
}

