/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundDevice;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import uk.org.toot.audio.server.AudioSyncLine;

class JavaSoundOutDevice
extends JavaSoundDevice
implements AudioSyncLine {
    protected long framesWritten = 0L;
    boolean hasStarted = false;
    private int latencyFrames;
    int cnt = 0;

    public JavaSoundOutDevice(Mixer mixer, AudioFormat af, DataLine.Info info, int bufferSizeInFrames) {
        super(mixer, af, info, bufferSizeInFrames);
    }

    public void writeBuffer() {
        if (this.line.available() > this.byteBuffer.length) {
            int nnn = ((SourceDataLine)this.line).write(this.byteBuffer, 0, this.byteBuffer.length);
            this.framesWritten += (long)(nnn / this.bytesPerFrame);
        } else if (this.cnt++ % 50 == 0) {
            System.out.println(" XXXRUUNNN ");
        }
        this.latencyFrames = (int)(this.framesWritten - this.line.getLongFramePosition());
    }

    public void start() throws Exception {
        this.framesWritten = 0L;
        this.open();
    }

    public void stop() throws Exception {
        this.close();
    }

    public void open() {
        System.out.println(" Opening MixrerAudioDevice line");
        if (this.isOpen()) {
            return;
        }
        try {
            if (this.line == null) {
                this.line = (SourceDataLine)this.mixer.getLine(this.info);
            }
            ((SourceDataLine)this.line).open(this.af);
            System.out.println("  . . ..  Open");
            this.line.flush();
            this.line.start();
            System.out.println("  . . ..  Start  " + this.isOpen());
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.line.close();
    }

    public int getLatencyFrames() {
        return this.latencyFrames;
    }

    public void zeroBuffer() {
        Arrays.fill(this.byteBuffer, (byte)0);
    }
}

