/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.PriorityAudioServer;
import com.frinika.toot.javasoundmultiplexed.DeviceManager;
import com.frinika.toot.javasoundmultiplexed.JavaSoundInDevice;
import com.frinika.toot.javasoundmultiplexed.JavaSoundOutDevice;
import com.frinika.toot.javasoundmultiplexed.MonoInConnection;
import com.frinika.toot.javasoundmultiplexed.StereoInConnection;
import com.frinika.toot.javasoundmultiplexed.StereoOutConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.org.toot.audio.server.AudioLine;
import uk.org.toot.audio.server.IOAudioProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexedJavaSoundAudioServer
extends PriorityAudioServer {
    private JavaSoundInDevice inDevice;
    private JavaSoundOutDevice outDevice;
    private List<AudioLine> outputs = new ArrayList<AudioLine>();
    private List<AudioLine> inputs = new ArrayList<AudioLine>();
    int bufferSizeInFrames;
    private DeviceManager deviceManager;

    public MultiplexedJavaSoundAudioServer() {
        this.isRunning = false;
        this.bufferSizeInFrames = this.calculateBufferFrames();
        System.out.println(" MultiplexBufferSize " + this.bufferSizeInFrames);
        try {
            this.deviceManager = new DeviceManager(this.bufferSizeInFrames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getSampleRate() {
        return 44100.0f;
    }

    @Override
    public int getSampleSizeInBits() {
        return 16;
    }

    @Override
    public List<AudioLine> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    @Override
    public List<AudioLine> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    protected void resizeBuffers() {
        try {
            throw new Exception(" NO resizing implmented for the multiplexed server");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public List<String> getInDeviceList() {
        return this.deviceManager.getInDeviceList();
    }

    public List<String> getOutDeviceList() {
        return this.deviceManager.getOutDeviceList();
    }

    public void setOutDevice(String name) {
        this.outDevice = this.deviceManager.getOutDevice(name);
        this.outputs.clear();
        int i = 0;
        while (i < this.outDevice.getChannels() / 2) {
            int[] chan = new int[]{i * 2, i * 2 + 1};
            this.outputs.add(new StereoOutConnection(this.outDevice, chan));
            ++i;
        }
    }

    public void setInDevice(String name) {
        this.inDevice = this.deviceManager.getInDevice(name);
        this.inputs.clear();
        int i = 0;
        while (i < this.inDevice.getChannels()) {
            this.inputs.add(new MonoInConnection(this.inDevice, i));
            ++i;
        }
        i = 0;
        while (i < this.inDevice.getChannels() / 2) {
            int[] chan = new int[]{i * 2, i * 2 + 1};
            this.inputs.add(new StereoInConnection(this.inDevice, chan));
            ++i;
        }
    }

    public int getOutputLatencyFrames() {
        if (this.syncLine == null) {
            return 0;
        }
        return this.syncLine.getLatencyFrames();
    }

    public int getInputLatencyFrames() {
        if (this.inDevice == null) {
            return 0;
        }
        return this.inDevice.getLatencyFrames();
    }

    public List<String> getAvailableOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AudioLine line : this.outputs) {
            names.add(line.getName());
        }
        return names;
    }

    public List<String> getAvailableInputNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AudioLine line : this.inputs) {
            names.add(line.getName());
        }
        return names;
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.inDevice != null) {
            try {
                this.inDevice.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.outDevice != null) {
            try {
                this.outDevice.start();
                this.syncLine = this.outDevice;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        if (this.inDevice != null) {
            try {
                this.inDevice.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.outDevice != null) {
            try {
                this.outDevice.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.stop();
    }

    public IOAudioProcess openAudioOutput(String name, String label) throws Exception {
        for (AudioLine line : this.outputs) {
            if (!name.equals(line.getName())) continue;
            return line;
        }
        return null;
    }

    public void closeAudioOutput(IOAudioProcess output) {
    }

    public IOAudioProcess openAudioInput(String name, String label) throws Exception {
        for (AudioLine line : this.inputs) {
            if (!name.equals(line.getName())) continue;
            return line;
        }
        return null;
    }

    public void closeAudioInput(IOAudioProcess input) {
    }

    @Override
    public void setLatencyMilliseconds(float ms) {
        if (ms < this.getLatencyMilliseconds()) {
            this.flushInputs();
        }
        super.setLatencyMilliseconds(ms);
    }

    protected void flushInputs() {
        if (this.inDevice != null) {
            this.inDevice.flush();
        }
    }

    @Override
    protected void controlGained() {
        this.flushInputs();
    }

    @Override
    public String getConfigKey() {
        return "java_multiplexed";
    }

    @Override
    public void work() {
        if (this.inDevice != null) {
            this.inDevice.fillBuffer();
        }
        if (this.outDevice != null) {
            this.outDevice.zeroBuffer();
        }
        super.work();
        if (this.outDevice != null) {
            this.outDevice.writeBuffer();
        }
    }
}

