/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import com.frinika.toot.PriorityAudioServer;
import java.util.Properties;
import uk.org.toot.audio.server.AudioServerConfiguration;
import uk.org.toot.audio.server.ExtendedAudioServer;

public class ExtendedAudioServerConfiguration
extends AudioServerConfiguration {
    private static final String HARDWARE_BUFFER = "hardware.buffer.frames";
    private static final String USER_BUFFER = ".buffer.milliseconds";
    private static final String LATENCY = ".latency.milliseconds";
    private static final String PRIORITY = ".priority";
    private ExtendedAudioServer server;
    private boolean hasPriority;

    public ExtendedAudioServerConfiguration(ExtendedAudioServer server) {
        this.server = server;
        this.hasPriority = System.getProperty("os.name").equals("Linux") && server instanceof PriorityAudioServer;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        String k = this.server.getConfigKey();
        p.setProperty(HARDWARE_BUFFER, String.valueOf(this.server.getHardwareLatencyFrames()));
        p.setProperty(String.valueOf(k) + USER_BUFFER, String.valueOf(this.server.getBufferMilliseconds()));
        p.setProperty(String.valueOf(k) + LATENCY, String.valueOf(this.server.getLatencyMilliseconds()));
        if (this.hasPriority) {
            PriorityAudioServer pas = (PriorityAudioServer)this.server;
            p.setProperty(String.valueOf(k) + PRIORITY, String.valueOf(pas.getPriority()));
        }
        return p;
    }

    public void applyProperties(Properties p) {
        String k;
        if (p == null) {
            System.err.println("null properties passed to ExtendedAudioServerConfiguration.applyProperties()");
            return;
        }
        String value = p.getProperty(HARDWARE_BUFFER);
        if (value != null) {
            this.server.setHardwareLatencyFrames(Integer.valueOf(value));
        }
        if ((value = p.getProperty(String.valueOf(k = this.server.getConfigKey()) + USER_BUFFER)) != null) {
            this.server.setBufferMilliseconds(Float.valueOf(value).floatValue());
        }
        if ((value = p.getProperty(String.valueOf(k) + LATENCY)) == null) {
            value = p.getProperty(String.valueOf(k) + "_outputBuffer");
        }
        if (value != null) {
            this.server.setLatencyMilliseconds(Float.valueOf(value).floatValue());
        }
        if (this.hasPriority) {
            value = p.getProperty(String.valueOf(k) + PRIORITY);
            if (value == null) {
                value = p.getProperty(String.valueOf(k) + "_priority");
            }
            if (value != null) {
                PriorityAudioServer pas = (PriorityAudioServer)this.server;
                pas.requestPriority(Integer.valueOf(value));
            }
        }
    }
}

