/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.preview;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.drag.effects.DefaultPreview;

public class AlphaPreview
extends DefaultPreview {
    public static final float DEFAULT_ALPHA = 0.5f;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Color DEFAULT_BORDER = Color.BLACK;
    public static final AlphaPreview BLUE = new AlphaPreview(Color.BLACK, Color.BLUE.brighter().brighter().brighter().brighter(), 0.2f, true);
    public static final AlphaPreview BLACK = new AlphaPreview(Color.BLACK, Color.BLACK.brighter().brighter().brighter().brighter(), 0.25f, true);
    private float previewAlpha;
    private Color previewColor;
    private Color borderColor;
    private boolean immutable;

    public AlphaPreview() {
        this(DEFAULT_BORDER, DEFAULT_COLOR, 0.5f, false);
    }

    public AlphaPreview(Color border, Color fill, float alpha) {
        this(border, fill, alpha, false);
    }

    public AlphaPreview(Color border, Color fill, float alpha, boolean immutable) {
        this.setBorderColor(border);
        this.setPreviewColor(fill);
        this.setAlpha(alpha);
        this.immutable = immutable;
    }

    public void setPreviewColor(Color color) {
        if (!this.immutable) {
            this.previewColor = color == null ? DEFAULT_COLOR : color;
        }
    }

    public void setAlpha(float alpha) {
        if (!this.immutable) {
            alpha = Math.max(0.0f, alpha);
            this.previewAlpha = alpha = Math.min(alpha, 1.0f);
        }
    }

    public void setBorderColor(Color color) {
        if (!this.immutable) {
            this.borderColor = color == null ? DEFAULT_BORDER : color;
        }
    }

    public void drawPreview(Graphics2D g, Polygon p, Dockable dockable, Map dragInfo) {
        Rectangle rect = p.getBounds();
        g.setColor(this.borderColor);
        g.draw3DRect(rect.x, rect.y, rect.width - 1, rect.height - 1, false);
        AlphaComposite composite = AlphaComposite.getInstance(3, this.previewAlpha);
        g.setComposite(composite);
        g.setColor(this.previewColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }
}

