/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.state.DockingState;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.util.DockingUtility;

public class LayoutSequence
implements Cloneable,
Serializable,
DockingConstants {
    private List sequence;

    public LayoutSequence() {
        this(new ArrayList());
    }

    public LayoutSequence(DockingState[] dockingStates) {
        this(dockingStates == null ? new ArrayList() : Arrays.asList(dockingStates));
    }

    private LayoutSequence(List list) {
        this.sequence = list;
    }

    public void add(Dockable dockable) {
        this.add(dockable, null);
    }

    public void add(String dockable) {
        this.add(dockable, null);
    }

    public void add(Dockable dockable, Dockable relativeParent) {
        this.add(dockable, relativeParent, "CENTER", -1.0f);
    }

    public void add(String dockable, String relativeParent) {
        this.add(dockable, relativeParent, "CENTER", -1.0f);
    }

    public void add(Dockable dockable, Dockable relativeParent, String region, float ratio) {
        String dockableId = dockable == null ? null : dockable.getPersistentId();
        String parentId = relativeParent == null ? null : relativeParent.getPersistentId();
        this.add(dockableId, parentId, region, ratio);
    }

    public void add(String dockableId, String relativeParentId, String region, float ratio) {
        if (dockableId == null) {
            return;
        }
        if (relativeParentId == null && this.sequence.size() > 0) {
            throw new IllegalStateException("All calls to add() after the first dockable has been added MUST specify a relative dockable parent.");
        }
        DockingState info = new DockingState(dockableId);
        info.setRelativeParentId(relativeParentId);
        info.setRegion(region);
        info.setSplitRatio(ratio);
        this.sequence.add(info);
    }

    public void add(DockingState dockingState) {
        if (dockingState == null) {
            return;
        }
        this.sequence.add(dockingState);
    }

    public void apply(DockingPort port) {
        if (port == null) {
            return;
        }
        boolean listen = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        PerspectiveManager.clear(port);
        int len = this.sequence.size();
        Dockable[] dockables = new Dockable[len];
        for (int i = 0; i < len; ++i) {
            Dockable dockable;
            DockingState info = (DockingState)this.sequence.get(i);
            dockables[i] = dockable = info.getDockable();
            String region = info.getRegion();
            if (i == 0) {
                DockingManager.dock(info.getDockable(), port, info.getRegion());
                continue;
            }
            Dockable parent = info.getRelativeParent();
            float ratio = info.getSplitRatio();
            DockingUtility.dockRelative(dockable, parent, region, ratio);
        }
        PerspectiveManager.setDockingStateListening(listen);
        PerspectiveManager.updateDockingStates(dockables);
    }

    public List getDockingStates() {
        return this.getSequenceClone();
    }

    private ArrayList getSequenceClone() {
        ArrayList<Object> list = new ArrayList<Object>(this.sequence.size());
        Iterator it = this.sequence.iterator();
        while (it.hasNext()) {
            DockingState info = (DockingState)it.next();
            list.add(info.clone());
        }
        return list;
    }

    public Object clone() {
        return new LayoutSequence(this.getSequenceClone());
    }
}

