/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.InvalidDataException;
import com.sun.media.sound.InvalidFormatException;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.PATSample;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.Patch;
import javax.sound.sampled.AudioFormat;

public class PATInstrument
extends ModelInstrument {
    protected int preset = 0;
    protected int bank = 0;
    protected boolean percussion = false;
    protected String name = "";
    protected String description = "";
    protected String format = "GF1PATCH110";
    protected String vendor = "ID#000002";
    protected PATSample[] samples = null;
    protected int volume;
    private boolean largeFormat = false;
    private File sampleFile;
    private OffsetInputStream ois;

    public PATInstrument() {
        super(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PATInstrument(URL uRL) throws IOException {
        super(null, null, null, null);
        InputStream inputStream = uRL.openStream();
        try {
            this.readPatch(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PATInstrument(File file) throws IOException {
        super(null, null, null, null);
        this.largeFormat = true;
        this.sampleFile = file;
        InputStream inputStream = new FileInputStream(file);
        this.ois = new OffsetInputStream(inputStream);
        inputStream = this.ois;
        try {
            this.readPatch(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public PATInstrument(InputStream inputStream) throws IOException {
        super(null, null, null, null);
        this.readPatch(inputStream);
    }

    private String readString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i, "ASCII");
        }
        return new String(byArray, "ASCII");
    }

    private void readPatch(InputStream inputStream) throws IOException {
        this.format = this.readString(inputStream, 12);
        this.vendor = this.readString(inputStream, 10);
        if (!this.format.equals("GF1PATCH110") && !this.format.equals("GF1PATCH100")) {
            throw new InvalidFormatException();
        }
        if (!this.vendor.equals("ID#000002")) {
            throw new InvalidFormatException();
        }
        this.description = this.readString(inputStream, 60);
        int n = inputStream.read();
        if (n > 1) {
            throw new InvalidDataException("Invalid instrument count.");
        }
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 > 1) {
            throw new InvalidDataException("Invalid channels count.");
        }
        int n4 = inputStream.read() + (inputStream.read() << 8);
        this.volume = inputStream.read() + (inputStream.read() << 8);
        int n5 = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        byte[] byArray = new byte[36];
        inputStream.read(byArray);
        int n6 = inputStream.read() + (inputStream.read() << 8);
        this.name = this.readString(inputStream, 16);
        int n7 = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        int n8 = inputStream.read();
        if (n8 > 1) {
            throw new InvalidDataException("Invalid layers count.");
        }
        byte[] byArray2 = new byte[40];
        inputStream.read(byArray2);
        int n9 = inputStream.read();
        int n10 = inputStream.read();
        int n11 = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        int n12 = inputStream.read();
        byte[] byArray3 = new byte[40];
        inputStream.read(byArray3);
        this.samples = new PATSample[n12];
        for (int i = 0; i < n12; ++i) {
            this.samples[i] = this.readSample(inputStream);
        }
    }

    private PATSample readSample(InputStream inputStream) throws IOException {
        PATSample pATSample = new PATSample();
        pATSample.wavename = this.readString(inputStream, 7);
        pATSample.fractions = inputStream.read();
        int n = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.loopstart = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.loopend = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.samplerate = inputStream.read() + (inputStream.read() << 8);
        pATSample.lowfreq = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.hifreq = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.rootfreq = inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
        pATSample.tune = inputStream.read() + (inputStream.read() << 8);
        pATSample.pan = inputStream.read();
        pATSample.env_attack_rate = inputStream.read();
        pATSample.env_decay_rate = inputStream.read();
        pATSample.env_sustain_rate = inputStream.read();
        pATSample.env_release1_rate = inputStream.read();
        pATSample.env_release2_rate = inputStream.read();
        pATSample.env_release3_rate = inputStream.read();
        pATSample.env_attack_offset = inputStream.read();
        pATSample.env_decay_offset = inputStream.read();
        pATSample.env_sustain_offset = inputStream.read();
        pATSample.env_release1_offset = inputStream.read();
        pATSample.env_release2_offset = inputStream.read();
        pATSample.env_release3_offset = inputStream.read();
        pATSample.tremolo_sweep = inputStream.read();
        pATSample.tremolo_rate = inputStream.read();
        pATSample.tremolo_depth = inputStream.read();
        pATSample.vibrato_sweep = inputStream.read();
        pATSample.vibrato_rate = inputStream.read();
        pATSample.vibrato_depth = inputStream.read();
        pATSample.sampling_mode = inputStream.read();
        pATSample.scalefreq = inputStream.read() + (inputStream.read() << 8);
        pATSample.scalefactor = inputStream.read() + (inputStream.read() << 8);
        byte[] byArray = new byte[36];
        inputStream.read(byArray);
        if (this.largeFormat) {
            long l = this.ois.getFilePointer();
            inputStream.skip(n);
            pATSample.sampledata = new ModelByteBuffer(this.sampleFile, l, (long)n);
        } else {
            byte[] byArray2 = new byte[n];
            inputStream.read(byArray2);
            pATSample.sampledata = new ModelByteBuffer(byArray2);
        }
        return pATSample;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ModelPatch getPatch() {
        return new ModelPatch(this.bank, this.preset, this.percussion);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.percussion = true;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        } else {
            this.percussion = false;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    private double convertRate(int n) {
        return (double)(n & 0x3F) * Math.pow(0.5, 3 * (n >> 6 & 3));
    }

    public ModelPerformer[] getPerformers() {
        ModelPerformer[] modelPerformerArray = new ModelPerformer[this.samples.length];
        for (int i = 0; i < modelPerformerArray.length; ++i) {
            double d;
            double d2;
            double d3;
            ModelPerformer modelPerformer = new ModelPerformer();
            PATSample pATSample = this.samples[i];
            modelPerformer.setName(this.samples[i].wavename);
            double d4 = 69.0 + 12.0 * Math.log((double)pATSample.lowfreq / 1000.0 / 440.0) / Math.log(2.0);
            double d5 = 69.0 + 12.0 * Math.log((double)pATSample.hifreq / 1000.0 / 440.0) / Math.log(2.0);
            modelPerformer.setKeyFrom((int)Math.ceil(d4));
            modelPerformer.setKeyTo((int)Math.floor(d5));
            ModelByteBuffer modelByteBuffer = pATSample.sampledata;
            boolean bl = (pATSample.sampling_mode & 1) != 0;
            boolean bl2 = (pATSample.sampling_mode & 2) != 0;
            boolean bl3 = (pATSample.sampling_mode & 4) != 0;
            boolean bl4 = (pATSample.sampling_mode & 8) != 0;
            boolean bl5 = (pATSample.sampling_mode & 0x10) != 0;
            boolean bl6 = (pATSample.sampling_mode & 0x40) != 0;
            AudioFormat audioFormat = null;
            audioFormat = bl ? new AudioFormat(pATSample.samplerate, 16, 1, !bl2, false) : new AudioFormat(pATSample.samplerate, 8, 1, !bl2, false);
            float f = -((float)(69.0 + 12.0 * Math.log((double)pATSample.rootfreq / 1000.0 / 440.0) / Math.log(2.0)));
            ModelByteBufferWavetable modelByteBufferWavetable = new ModelByteBufferWavetable(modelByteBuffer, audioFormat, f *= 100.0f);
            float f2 = (float)pATSample.loopstart + (float)(pATSample.fractions & 0xF) / 16.0f;
            float f3 = (float)pATSample.loopend + (float)(pATSample.fractions >> 4) / 16.0f;
            if (bl3) {
                if (bl) {
                    modelByteBufferWavetable.setLoopStart(f2 / 2.0f);
                    modelByteBufferWavetable.setLoopLength(f3 / 2.0f - f2 / 2.0f);
                } else {
                    modelByteBufferWavetable.setLoopStart(f2);
                    modelByteBufferWavetable.setLoopLength(f3 - f2);
                }
                modelByteBufferWavetable.setLoopType(1);
                if (bl4) {
                    modelByteBufferWavetable.setLoopType(4);
                }
                if (bl5) {
                    modelByteBufferWavetable.setLoopType(8);
                }
            }
            modelPerformer.getOscillators().add(modelByteBufferWavetable);
            double d6 = (double)pATSample.vibrato_rate / 42.0;
            double d7 = (double)pATSample.tremolo_rate / 42.0;
            double d8 = 400.0 * (double)pATSample.vibrato_depth / 256.0;
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(6900.0 + 1200.0 * Math.log(d7 / 440.0) / Math.log(2.0), new ModelDestination(ModelDestination.DESTINATION_LFO1_FREQ)));
            if (d8 > 0.0) {
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(6900.0 + 1200.0 * Math.log(d6 / 440.0) / Math.log(2.0), new ModelDestination(ModelDestination.DESTINATION_LFO2_FREQ)));
            }
            if (d8 > 0.0) {
                ModelIdentifier modelIdentifier = ModelSource.SOURCE_LFO2;
                ModelIdentifier modelIdentifier2 = ModelDestination.DESTINATION_PITCH;
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier, false, true), d8, new ModelDestination(modelIdentifier2)));
            }
            if ((d3 = -200.0 * Math.log(1.0 - (double)pATSample.tremolo_depth / 256.0) / Math.log(10.0)) > 960.0) {
                d3 = 960.0;
            }
            if (d3 > 0.0) {
                ModelIdentifier modelIdentifier = ModelSource.SOURCE_LFO1;
                ModelIdentifier modelIdentifier3 = ModelDestination.DESTINATION_GAIN;
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier, false, true), d3, new ModelDestination(modelIdentifier3)));
            }
            double d9 = (double)this.volume / 128.0;
            if (bl6) {
                d2 = (double)pATSample.env_attack_offset / this.convertRate(pATSample.env_attack_rate);
                d = 0.5 * (double)(pATSample.env_attack_offset - pATSample.env_decay_offset) / this.convertRate(pATSample.env_decay_rate);
                d += 0.5 * (double)(pATSample.env_decay_offset - pATSample.env_sustain_offset) / this.convertRate(pATSample.env_sustain_rate);
                double d10 = 0.5 * (double)(pATSample.env_attack_offset - 0) / this.convertRate(pATSample.env_release1_rate);
                double d11 = (double)pATSample.env_attack_offset / 256.0;
                double d12 = (double)pATSample.env_sustain_offset / 256.0;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d10 < 0.0) {
                    d10 = 0.0;
                }
                d9 *= d11;
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d12 * 1000.0, new ModelDestination(ModelDestination.DESTINATION_EG1_SUSTAIN)));
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(1200.0 * Math.log(d2 / 1000.0) / Math.log(2.0), new ModelDestination(ModelDestination.DESTINATION_EG1_ATTACK)));
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(1200.0 * Math.log(d / 1000.0) / Math.log(2.0), new ModelDestination(ModelDestination.DESTINATION_EG1_DECAY)));
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(1200.0 * Math.log(d10 / 1000.0) / Math.log(2.0), new ModelDestination(ModelDestination.DESTINATION_EG1_RELEASE)));
            } else if (!bl3) {
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(12000.0, new ModelDestination(ModelDestination.DESTINATION_EG1_RELEASE)));
            }
            d2 = 20.0 / Math.log(10.0) * Math.log(d9);
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d2, new ModelDestination(ModelDestination.DESTINATION_GAIN)));
            d = 500.0;
            if (pATSample.pan < 7) {
                d = (double)pATSample.pan / 7.0 * 500.0;
            }
            if (pATSample.pan > 8) {
                d += (double)(pATSample.pan - 8) / 7.0 * 500.0;
            }
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d - 500.0, new ModelDestination(ModelDestination.DESTINATION_PAN)));
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO2, false, true, 0), new ModelSource(new ModelIdentifier("midi_cc", "1", 0), false, false, 0), 50.0, new ModelDestination(ModelDestination.DESTINATION_PITCH)));
            modelPerformerArray[i] = modelPerformer;
        }
        return modelPerformerArray;
    }

    public PATSample[] getSamples() {
        return this.samples;
    }

    public void setSamples(PATSample[] pATSampleArray) {
        this.samples = pATSampleArray;
    }

    private class OffsetInputStream
    extends InputStream {
        private InputStream is;
        private int filepointer = 0;

        public OffsetInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public long getFilePointer() throws IOException {
            return this.filepointer;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.is.read(byArray, n, n2);
            if (n3 != -1) {
                this.filepointer += n3;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            long l2 = this.is.skip(l);
            if (l2 != -1L) {
                this.filepointer = (int)((long)this.filepointer + l2);
            }
            return l2;
        }

        public int read() throws IOException {
            int n = this.is.read();
            if (n != -1) {
                ++this.filepointer;
            }
            return n;
        }
    }
}

