/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.InvalidFormatException;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelWavetable;
import com.sun.media.sound.PATInstrument;
import com.sun.media.sound.SimpleInstrument;
import com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;

public class PATSoundbankReader
extends SoundbankReader {
    public Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        try {
            PATInstrument pATInstrument = new PATInstrument(uRL);
            SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
            simpleSoundbank.addInstrument(pATInstrument);
            return simpleSoundbank;
        }
        catch (InvalidFormatException invalidFormatException) {
            return null;
        }
    }

    public Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        try {
            inputStream.mark(512);
            PATInstrument pATInstrument = new PATInstrument(inputStream);
            SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
            simpleSoundbank.addInstrument(pATInstrument);
            return simpleSoundbank;
        }
        catch (InvalidFormatException invalidFormatException) {
            inputStream.reset();
            return null;
        }
    }

    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        if (file.getPath().toLowerCase().endsWith(".cfg")) {
            return this.readConfigFile(file);
        }
        if (!file.getPath().toLowerCase().endsWith(".pat")) {
            return null;
        }
        try {
            PATInstrument pATInstrument = new PATInstrument(file);
            SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
            simpleSoundbank.addInstrument(pATInstrument);
            return simpleSoundbank;
        }
        catch (InvalidFormatException invalidFormatException) {
            return null;
        }
    }

    private ModelPerformer[] processDrumKit(PATInstrument pATInstrument) {
        ModelPerformer[] modelPerformerArray;
        for (ModelPerformer modelPerformer : modelPerformerArray = pATInstrument.getPerformers()) {
            double d = (double)(-((ModelWavetable)modelPerformer.getOscillators().get(0)).getPitchcorrection()) / 100.0;
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d / 128.0, new ModelDestination(ModelDestination.DESTINATION_KEYNUMBER)));
            if (((ModelWavetable)modelPerformer.getOscillators().get(0)).getLoopType() != 0) continue;
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(12000.0, new ModelDestination(ModelDestination.DESTINATION_EG1_RELEASE)));
        }
        return modelPerformerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Soundbank readConfigFile(File file) throws InvalidMidiDataException, IOException {
        File file2 = file.getParentFile();
        SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            try {
                int n = -2;
                int n2 = -1;
                SimpleInstrument simpleInstrument = null;
                HashMap<Integer, Serializable> hashMap = new HashMap<Integer, Serializable>();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ASCII");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    int n3;
                    StringTokenizer object;
                    int n4 = string.indexOf(35);
                    if (n4 != -1) {
                        string = string.substring(0, n4);
                    }
                    if ((string = string.trim()).length() == 0 || !(object = new StringTokenizer(string, " ")).hasMoreTokens()) continue;
                    String n8 = object.nextToken();
                    if (n8.equalsIgnoreCase("drumset")) {
                        if (!object.hasMoreTokens()) continue;
                        n8 = object.nextToken();
                        n2 = Integer.parseInt(n8);
                        n = -1;
                        simpleInstrument = new SimpleInstrument();
                        simpleInstrument.setPatch(new ModelPatch(0, n2, true));
                        simpleSoundbank.addInstrument(simpleInstrument);
                        continue;
                    }
                    if (n8.equalsIgnoreCase("bank")) {
                        if (!object.hasMoreTokens()) continue;
                        n8 = object.nextToken();
                        n2 = -1;
                        n = Integer.parseInt(n8);
                        continue;
                    }
                    if (n == -2) {
                        Serializable serializable;
                        n3 = 0;
                        int entry = 0;
                        int n5 = n8.indexOf(45);
                        if (n5 == -1) {
                            n3 = Integer.parseInt(n8) - 1;
                            entry = Integer.parseInt(n8) - 1;
                        } else {
                            n3 = Integer.parseInt(n8.substring(0, n5)) - 1;
                            entry = Integer.parseInt(n8.substring(n5 + 1)) - 1;
                        }
                        if (entry < 0 || entry < n3) continue;
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        if (!object.hasMoreTokens()) continue;
                        n8 = object.nextToken();
                        if (n8.equals("begin_multipatch") || n8.equals("override_patch")) {
                            HashMap stringTokenizer;
                            serializable = new HashMap();
                            if (n8.equals("override_patch") && (stringTokenizer = (HashMap)hashMap.get(n3)) != null) {
                                ((HashMap)serializable).putAll(stringTokenizer);
                            }
                            for (int i = n3; i <= entry; ++i) {
                                hashMap.put(i, serializable);
                            }
                            while ((string = bufferedReader.readLine()) != null && !string.equals("end_multipatch")) {
                                StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
                                if (!stringTokenizer2.hasMoreTokens()) continue;
                                int n6 = Integer.parseInt(stringTokenizer2.nextToken().trim());
                                if (!stringTokenizer2.hasMoreTokens()) continue;
                                n8 = stringTokenizer2.nextToken();
                                File file3 = new File(file2, n8);
                                if (!file3.exists()) {
                                    file3 = new File(file2, n8 + ".pat");
                                }
                                ((HashMap)serializable).put(n6, this.processDrumKit(new PATInstrument(file3)));
                            }
                            continue;
                        }
                        serializable = new File(file2, n8);
                        if (!((File)serializable).exists()) {
                            serializable = new File(file2, n8 + ".pat");
                        }
                        for (int i = n3; i <= entry; ++i) {
                            PATInstrument pATInstrument = new PATInstrument((File)serializable);
                            if (i != 0) {
                                if (i >= 128) {
                                    pATInstrument.setPatch(new ModelPatch(0, i - 128, true));
                                } else {
                                    pATInstrument.setPatch(new Patch(0, i));
                                }
                            }
                            simpleSoundbank.addInstrument(pATInstrument);
                        }
                        continue;
                    }
                    n3 = Integer.parseInt(n8);
                    if (!object.hasMoreTokens()) continue;
                    n8 = object.nextToken();
                    File file4 = new File(file2, n8);
                    if (!file4.exists()) {
                        file4 = new File(file2, n8 + ".pat");
                    }
                    PATInstrument pATInstrument = new PATInstrument(file4);
                    if (n != -1) {
                        pATInstrument.setPatch(new Patch(n, n3));
                        simpleSoundbank.addInstrument(pATInstrument);
                        continue;
                    }
                    if (n2 == -1) continue;
                    simpleInstrument.add(this.processDrumKit(pATInstrument), n3, n3);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n7 = (Integer)entry.getKey();
                    simpleInstrument = new SimpleInstrument();
                    if (n7 >= 128) {
                        simpleInstrument.setPatch(new ModelPatch(0, n7 - 128, true));
                    } else {
                        simpleInstrument.setPatch(new Patch(0, n7));
                    }
                    simpleInstrument.add((ModelPerformer[])((HashMap)entry.getValue()).get(36));
                    for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                        simpleInstrument.add((ModelPerformer[])entry2.getValue(), (int)((Integer)entry2.getKey()), (int)((Integer)entry2.getKey()));
                    }
                    simpleSoundbank.addInstrument(simpleInstrument);
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return simpleSoundbank;
    }
}

