/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class RIFFReader
extends InputStream {
    private RIFFReader root;
    private long filepointer = 0L;
    private String fourcc;
    private String riff_type = null;
    private long ckSize = 0L;
    private InputStream stream;
    private long avail;
    private RIFFReader lastiterator = null;

    public RIFFReader(InputStream inputStream) throws IOException {
        int n;
        this.root = inputStream instanceof RIFFReader ? ((RIFFReader)inputStream).root : this;
        this.stream = inputStream;
        this.avail = inputStream.available();
        this.ckSize = inputStream.available();
        do {
            if ((n = this.read()) != -1) continue;
            this.fourcc = "";
            this.riff_type = null;
            this.avail = 0L;
            return;
        } while (n == 0);
        byte[] byArray = new byte[4];
        byArray[0] = (byte)n;
        this.read(byArray, 1, 3);
        this.fourcc = new String(byArray, "ascii");
        this.avail = this.ckSize = this.readUnsignedInt();
        if (this.getFormat().equals("RIFF") || this.getFormat().equals("LIST")) {
            byte[] byArray2 = new byte[4];
            this.read(byArray2);
            this.riff_type = new String(byArray2, "ascii");
        }
    }

    public long getFilePointer() throws IOException {
        return this.root.filepointer;
    }

    public boolean hasNextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        return this.avail != 0L;
    }

    public RIFFReader nextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        if (this.avail == 0L) {
            return null;
        }
        this.lastiterator = new RIFFReader(this);
        return this.lastiterator;
    }

    public String getFormat() {
        return this.fourcc;
    }

    public String getType() {
        return this.riff_type;
    }

    public long getSize() {
        return this.ckSize;
    }

    public int read() throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        int n = this.stream.read();
        if (n == -1) {
            return -1;
        }
        --this.avail;
        ++this.filepointer;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        if ((long)n2 > this.avail) {
            int n3 = this.stream.read(byArray, n, (int)this.avail);
            if (n3 != -1) {
                this.filepointer += (long)n3;
            }
            this.avail = 0L;
            return n3;
        }
        this.avail -= (long)n2;
        int n4 = this.stream.read(byArray, n, n2);
        if (n4 == -1) {
            return -1;
        }
        this.filepointer += (long)n4;
        return n4;
    }

    public long skip(long l) throws IOException {
        if (this.avail == 0L) {
            return -1L;
        }
        if (l > this.avail) {
            long l2 = this.stream.skip(this.avail);
            if (l2 != -1L) {
                this.filepointer += l2;
            }
            this.avail = 0L;
            return l2;
        }
        this.avail -= l;
        long l3 = this.stream.skip(l);
        if (l3 == -1L) {
            return -1L;
        }
        this.filepointer += l3;
        return l3;
    }

    public int available() {
        return (int)this.avail;
    }

    public void finish() throws IOException {
        if (this.avail != 0L) {
            long l = this.stream.skip(this.avail);
            if (l != -1L) {
                this.filepointer += l;
            }
            this.avail = 0L;
        }
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i, "ascii");
        }
        return new String(byArray, "ascii");
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public short readShort() throws IOException {
        int n = this.read();
        int n2 = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)(n | n2 << 8);
    }

    public int readInt() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        if (n3 < 0) {
            throw new EOFException();
        }
        if (n4 < 0) {
            throw new EOFException();
        }
        return n + (n2 << 8) | n3 << 16 | n4 << 24;
    }

    public long readLong() throws IOException {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        long l5 = this.read();
        long l6 = this.read();
        long l7 = this.read();
        long l8 = this.read();
        if (l < 0L) {
            throw new EOFException();
        }
        if (l2 < 0L) {
            throw new EOFException();
        }
        if (l3 < 0L) {
            throw new EOFException();
        }
        if (l4 < 0L) {
            throw new EOFException();
        }
        if (l5 < 0L) {
            throw new EOFException();
        }
        if (l6 < 0L) {
            throw new EOFException();
        }
        if (l7 < 0L) {
            throw new EOFException();
        }
        if (l8 < 0L) {
            throw new EOFException();
        }
        return l | l2 << 8 | l3 << 16 | l4 << 24 | l5 << 32 | l6 << 40 | l7 << 48 | l8 << 56;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int readUnsignedShort() throws IOException {
        int n = this.read();
        int n2 = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        return n | n2 << 8;
    }

    public long readUnsignedInt() throws IOException {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        if (l < 0L) {
            throw new EOFException();
        }
        if (l2 < 0L) {
            throw new EOFException();
        }
        if (l3 < 0L) {
            throw new EOFException();
        }
        if (l4 < 0L) {
            throw new EOFException();
        }
        return l + (l2 << 8) | l3 << 16 | l4 << 24;
    }

    public void close() throws IOException {
        this.finish();
        if (this == this.root) {
            this.stream.close();
        }
        this.stream = null;
    }
}

