/*
 * Decompiled with CFR 0.152.
 */
package biniu.ogg;

public class Buffer {
    protected static final int BUFFER_INCREMENT = 256;
    protected static final int[] mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    public int endByte = 0;
    public int endBit = 0;
    public byte[] buffer;
    private int ptr = 0;
    public int storage = 0;

    public void writeInit() {
        this.ptr = 0;
        this.buffer = new byte[256];
        this.buffer[0] = 0;
        this.storage = 256;
    }

    public void reset() {
        this.ptr = 0;
        this.buffer = new byte[256];
        this.buffer[0] = 0;
        this.endByte = 0;
        this.endBit = 0;
        this.storage = 256;
    }

    public void writeClear() {
        this.buffer = null;
        this.endByte = 0;
        this.endBit = 0;
        this.ptr = 0;
        this.storage = 0;
    }

    public int getBytes() {
        return this.endByte + (this.endBit + 7) / 8;
    }

    public void write(byte[] s) {
        int i = 0;
        while (i < s.length) {
            if (s[i] == 0) break;
            this.write(s[i], 8);
            ++i;
        }
    }

    public void writetrUnc(int bits) {
        int bytes = bits >> 3;
        this.endBit = bits -= bytes * 8;
        this.endByte = bytes;
        this.ptr = mask[bits];
    }

    public void write(int value, int bits) {
        long czas1 = System.currentTimeMillis();
        if (this.endByte + 4 >= this.storage) {
            byte[] tmp = new byte[this.storage + 256];
            System.arraycopy(this.buffer, 0, tmp, 0, this.storage);
            this.buffer = tmp;
            this.storage += 256;
        }
        value &= mask[bits];
        int n = this.ptr;
        this.buffer[n] = (byte)(this.buffer[n] | (byte)(value << this.endBit));
        if ((bits += this.endBit) >= 8) {
            this.buffer[this.ptr + 1] = (byte)(value >>> 8 - this.endBit);
            if (bits >= 16) {
                this.buffer[this.ptr + 2] = (byte)(value >>> 16 - this.endBit);
                if (bits >= 24) {
                    this.buffer[this.ptr + 3] = (byte)(value >>> 24 - this.endBit);
                    if (bits >= 32) {
                        this.buffer[this.ptr + 4] = this.endBit > 0 ? (byte)(value >>> 32 - this.endBit) : (byte)0;
                    }
                }
            }
        }
        this.endByte += bits / 8;
        this.ptr += bits / 8;
        this.endBit = bits & 7;
    }

    public void read(byte[] s, int bytes) {
        int i = 0;
        while (bytes-- != 0) {
            s[i++] = (byte)this.read(8);
        }
    }

    public void readInit(byte[] buf, int bytes) {
        this.readInit(buf, 0, bytes);
    }

    public void readInit(byte[] buf, int start, int bytes) {
        this.ptr = start;
        this.buffer = buf;
        this.endByte = 0;
        this.endBit = 0;
        this.storage = bytes;
    }

    public int look(int bits) {
        int m = mask[bits];
        if (this.endByte + 4 >= this.storage && this.endByte + ((bits += this.endBit) - 1) / 8 >= this.storage) {
            return -1;
        }
        int ret = (this.buffer[this.ptr] & 0xFF) >>> this.endBit;
        if (bits > 8) {
            ret |= (this.buffer[this.ptr + 1] & 0xFF) << 8 - this.endBit;
            if (bits > 16) {
                ret |= (this.buffer[this.ptr + 2] & 0xFF) << 16 - this.endBit;
                if (bits > 24) {
                    ret |= (this.buffer[this.ptr + 3] & 0xFF) << 24 - this.endBit;
                    if (bits > 32 && this.endBit != 0) {
                        ret |= (this.buffer[this.ptr + 4] & 0xFF) << 32 - this.endBit;
                    }
                }
            }
        }
        return m & ret;
    }

    public int look1() {
        if (this.endByte >= this.storage) {
            return -1;
        }
        return this.buffer[this.ptr] >> this.endBit & 1;
    }

    public void adv(int bits) {
        this.ptr += (bits += this.endBit) / 8;
        this.endByte += bits / 8;
        this.endBit = bits & 7;
    }

    public void adv1() {
        ++this.endBit;
        if (this.endBit > 7) {
            this.endBit = 0;
            ++this.ptr;
            ++this.endByte;
        }
    }

    public int read(int bits) {
        int ret;
        int m = mask[bits];
        bits += this.endBit;
        if (this.endByte + 4 >= this.storage) {
            ret = -1;
            if (this.endByte + (bits - 1) / 8 >= this.storage) {
                this.ptr += bits / 8;
                this.endByte += bits / 8;
                this.endBit = bits & 7;
                return ret;
            }
        }
        ret = (this.buffer[this.ptr] & 0xFF) >>> this.endBit;
        if (bits > 8) {
            ret |= (this.buffer[this.ptr + 1] & 0xFF) << 8 - this.endBit;
            if (bits > 16) {
                ret |= (this.buffer[this.ptr + 2] & 0xFF) << 16 - this.endBit;
                if (bits > 24) {
                    ret |= (this.buffer[this.ptr + 3] & 0xFF) << 24 - this.endBit;
                    if (bits > 32 && this.endBit != 0) {
                        ret |= (this.buffer[this.ptr + 4] & 0xFF) << 32 - this.endBit;
                    }
                }
            }
        }
        this.ptr += bits / 8;
        this.endByte += bits / 8;
        this.endBit = bits & 7;
        return ret &= m;
    }

    public int readB(int bits) {
        int ret;
        int m = 32 - bits;
        bits += this.endBit;
        if (this.endByte + 4 >= this.storage) {
            ret = -1;
            if (this.endByte * 8 + bits > this.storage * 8) {
                this.ptr += bits / 8;
                this.endByte += bits / 8;
                this.endBit = bits & 7;
                return ret;
            }
        }
        ret = (this.buffer[this.ptr] & 0xFF) << 24 + this.endBit;
        if (bits > 8) {
            ret |= (this.buffer[this.ptr + 1] & 0xFF) << 16 + this.endBit;
            if (bits > 16) {
                ret |= (this.buffer[this.ptr + 2] & 0xFF) << 8 + this.endBit;
                if (bits > 24) {
                    ret |= (this.buffer[this.ptr + 3] & 0xFF) << this.endBit;
                    if (bits > 32 && this.endBit != 0) {
                        ret |= (this.buffer[this.ptr + 4] & 0xFF) >> 8 - this.endBit;
                    }
                }
            }
        }
        ret = ret >>> (m >> 1) >>> (m + 1 >> 1);
        this.ptr += bits / 8;
        this.endByte += bits / 8;
        this.endBit = bits & 7;
        return ret;
    }

    public int read1() {
        if (this.endByte >= this.storage) {
            int ret = -1;
            ++this.endBit;
            if (this.endBit > 7) {
                this.endBit = 0;
                ++this.ptr;
                ++this.endByte;
            }
            return ret;
        }
        int ret = this.buffer[this.ptr] >> this.endBit & 1;
        ++this.endBit;
        if (this.endBit > 7) {
            this.endBit = 0;
            ++this.ptr;
            ++this.endByte;
        }
        return ret;
    }

    public int getBits() {
        return this.endByte * 8 + this.endBit;
    }
}

