/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.ogg.Packet;
import biniu.vorbis.BitrateManagerState;
import biniu.vorbis.Block;
import biniu.vorbis.BlockInternal;
import biniu.vorbis.CodeBook;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.Comment;
import biniu.vorbis.DrftLookup;
import biniu.vorbis.EnvelopeLookUp;
import biniu.vorbis.FuncFloor;
import biniu.vorbis.FuncResidue;
import biniu.vorbis.Info;
import biniu.vorbis.InfoPsyGlobal;
import biniu.vorbis.LookResidue;
import biniu.vorbis.Lpc;
import biniu.vorbis.Mdct;
import biniu.vorbis.PrivateState;
import biniu.vorbis.PsyLook;

public class DspState {
    static final float M_PI = (float)Math.PI;
    static final int VI_TRANSFORMB = 1;
    static final int VI_WINDOWB = 1;
    int analysisp;
    public Info vi;
    private CodecSetupInfo ci;
    private InfoPsyGlobal gi;
    int modebits;
    float[][] pcm;
    int pcm_storage;
    public int pcm_current;
    int pcm_returned;
    float[] multipliers;
    int preextrapolate;
    int eofflag;
    public int lW;
    public int W;
    int nW;
    int centerW;
    long granulepos;
    long sequence;
    long glue_bits;
    long time_bits;
    long floor_bits;
    long res_bits;
    PrivateState backEndState;
    float[][][][][] window;
    Object[][] transform = new Object[2][];
    CodeBook[] fullbooks;
    Object[] mode;
    byte[] header;
    byte[] header1;
    byte[] header2;

    public DspState() {
        this.window = new float[2][][][][];
        this.window[0] = new float[2][][][];
        this.window[0][0] = new float[2][][];
        this.window[0][1] = new float[2][][];
        this.window[0][0][0] = new float[2][];
        this.window[0][0][1] = new float[2][];
        this.window[0][1][0] = new float[2][];
        this.window[0][1][1] = new float[2][];
        this.window[1] = new float[2][][][];
        this.window[1][0] = new float[2][][];
        this.window[1][1] = new float[2][][];
        this.window[1][0][0] = new float[2][];
        this.window[1][0][1] = new float[2][];
        this.window[1][1][0] = new float[2][];
        this.window[1][1][1] = new float[2][];
    }

    private int ilog2(int v) {
        int ret = 0;
        while (v > 1) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    private PrivateState getPrivateState() {
        return this.backEndState;
    }

    private static float[] window(int type, int window, int left, int right) {
        float[] ret = new float[window];
        switch (type) {
            case 0: {
                int leftbegin = window / 4 - left / 2;
                int rightbegin = window - window / 4 - right / 2;
                int i = 0;
                while (i < left) {
                    float x = (float)(((double)i + 0.5) / (double)left * 3.1415927410125732 / 2.0);
                    x = (float)Math.sin(x);
                    x *= x;
                    x = (float)((double)x * 1.5707963705062866);
                    ret[i + leftbegin] = x = (float)Math.sin(x);
                    ++i;
                }
                int i2 = leftbegin + left;
                while (i2 < rightbegin) {
                    ret[i2] = 1.0f;
                    ++i2;
                }
                int i3 = 0;
                while (i3 < right) {
                    float x = (float)(((double)(right - i3) - 0.5) / (double)right * 3.1415927410125732 / 2.0);
                    x = (float)Math.sin(x);
                    x *= x;
                    x = (float)((double)x * 1.5707963705062866);
                    ret[i3 + rightbegin] = x = (float)Math.sin(x);
                    ++i3;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    private int sharedInit(Info vi, int encp) {
        int i;
        this.vi = vi;
        this.ci = vi.getCodecSetup();
        this.gi = this.ci.psyGlobParam;
        this.backEndState = new PrivateState();
        if (this.ci == null) {
            return 1;
        }
        int hs = this.ci.halfrateFlag;
        this.backEndState.modeBits = this.ilog2(this.ci.modes);
        this.backEndState.transform[0] = new Mdct[1];
        this.backEndState.transform[1] = new Mdct[1];
        this.backEndState.transform[0][0] = new Mdct();
        this.backEndState.transform[1][0] = new Mdct();
        this.backEndState.transform[0][0].init(this.ci.blocksizes[0] >> hs);
        this.backEndState.transform[1][0].init(this.ci.blocksizes[1] >> hs);
        this.backEndState.window[0] = this.ilog2(this.ci.blocksizes[0]) - 6;
        this.backEndState.window[1] = this.ilog2(this.ci.blocksizes[1]) - 6;
        if (encp != 0) {
            this.drftInit(this.backEndState.fftLook[0], this.ci.blocksizes[0]);
            this.drftInit(this.backEndState.fftLook[1], this.ci.blocksizes[1]);
            if (this.ci.fullBooks == null) {
                this.ci.fullBooks = new CodeBook[this.ci.books];
                i = 0;
                while (i < this.ci.books) {
                    this.ci.fullBooks[i] = new CodeBook();
                    this.ci.fullBooks[i].bookInitEncode(this.ci.bookParam[i]);
                    ++i;
                }
            }
            this.backEndState.psy = new PsyLook[this.ci.psys];
            i = 0;
            while (i < this.ci.psys) {
                this.backEndState.psy[i] = new PsyLook();
                this.backEndState.psy[i].psyInit(this.ci.psyParam[i], this.ci.psyGlobParam, this.ci.blocksizes[this.ci.psyParam[i].blockflag] / 2, vi.rate);
                ++i;
            }
            this.analysisp = 1;
        } else if (this.ci.fullBooks != null) {
            i = 0;
            while (i < this.ci.books) {
                this.ci.bookParam[i] = null;
                ++i;
            }
        }
        this.pcm_storage = this.ci.blocksizes[1];
        this.pcm = new float[vi.channels][];
        i = 0;
        while (i < vi.channels) {
            this.pcm[i] = new float[this.pcm_storage];
            ++i;
        }
        this.lW = 0;
        this.W = 0;
        this.pcm_current = this.centerW = this.ci.blocksizes[1] / 2;
        this.backEndState.flr = new Object[this.ci.floors];
        this.backEndState.residue = new LookResidue[this.ci.residues];
        i = 0;
        while (i < this.ci.floors) {
            this.backEndState.flr[i] = FuncFloor.floor_P[this.ci.floorType[i]].look(this, this.ci.floorParam[i]);
            ++i;
        }
        i = 0;
        while (i < this.ci.residues) {
            this.backEndState.residue[i] = FuncResidue.residue_P[this.ci.residueType[i]].look(this, this.ci.residueParam[i]);
            ++i;
        }
        return 0;
    }

    private void drftInit(DrftLookup l, int n) {
        l.n = n;
        l.trigcache = new float[3 * n];
        l.splitcache = new int[32];
        if (n == 1) {
            return;
        }
        l.drfti1(n, l.trigcache, n, l.splitcache);
    }

    public int analysisInit(Info vi) {
        if (this.sharedInit(vi, 1) != 0) {
            return 1;
        }
        this.backEndState.psyGlobLook = vi.getLookPsyGlobal();
        this.backEndState.enveLook = new EnvelopeLookUp();
        this.backEndState.enveLook.envelopeInit(vi);
        this.backEndState.bms.vorbis_bitrate_init(vi);
        return 0;
    }

    public void clear() {
    }

    public int analysisWrote(int vals) {
        if (vals <= 0) {
            int order = 32;
            float[] lpc = new float[order];
            if (this.preextrapolate == 0) {
                this.preExtrapolateHelper();
            }
            this.analysisBuffer(this.ci.blocksizes[1] * 3);
            this.eofflag = this.pcm_current;
            this.pcm_current += this.ci.blocksizes[1] * 3;
            int i = 0;
            while (i < this.vi.channels) {
                if (this.eofflag > order * 2) {
                    int n = this.eofflag;
                    if (n > this.ci.blocksizes[1]) {
                        n = this.ci.blocksizes[1];
                    }
                    Lpc.lpcFromData(this.pcm[i], this.eofflag - n, lpc, n, order);
                    Lpc.lpcPredict(lpc, this.pcm[i], this.eofflag - order, order, this.pcm[i], this.eofflag, this.pcm_current - this.eofflag);
                }
                ++i;
            }
        } else {
            if (this.pcm_current + vals > this.pcm_storage) {
                return -131;
            }
            this.pcm_current += vals;
            if (this.preextrapolate == 0 && this.pcm_current - this.centerW > this.ci.blocksizes[1]) {
                this.preExtrapolateHelper();
            }
        }
        return 0;
    }

    private void preExtrapolateHelper() {
        int order = 32;
        float[] lpc = new float[order];
        float[] work = new float[this.pcm_current];
        this.preextrapolate = 1;
        if (this.pcm_current - this.centerW > order * 2) {
            int i = 0;
            while (i < this.vi.channels) {
                Lpc.lpcFromDataZ(this.pcm[i], lpc, this.pcm_current - this.centerW, order, this.pcm_current - 1);
                Lpc.lpcPredictZ(lpc, this.pcm[i], this.centerW + order - 1, order, this.pcm[i], this.centerW - 1, this.centerW);
                ++i;
            }
        }
    }

    public float[][] analysisBuffer(int vals) {
        if (this.backEndState.header != null) {
            this.backEndState.header = null;
        }
        if (this.backEndState.header1 != null) {
            this.backEndState.header1 = null;
        }
        if (this.backEndState.header2 != null) {
            this.backEndState.header2 = null;
        }
        if (this.pcm_current + vals >= this.pcm_storage) {
            this.pcm_storage = this.pcm_current + vals * 2;
            float[][] temp = new float[this.pcm.length][];
            int i = 0;
            while (i < this.vi.channels) {
                if (this.pcm[i] != null) {
                    temp[i] = new float[this.pcm[i].length];
                    System.arraycopy(this.pcm[i], 0, temp[i], 0, temp[i].length);
                    this.pcm[i] = new float[this.pcm_storage];
                    System.arraycopy(temp[i], 0, this.pcm[i], 0, temp[i].length);
                } else {
                    this.pcm[i] = new float[this.pcm_storage];
                }
                ++i;
            }
        }
        return this.pcm;
    }

    public float ampMaxDecay(float amp) {
        int n = this.ci.blocksizes[this.W] / 2;
        float secs = (float)n / (float)this.vi.rate;
        if ((amp += secs * this.gi.ampmax_att_per_sec) < -9999.0f) {
            amp = -9999.0f;
        }
        return amp;
    }

    public int envelopeMark() {
        EnvelopeLookUp ve = this.backEndState.enveLook;
        int centerW = this.centerW;
        int beginW = centerW - this.ci.blocksizes[this.W] / 4;
        int endW = centerW + this.ci.blocksizes[this.W] / 4;
        if (this.W != 0) {
            beginW -= this.ci.blocksizes[this.lW] / 4;
            endW += this.ci.blocksizes[this.nW] / 4;
        } else {
            beginW -= this.ci.blocksizes[0] / 4;
            endW += this.ci.blocksizes[0] / 4;
        }
        if (ve.curmark >= beginW && ve.curmark < endW) {
            return 1;
        }
        int first = beginW / ve.searchstep;
        int last = endW / ve.searchstep;
        int i = first;
        while (i < last) {
            if (ve.mark[i] != 0) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int envelopeSearch() {
        EnvelopeLookUp ve = this.backEndState.enveLook;
        int first = ve.current / ve.searchstep;
        int last = this.pcm_current / ve.searchstep - 4;
        if (first < 0) {
            first = 0;
        }
        if (last + 4 + 2 > ve.storage) {
            ve.storage = last + 4 + 2;
            int[] temp = new int[ve.mark.length];
            System.arraycopy(ve.mark, 0, temp, 0, temp.length);
            ve.mark = new int[ve.storage];
            System.arraycopy(temp, 0, ve.mark, 0, temp.length);
        }
        int j = first;
        while (j < last) {
            int ret = 0;
            ++ve.stretch;
            if (ve.stretch > 24) {
                ve.stretch = 24;
            }
            int i = 0;
            while (i < ve.ch) {
                float[] pcm = new float[this.pcm[i].length - ve.searchstep * j];
                System.arraycopy(this.pcm[i], ve.searchstep * j, pcm, 0, pcm.length);
                ret |= ve.amp(this.gi, pcm, ve.band, ve.filter, i * 7, j);
                ++i;
            }
            ve.mark[j + 2] = 0;
            if (ret & true) {
                ve.mark[j] = 1;
                ve.mark[j + 1] = 1;
            }
            if ((ret & 2) != 0) {
                ve.mark[j] = 1;
                if (j > 0) {
                    ve.mark[j - 1] = 1;
                }
            }
            if ((ret & 4) != 0) {
                ve.stretch = -1;
            }
            ++j;
        }
        ve.current = last * ve.searchstep;
        long centerW = this.centerW;
        long testW = centerW + (long)(this.ci.blocksizes[this.W] / 4) + (long)(this.ci.blocksizes[1] / 2) + (long)(this.ci.blocksizes[0] / 4);
        j = ve.cursor;
        while (j < ve.current - ve.searchstep) {
            if ((long)j >= testW) {
                return 1;
            }
            ve.cursor = j;
            if (ve.mark[j / ve.searchstep] != 0 && (long)j > centerW) {
                ve.curmark = j;
                if ((long)j >= testW) {
                    return 1;
                }
                return 0;
            }
            j += ve.searchstep;
        }
        return -1;
    }

    public int analysisHeaderOut(Comment vc, Packet op, Packet op_comm, Packet op_code) {
        int ret = -130;
        Buffer opb = new Buffer();
        if (this.backEndState == null) {
            ret = -129;
            opb.writeClear();
            op = new Packet();
            op_comm = new Packet();
            op_code = new Packet();
            this.backEndState.header = null;
            this.backEndState.header1 = null;
            this.backEndState.header2 = null;
            return ret;
        }
        opb.writeInit();
        if (this.vi.packInfo(opb)) {
            if (this.backEndState.header != null) {
                this.backEndState.header = null;
            }
            this.backEndState.header = new byte[opb.getBytes()];
            System.arraycopy(opb.buffer, 0, this.backEndState.header, 0, this.backEndState.header.length);
            op.packetByte = this.backEndState.header;
            op.bytes = opb.getBytes();
            op.b_o_s = 1;
            op.e_o_s = 0;
            op.granulePos = 0L;
            opb.reset();
            if (vc.packComment(opb)) {
                if (this.backEndState.header1 != null) {
                    this.backEndState.header1 = null;
                }
                this.backEndState.header1 = new byte[opb.getBytes()];
                System.arraycopy(opb.buffer, 0, this.backEndState.header1, 0, this.backEndState.header1.length);
                op_comm.packetByte = this.backEndState.header1;
                op_comm.bytes = opb.getBytes();
                op_comm.b_o_s = 0;
                op_comm.e_o_s = 0;
                op_comm.granulePos = 0L;
                opb.reset();
                if (this.vi.packBooks(opb)) {
                    if (this.backEndState.header2 != null) {
                        this.backEndState.header2 = null;
                    }
                    this.backEndState.header2 = new byte[opb.getBytes()];
                    System.arraycopy(opb.buffer, 0, this.backEndState.header2, 0, this.backEndState.header2.length);
                    op_code.packetByte = this.backEndState.header2;
                    op_code.bytes = opb.getBytes();
                    op_code.b_o_s = 0;
                    op_code.e_o_s = 0;
                    op_code.granulePos = 0L;
                    opb.writeClear();
                    return 0;
                }
            }
        }
        opb.writeClear();
        op = new Packet();
        op_comm = new Packet();
        op_code = new Packet();
        this.backEndState.header = null;
        this.backEndState.header1 = null;
        this.backEndState.header2 = null;
        return ret;
    }

    public boolean bitrateFlushPacket(Packet op) {
        BitrateManagerState bm = this.backEndState.bms;
        Block vb = bm.vb;
        int choice = 7;
        if (vb == null) {
            return false;
        }
        if (op != null) {
            BlockInternal vbi = vb.blockInternal;
            if (vb.bitrateManaged()) {
                choice = bm.choice;
            }
            op.packetByte = vbi.packetblob[choice].buffer;
            op.bytes = vbi.packetblob[choice].getBytes();
            op.b_o_s = 0;
            op.e_o_s = vb.eofFlag;
            op.granulePos = vb.granulePos;
            op.packetNo = vb.sequence;
        }
        bm.vb = null;
        return true;
    }
}

