/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.EnvelopeBand;
import biniu.vorbis.EnvelopeFilterState;
import biniu.vorbis.Info;
import biniu.vorbis.InfoPsyGlobal;
import biniu.vorbis.Mapping0;
import biniu.vorbis.Mdct;

public class EnvelopeLookUp {
    int ch;
    int winlength;
    int searchstep;
    float minenergy;
    Mdct mdct;
    float[] mdct_win;
    EnvelopeBand[] band = new EnvelopeBand[7];
    EnvelopeFilterState[] filter;
    int stretch;
    int[] mark;
    int storage;
    int current;
    int curmark;
    int cursor;

    public EnvelopeLookUp() {
        this.mdct = new Mdct();
        int i = 0;
        while (i < this.band.length) {
            this.band[i] = new EnvelopeBand();
            ++i;
        }
    }

    public void envelopeInit(Info vi) {
        CodecSetupInfo ci = vi.getCodecSetup();
        InfoPsyGlobal gi = ci.psyGlobParam;
        int ch = vi.channels;
        this.winlength = 128;
        int n = 128;
        this.searchstep = 64;
        this.minenergy = gi.preecho_minenergy;
        this.ch = ch;
        this.storage = 128;
        this.cursor = ci.blocksizes[1] / 2;
        this.mdct_win = new float[n];
        this.mdct.init(n);
        int i = 0;
        while (i < n) {
            this.mdct_win[i] = (float)Math.sin((double)i / ((double)n - 1.0) * 3.1415927410125732);
            int n2 = i;
            this.mdct_win[n2] = this.mdct_win[n2] * this.mdct_win[i];
            ++i;
        }
        this.band[0].begin = 2;
        this.band[0].end = 4;
        this.band[1].begin = 4;
        this.band[1].end = 5;
        this.band[2].begin = 6;
        this.band[2].end = 6;
        this.band[3].begin = 9;
        this.band[3].end = 8;
        this.band[4].begin = 13;
        this.band[4].end = 8;
        this.band[5].begin = 17;
        this.band[5].end = 8;
        this.band[6].begin = 22;
        this.band[6].end = 8;
        int j = 0;
        while (j < 7) {
            n = this.band[j].end;
            this.band[j].window = new float[n];
            i = 0;
            while (i < n) {
                this.band[j].window[i] = (float)Math.sin(((double)i + 0.5) / (double)n * 3.1415927410125732);
                this.band[j].total += this.band[j].window[i];
                ++i;
            }
            this.band[j].total = 1.0f / this.band[j].total;
            ++j;
        }
        this.filter = new EnvelopeFilterState[7 * ch];
        i = 0;
        while (i < 7 * ch) {
            this.filter[i] = new EnvelopeFilterState();
            ++i;
        }
        this.mark = new int[this.storage];
    }

    public void envelopeClear() {
        this.mdct.clear();
        int i = 0;
        while (i < 7) {
            this.band[i].window = null;
            ++i;
        }
    }

    public void envelopeShift(int shift) {
        int smallsize = this.current / this.searchstep + 2;
        int smallshift = shift / this.searchstep;
        System.arraycopy(this.mark, smallshift, this.mark, 0, smallsize - smallshift);
        this.current -= shift;
        if (this.curmark >= 0) {
            this.curmark -= shift;
        }
        this.cursor -= shift;
    }

    public int amp(InfoPsyGlobal gi, float[] data, EnvelopeBand[] bands, EnvelopeFilterState[] filters, int pfilters, int pos) {
        float decay;
        int n = this.winlength;
        int ret = 0;
        float minV = this.minenergy;
        float[] vec = new float[n];
        int stretch = Math.max(2, this.stretch / 2);
        float penalty = gi.stretch_penalty - (float)(this.stretch / 2 - 2);
        if (penalty < 0.0f) {
            penalty = 0.0f;
        }
        if (penalty > gi.stretch_penalty) {
            penalty = gi.stretch_penalty;
        }
        int i = 0;
        while (i < n) {
            vec[i] = data[i] * this.mdct_win[i];
            ++i;
        }
        this.mdct.mdct_forward(vec, vec);
        float temp = vec[0] * vec[0] + 0.7f * vec[1] * vec[1] + 0.2f * vec[2] * vec[2];
        int ptr = filters[pfilters].nearptr;
        if (ptr == 0) {
            decay = filters[pfilters].nearDC_acc = filters[pfilters].nearDC_partialacc + temp;
            filters[pfilters].nearDC_partialacc = temp;
        } else {
            decay = filters[pfilters].nearDC_acc += temp;
            filters[pfilters].nearDC_partialacc += temp;
        }
        filters[pfilters].nearDC_acc -= filters[pfilters].nearDC[ptr];
        filters[pfilters].nearDC[ptr] = temp;
        decay = (float)((double)decay * 0.0625);
        ++filters[pfilters].nearptr;
        if (filters[pfilters].nearptr >= 15) {
            filters[pfilters].nearptr = 0;
        }
        decay = Mapping0.todB(decay) * 0.5f - 15.0f;
        i = 0;
        while (i < n / 2) {
            float val = vec[i] * vec[i] + vec[i + 1] * vec[i + 1];
            if ((val = Mapping0.todB(val) * 0.5f) < decay) {
                val = decay;
            }
            if (val < minV) {
                val = minV;
            }
            vec[i >> 1] = val;
            decay = (float)((double)decay - 8.0);
            i += 2;
        }
        int j = 0;
        while (j < 7) {
            float acc = 0.0f;
            float valmax = 0.0f;
            float valmin = 0.0f;
            i = 0;
            while (i < bands[j].end) {
                acc += vec[i + bands[j].begin] * bands[j].window[i];
                ++i;
            }
            acc *= bands[j].total;
            int thisx = filters[j + pfilters].ampptr;
            float premax = -99999.0f;
            float premin = 99999.0f;
            int p = thisx;
            if (--p < 0) {
                p += 17;
            }
            float postmax = Math.max(acc, filters[j + pfilters].ampbuf[p]);
            float postmin = Math.min(acc, filters[j + pfilters].ampbuf[p]);
            i = 0;
            while (i < stretch) {
                if (--p < 0) {
                    p += 17;
                }
                premax = Math.max(premax, filters[j + pfilters].ampbuf[p]);
                premin = Math.min(premin, filters[j + pfilters].ampbuf[p]);
                ++i;
            }
            valmin = postmin - premin;
            valmax = postmax - premax;
            filters[j + pfilters].ampbuf[thisx] = acc;
            ++filters[j + pfilters].ampptr;
            if (filters[j + pfilters].ampptr >= 17) {
                filters[j + pfilters].ampptr = 0;
            }
            if (valmax > gi.preecho_thresh[j] + penalty) {
                ret |= 1;
                ret |= 4;
            }
            if (valmin < gi.postecho_thresh[j] - penalty) {
                ret |= 2;
            }
            ++j;
        }
        return ret;
    }
}

