/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.vorbis.BitrateManagerInfo;
import biniu.vorbis.CodeBook;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.FuncFloor;
import biniu.vorbis.FuncMapping;
import biniu.vorbis.FuncResidue;
import biniu.vorbis.FuncTime;
import biniu.vorbis.HighlevelEncodeSetup;
import biniu.vorbis.InfoMode;
import biniu.vorbis.InfoPsyGlobal;
import biniu.vorbis.LookPsyGlobal;
import biniu.vorbis.LookResidue;
import biniu.vorbis.PsyInfo;
import biniu.vorbis.StaticCodeBook;

public class Info {
    private static final int OV_EBADPACKET = -136;
    private static final int OV_ENOTAUDIO = -135;
    private static byte[] _vorbis = "vorbis".getBytes();
    private static final int VI_TIMEB = 1;
    private static final int VI_FLOORB = 2;
    private static final int VI_RESB = 3;
    private static final int VI_MAPB = 1;
    private static final int VI_WINDOWB = 1;
    public int version;
    public int channels;
    public int rate;
    int bitrate_upper;
    int bitrate_nominal;
    int bitrate_lower;
    int bitrate_window;
    private CodecSetupInfo codecSetup;
    int[] blocksizes = new int[2];
    int modes;
    int maps;
    int times;
    int floors;
    int residues;
    int books;
    int psys;
    InfoMode[] mode_param = null;
    int[] map_type = null;
    Object[] map_param = null;
    int[] time_type = null;
    Object[] time_param = null;
    int[] floor_type = null;
    Object[] floor_param = null;
    int[] residue_type = null;
    LookResidue[] residue_param = null;
    StaticCodeBook[] book_param = null;
    CodeBook[] fullbooks;
    InfoPsyGlobal psy_g_param;
    BitrateManagerInfo bi;
    HighlevelEncodeSetup hi;
    int halfrate_flag;
    PsyInfo[] psy_param = new PsyInfo[64];
    int envelopesa;
    float preecho_thresh;
    float preecho_clamp;

    public void init() {
        this.rate = 0;
        this.codecSetup = new CodecSetupInfo();
    }

    public LookPsyGlobal getLookPsyGlobal() {
        InfoPsyGlobal gi = this.codecSetup.psyGlobParam;
        LookPsyGlobal look = new LookPsyGlobal();
        look.channels = this.channels;
        look.ampmax = -9999.0f;
        look.gi = gi;
        return look;
    }

    public void clear() {
        int i = 0;
        while (i < this.modes) {
            this.mode_param[i] = null;
            ++i;
        }
        this.mode_param = null;
        int i2 = 0;
        while (i2 < this.maps) {
            FuncMapping.mapping_P[this.map_type[i2]].clear(this.map_param[i2]);
            ++i2;
        }
        this.map_param = null;
        int i3 = 0;
        while (i3 < this.times) {
            FuncTime.time_P[this.time_type[i3]].free_info(this.time_param[i3]);
            ++i3;
        }
        this.time_param = null;
        int i4 = 0;
        while (i4 < this.floors) {
            FuncFloor.floor_P[this.floor_type[i4]].clear(this.floor_param[i4]);
            ++i4;
        }
        this.floor_param = null;
        int i5 = 0;
        while (i5 < this.residues) {
            FuncResidue.residue_P[this.residue_type[i5]].clear(this.residue_param[i5]);
            ++i5;
        }
        this.residue_param = null;
        int i6 = 0;
        while (i6 < this.books) {
            if (this.book_param[i6] != null) {
                this.book_param[i6].clear();
                this.book_param[i6] = null;
            }
            ++i6;
        }
        this.book_param = null;
        int i7 = 0;
        while (i7 < this.psys) {
            this.psy_param[i7].free();
            ++i7;
        }
    }

    int unpack_info(Buffer opb) {
        this.version = opb.read(32);
        if (this.version != 0) {
            return -1;
        }
        this.channels = opb.read(8);
        this.rate = opb.read(32);
        this.bitrate_upper = opb.read(32);
        this.bitrate_nominal = opb.read(32);
        this.bitrate_lower = opb.read(32);
        this.codecSetup.blocksizes[0] = 1 << opb.read(4);
        this.codecSetup.blocksizes[1] = 1 << opb.read(4);
        if (this.rate < 1 || this.channels < 1 || this.codecSetup.blocksizes[0] < 8 || this.codecSetup.blocksizes[1] < this.blocksizes[0] || opb.read(1) != 1) {
            this.clear();
            return -1;
        }
        return 0;
    }

    public boolean packBooks(Buffer opb) {
        if (this.codecSetup == null) {
            return false;
        }
        opb.write(5, 8);
        opb.write(_vorbis);
        opb.write(this.codecSetup.books - 1, 8);
        int i = 0;
        while (i < this.codecSetup.books) {
            if (this.codecSetup.bookParam[i].pack(opb) != 0) {
                return false;
            }
            ++i;
        }
        opb.write(0, 6);
        opb.write(0, 16);
        opb.write(this.codecSetup.floors - 1, 6);
        int i2 = 0;
        while (i2 < this.codecSetup.floors) {
            opb.write(this.codecSetup.floorType[i2], 16);
            if (this.codecSetup.floorType[i2] == 0) {
                return false;
            }
            FuncFloor.floor_P[this.codecSetup.floorType[i2]].pack(this.codecSetup.floorParam[i2], opb);
            ++i2;
        }
        opb.write(this.codecSetup.residues - 1, 6);
        int i3 = 0;
        while (i3 < this.codecSetup.residues) {
            opb.write(this.codecSetup.residueType[i3], 16);
            FuncResidue.residue_P[this.codecSetup.residueType[i3]].pack(this.codecSetup.residueParam[i3], opb);
            ++i3;
        }
        opb.write(this.codecSetup.maps - 1, 6);
        int i4 = 0;
        while (i4 < this.codecSetup.maps) {
            opb.write(this.codecSetup.mapType[i4], 16);
            FuncMapping.mapping_P[this.codecSetup.mapType[i4]].pack(this, this.codecSetup.mapParam[i4], opb);
            ++i4;
        }
        opb.write(this.codecSetup.modes - 1, 6);
        int i5 = 0;
        while (i5 < this.codecSetup.modes) {
            opb.write(this.codecSetup.modeParam[i5].blockflag, 1);
            opb.write(this.codecSetup.modeParam[i5].windowtype, 16);
            opb.write(this.codecSetup.modeParam[i5].transformtype, 16);
            opb.write(this.codecSetup.modeParam[i5].mapping, 8);
            ++i5;
        }
        opb.write(1, 1);
        return true;
    }

    public boolean packInfo(Buffer opb) {
        if (this.codecSetup == null) {
            return false;
        }
        opb.write(1, 8);
        opb.write(_vorbis);
        opb.write(0, 32);
        opb.write(this.channels, 8);
        opb.write(this.rate, 32);
        opb.write(this.bitrate_upper, 32);
        opb.write(this.bitrate_nominal, 32);
        opb.write(this.bitrate_lower, 32);
        opb.write(Info.ilog2(this.codecSetup.blocksizes[0]), 4);
        opb.write(Info.ilog2(this.codecSetup.blocksizes[1]), 4);
        opb.write(1, 1);
        return true;
    }

    public CodecSetupInfo getCodecSetup() {
        return this.codecSetup;
    }

    private static int ilog2(int v) {
        int ret = 0;
        while (v > 1) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    public String toString() {
        return "version:" + new Integer(this.version) + ", channels:" + new Integer(this.channels) + ", rate:" + new Integer(this.rate) + ", bitrate:" + new Integer(this.bitrate_upper) + "," + new Integer(this.bitrate_nominal) + "," + new Integer(this.bitrate_lower);
    }
}

