/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.vorbis.Block;
import biniu.vorbis.BlockInternal;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.DspState;
import biniu.vorbis.Floor1;
import biniu.vorbis.FuncFloor;
import biniu.vorbis.FuncMapping;
import biniu.vorbis.FuncResidue;
import biniu.vorbis.FuncTime;
import biniu.vorbis.Info;
import biniu.vorbis.InfoMapping0;
import biniu.vorbis.InfoMode;
import biniu.vorbis.LookMapping0;
import biniu.vorbis.LookResidue;
import biniu.vorbis.Mdct;
import biniu.vorbis.PsyLook;
import biniu.vorbis.Window;

public class Mapping0
extends FuncMapping {
    static int seq = 0;
    private Floor1 floor1 = new Floor1();
    private Window window = new Window();
    float[][] pcmbundle = null;
    int[] zerobundle = null;
    int[] nonzero = null;
    Object[] floormemo = null;

    public void clear(Object imap) {
        imap = null;
    }

    public Object look(DspState vd, InfoMode vm, Object m) {
        Info vi = vd.vi;
        LookMapping0 look = new LookMapping0();
        InfoMapping0 info = look.map = (InfoMapping0)m;
        look.mode = vm;
        look.time_look = new Object[info.submaps];
        look.floor_look = new Object[info.submaps];
        look.residue_look = new LookResidue[info.submaps];
        look.time_func = new FuncTime[info.submaps];
        look.floor_func = new FuncFloor[info.submaps];
        look.residue_func = new FuncResidue[info.submaps];
        int i = 0;
        while (i < info.submaps) {
            int timenum = info.timesubmap[i];
            int floornum = info.floorsubmap[i];
            int resnum = info.residuesubmap[i];
            look.time_func[i] = FuncTime.time_P[vi.time_type[timenum]];
            look.time_look[i] = look.time_func[i].look(vd, vm, vi.time_param[timenum]);
            look.floor_func[i] = FuncFloor.floor_P[vi.floor_type[floornum]];
            look.floor_look[i] = look.floor_func[i].look(vd, vm, vi.floor_param[floornum]);
            look.residue_func[i] = FuncResidue.residue_P[vi.residue_type[resnum]];
            look.residue_look[i] = look.residue_func[i].look(vd, vm, vi.residue_param[resnum]);
            ++i;
        }
        if (vi.psys == 0 || vd.analysisp != 0) {
            // empty if block
        }
        look.ch = vi.channels;
        return look;
    }

    public void pack(Info vi, Object imap, Buffer opb) {
        int i;
        InfoMapping0 info = (InfoMapping0)imap;
        if (info.submaps > 1) {
            opb.write(1, 1);
            opb.write(info.submaps - 1, 4);
        } else {
            opb.write(0, 1);
        }
        if (info.coupling_steps > 0) {
            opb.write(1, 1);
            opb.write(info.coupling_steps - 1, 8);
            i = 0;
            while (i < info.coupling_steps) {
                opb.write(info.coupling_mag[i], this.ilog2(vi.channels));
                opb.write(info.coupling_ang[i], this.ilog2(vi.channels));
                ++i;
            }
        } else {
            opb.write(0, 1);
        }
        opb.write(0, 2);
        if (info.submaps > 1) {
            i = 0;
            while (i < vi.channels) {
                opb.write(info.chmuxlist[i], 4);
                ++i;
            }
        }
        i = 0;
        while (i < info.submaps) {
            opb.write(info.timesubmap[i], 8);
            opb.write(info.floorsubmap[i], 8);
            opb.write(info.residuesubmap[i], 8);
            ++i;
        }
    }

    public Object unpack(Info vi, Buffer opb) {
        int i;
        InfoMapping0 info = new InfoMapping0();
        info.submaps = opb.read(1) != 0 ? opb.read(4) + 1 : 1;
        if (opb.read(1) != 0) {
            info.coupling_steps = opb.read(8) + 1;
            i = 0;
            while (i < info.coupling_steps) {
                int testM = info.coupling_mag[i] = opb.read(this.ilog2(vi.channels));
                int testA = info.coupling_ang[i] = opb.read(this.ilog2(vi.channels));
                if (testM < 0 || testA < 0 || testM == testA || testM >= vi.channels || testA >= vi.channels) {
                    info.free();
                    return null;
                }
                ++i;
            }
        }
        if (opb.read(2) > 0) {
            info.free();
            return null;
        }
        if (info.submaps > 1) {
            i = 0;
            while (i < vi.channels) {
                info.chmuxlist[i] = opb.read(4);
                if (info.chmuxlist[i] >= info.submaps) {
                    info.free();
                    return null;
                }
                ++i;
            }
        }
        i = 0;
        while (i < info.submaps) {
            info.timesubmap[i] = opb.read(8);
            if (info.timesubmap[i] >= vi.times) {
                info.free();
                return null;
            }
            info.floorsubmap[i] = opb.read(8);
            if (info.floorsubmap[i] >= vi.floors) {
                info.free();
                return null;
            }
            info.residuesubmap[i] = opb.read(8);
            if (info.residuesubmap[i] >= vi.residues) {
                info.free();
                return null;
            }
            ++i;
        }
        return info;
    }

    synchronized int inverse(Block vb, Object l) {
        DspState vd = vb.dspState;
        Info vi = vd.vi;
        LookMapping0 look = (LookMapping0)l;
        InfoMapping0 info = look.map;
        InfoMode mode = look.mode;
        int n = vb.pcmEnd = vi.blocksizes[vb.W];
        float[] window = vd.window[vb.W][vb.lW][vb.nW][mode.windowtype];
        if (this.pcmbundle == null || this.pcmbundle.length < vi.channels) {
            this.pcmbundle = new float[vi.channels][];
            this.nonzero = new int[vi.channels];
            this.zerobundle = new int[vi.channels];
            this.floormemo = new Object[vi.channels];
        }
        int i = 0;
        while (i < vi.channels) {
            float[] pcm = vb.pcm[i];
            int submap = info.chmuxlist[i];
            this.floormemo[i] = look.floor_func[submap].inverse1(vb, look.floor_look[submap], this.floormemo[i]);
            this.nonzero[i] = this.floormemo[i] != null ? 1 : 0;
            int j = 0;
            while (j < n / 2) {
                pcm[j] = 0.0f;
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < info.coupling_steps) {
            if (this.nonzero[info.coupling_mag[i2]] != 0 || this.nonzero[info.coupling_ang[i2]] != 0) {
                this.nonzero[info.coupling_mag[i2]] = 1;
                this.nonzero[info.coupling_ang[i2]] = 1;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < info.submaps) {
            int ch_in_bundle = 0;
            int j = 0;
            while (j < vi.channels) {
                if (info.chmuxlist[j] == i3) {
                    this.zerobundle[ch_in_bundle] = this.nonzero[j] != 0 ? 1 : 0;
                    this.pcmbundle[ch_in_bundle++] = vb.pcm[j];
                }
                ++j;
            }
            look.residue_func[i3].inverse(vb, look.residue_look[i3], this.pcmbundle, this.zerobundle, ch_in_bundle);
            ++i3;
        }
        int i4 = info.coupling_steps - 1;
        while (i4 >= 0) {
            float[] pcmM = vb.pcm[info.coupling_mag[i4]];
            float[] pcmA = vb.pcm[info.coupling_ang[i4]];
            int j = 0;
            while (j < n / 2) {
                float mag = pcmM[j];
                float ang = pcmA[j];
                if (mag > 0.0f) {
                    if (ang > 0.0f) {
                        pcmM[j] = mag;
                        pcmA[j] = mag - ang;
                    } else {
                        pcmA[j] = mag;
                        pcmM[j] = mag + ang;
                    }
                } else if (ang > 0.0f) {
                    pcmM[j] = mag;
                    pcmA[j] = mag + ang;
                } else {
                    pcmA[j] = mag;
                    pcmM[j] = mag - ang;
                }
                ++j;
            }
            --i4;
        }
        int i5 = 0;
        while (i5 < vi.channels) {
            float[] pcm = vb.pcm[i5];
            int submap = info.chmuxlist[i5];
            look.floor_func[submap].inverse2(vb, look.floor_look[submap], this.floormemo[i5], pcm);
            ++i5;
        }
        int i6 = 0;
        while (i6 < vi.channels) {
            float[] pcm = vb.pcm[i6];
            ((Mdct)vd.transform[vb.W][0]).backward(pcm, pcm);
            ++i6;
        }
        int i7 = 0;
        while (i7 < vi.channels) {
            int j;
            float[] pcm = vb.pcm[i7];
            if (this.nonzero[i7] != 0) {
                j = 0;
                while (j < n) {
                    int n2 = j;
                    pcm[n2] = pcm[n2] * window[j];
                    ++j;
                }
            } else {
                j = 0;
                while (j < n) {
                    pcm[j] = 0.0f;
                    ++j;
                }
            }
            ++i7;
        }
        return 0;
    }

    private int ilog2(int v) {
        int ret = 0;
        while (v > 1) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    public static float todB(float x) {
        return (float)(Float.floatToIntBits(x) & Integer.MAX_VALUE) * 7.1771143E-7f - 764.6162f;
    }

    private float todB345(float x) {
        return (float)(Float.floatToIntBits(x) & Integer.MAX_VALUE) * 7.1771143E-7f - 764.2712f;
    }

    private float todB05(float x) {
        return (float)(Float.floatToIntBits(x) & Integer.MAX_VALUE) * 3.5885571E-7f - 381.9631f;
    }

    public int mapping0Forward(Block vb) {
        int k;
        int j;
        CodecSetupInfo ci = vb.dspState.vi.getCodecSetup();
        BlockInternal vbi = vb.blockInternal;
        int n = vb.pcmEnd;
        int channels = vb.dspState.vi.channels;
        int[] nonzero = new int[channels];
        float[][] gmdct = new float[channels][];
        int[][] ilogmaskch = new int[channels][];
        int[][][] floor_posts = new int[channels][][];
        float global_ampmax = vbi.ampmax;
        float[] local_ampmax = new float[channels];
        int blocktype = vbi.blocktype;
        int modenumber = vb.W;
        InfoMapping0 info = ci.mapParam[modenumber];
        PsyLook psyLook = vb.dspState.backEndState.psy[blocktype + (vb.W != 0 ? 2 : 0)];
        vb.mode = modenumber;
        int i = 0;
        while (i < channels) {
            float[] pcm;
            float scale = 4.0f / (float)n;
            float[] logfft = pcm = vb.pcm[i];
            gmdct[i] = new float[n / 2];
            float scale_dB = this.todB345(scale);
            this.window.applyWindow(pcm, vb.dspState.backEndState.window, ci.blocksizes, vb.lW, vb.W, vb.nW);
            vb.dspState.backEndState.transform[vb.W][0].mdct_forward(pcm, gmdct[i]);
            vb.dspState.backEndState.fftLook[vb.W].drft_forward(pcm);
            logfft[0] = scale_dB + this.todB345(pcm[0]);
            local_ampmax[i] = logfft[0];
            j = 1;
            while (j < n - 1) {
                float temp = pcm[j] * pcm[j] + pcm[j + 1] * pcm[j + 1];
                float f = logfft[j + 1 >> 1] = scale_dB + this.todB05(temp);
                temp = f;
                if (temp > local_ampmax[i]) {
                    local_ampmax[i] = temp;
                }
                j += 2;
            }
            if (local_ampmax[i] > 0.0f) {
                local_ampmax[i] = 0.0f;
            }
            if (local_ampmax[i] > global_ampmax) {
                global_ampmax = local_ampmax[i];
            }
            ++i;
        }
        float[] noise = new float[n / 2];
        float[] tone = new float[n / 2];
        i = 0;
        while (i < channels) {
            float[] logfft;
            int submap = info.chmuxlist[i];
            float[] mdct = gmdct[i];
            float[] logmask = logfft = vb.pcm[i];
            vb.mode = modenumber;
            floor_posts[i] = new int[15][];
            j = 0;
            while (j < n / 2) {
                logfft[j + n / 2] = this.todB345(mdct[j]);
                ++j;
            }
            psyLook.noiseMask(logfft, n / 2, noise);
            psyLook.toneMask(logfft, tone, global_ampmax, local_ampmax[i]);
            psyLook.offsetAndMix(noise, tone, 1, logmask, mdct, logfft, n / 2);
            if (ci.floorType[info.floorsubmap[submap]] != 1) {
                return -1;
            }
            floor_posts[i][7] = this.floor1.fit(vb, info.floorsubmap[submap], logfft, n / 2, logmask);
            if (vb.bitrateManaged() && floor_posts[i][7] != null) {
                psyLook.offsetAndMix(noise, tone, 2, logmask, mdct, logfft, n / 2);
                floor_posts[i][14] = this.floor1.fit(vb, info.floorsubmap[submap], logfft, n / 2, logmask);
                psyLook.offsetAndMix(noise, tone, 0, logmask, mdct, logfft, n / 2);
                floor_posts[i][0] = this.floor1.fit(vb, info.floorsubmap[submap], logfft, n / 2, logmask);
                k = 1;
                while (k < 7) {
                    floor_posts[i][k] = this.floor1.interpolate(vb, info.floorsubmap[submap], floor_posts[i][0], floor_posts[i][7], k * 65536 / 7);
                    ++k;
                }
                k = 8;
                while (k < 14) {
                    floor_posts[i][k] = this.floor1.interpolate(vb, info.floorsubmap[submap], floor_posts[i][7], floor_posts[i][14], (k - 7) * 65536 / 7);
                    ++k;
                }
            }
            ++i;
        }
        vbi.ampmax = global_ampmax;
        float[][] couple_bundle = new float[channels][];
        int[] zerobundle = new int[channels];
        int[][] sortindex = new int[channels][];
        float[][] mag_memo = new float[1][1];
        int[][] mag_sort = new int[1][1];
        if (info.coupling_steps != 0) {
            mag_memo = psyLook.quantizeCoupleMemo(ci.psyGlobParam, info, gmdct);
            mag_sort = psyLook.quantizeCoupleSort(info, mag_memo);
            psyLook.hfReduction(ci.psyGlobParam, info, mag_memo);
        }
        if (psyLook.vi.normal_channel_p != 0) {
            i = 0;
            while (i < channels) {
                float[] mdct = gmdct[i];
                sortindex[i] = new int[n / 2];
                sortindex[i] = psyLook.noisenNormalizeSort(mdct);
                ++i;
            }
        }
        k = vb.bitrateManaged() ? 0 : 7;
        while (k <= (vb.bitrateManaged() ? 14 : 7)) {
            Buffer opb = vbi.packetblob[k];
            opb.write(0, 1);
            opb.write(modenumber, vb.dspState.backEndState.modeBits);
            if (vb.W != 0) {
                opb.write(vb.lW, 1);
                opb.write(vb.nW, 1);
            }
            i = 0;
            while (i < channels) {
                int submap = info.chmuxlist[i];
                float[] mdct = gmdct[i];
                float[] res = vb.pcm[i];
                ilogmaskch[i] = new int[n / 2];
                int[] ilogmask = ilogmaskch[i];
                nonzero[i] = this.floor1.encode(vb, opb, info.floorsubmap[submap], floor_posts[i][k], ilogmask);
                psyLook.removeFloor(mdct, ilogmask, res, ci.psyGlobParam.sliding_lowpass[vb.W][k]);
                psyLook.noiseNormalize(res, res, n / 2, sortindex[i]);
                ++i;
            }
            if (info.coupling_steps != 0) {
                psyLook.couple(k, ci.psyGlobParam, info, vb.pcm, mag_memo, mag_sort, ilogmaskch, nonzero, ci.psyGlobParam.sliding_lowpass[vb.W][k]);
            }
            i = 0;
            while (i < info.submaps) {
                int ch_in_bundle = 0;
                int resnum = info.residuesubmap[i];
                j = 0;
                while (j < channels) {
                    if (info.chmuxlist[j] == i) {
                        zerobundle[ch_in_bundle] = 0;
                        if (nonzero[j] != 0) {
                            zerobundle[ch_in_bundle] = 1;
                        }
                        couple_bundle[ch_in_bundle] = new float[vb.pcm[j].length - n / 2];
                        System.arraycopy(vb.pcm[j], n / 2, couple_bundle[ch_in_bundle], 0, couple_bundle[ch_in_bundle].length);
                        ++ch_in_bundle;
                    }
                    ++j;
                }
                int[][] classifications = FuncResidue.residue_P[ci.residueType[resnum]].clas(vb.dspState.backEndState.residue[resnum], vb.pcm, n / 2, zerobundle, channels);
                FuncResidue.residue_P[ci.residueType[resnum]].forward(opb, vb, vb.dspState.backEndState.residue[resnum], couple_bundle, null, zerobundle, ch_in_bundle, classifications);
                ++i;
            }
            ++k;
        }
        return 0;
    }
}

