/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

public class Mdct {
    private static final float cPI3_8 = 0.38268343f;
    private static final float cPI2_8 = 0.70710677f;
    private static final float cPI1_8 = 0.9238795f;
    private static final float M_PI = (float)Math.PI;
    private static final int TRIGBITS = 14;
    int n;
    int log2n;
    float[] trig;
    int[] bitrev;
    float scale;
    float[] _x = new float[1024];
    float[] _w = new float[1024];

    private static float FLOAT_CONV(double x) {
        return (float)x * 2.0f / 2.0f;
    }

    private static float MULT_NORM(float x) {
        return x;
    }

    private static float HALVE(float x) {
        if (x != 0.0f) {
            boolean bl = false;
        }
        return x / 2.0f;
    }

    void init(int n) {
        this.bitrev = new int[n / 4];
        this.trig = new float[n + n / 4];
        int n2 = n >>> 1;
        this.log2n = (int)Math.rint(Math.log(n) / Math.log(2.0));
        this.n = n;
        int AE = 0;
        boolean AO = true;
        int BE = AE + n / 2;
        int BO = BE + 1;
        int CE = BE + n / 2;
        int CO = CE + 1;
        int i = 0;
        while (i < n / 4) {
            this.trig[i * 2] = Mdct.FLOAT_CONV(Math.cos((float)Math.PI / (float)n * (float)(4 * i)));
            this.trig[i * 2 + 1] = Mdct.FLOAT_CONV(-Math.sin((float)Math.PI / (float)n * (float)(4 * i)));
            this.trig[n2 + i * 2] = Mdct.FLOAT_CONV(Math.cos((float)Math.PI / (float)(2 * n) * (float)(2 * i + 1)));
            this.trig[n2 + i * 2 + 1] = Mdct.FLOAT_CONV(Math.sin((float)Math.PI / (float)(2 * n) * (float)(2 * i + 1)));
            ++i;
        }
        int i2 = 0;
        while (i2 < n / 8) {
            this.trig[n + i2 * 2] = Mdct.FLOAT_CONV(Math.cos((float)Math.PI / (float)n * (float)(4 * i2 + 2)) * 0.5);
            this.trig[n + i2 * 2 + 1] = Mdct.FLOAT_CONV(-Math.sin((float)Math.PI / (float)n * (float)(4 * i2 + 2)) * 0.5);
            ++i2;
        }
        int mask = (1 << this.log2n - 1) - 1;
        int msb = 1 << this.log2n - 2;
        int i3 = 0;
        while (i3 < n / 8) {
            int acc = 0;
            int j = 0;
            while (msb >>> j != 0) {
                if ((msb >>> j & i3) != 0) {
                    acc |= 1 << j;
                }
                ++j;
            }
            this.bitrev[i3 * 2] = (~acc & mask) - 1;
            this.bitrev[i3 * 2 + 1] = acc;
            ++i3;
        }
        this.scale = 4.0f / (float)n;
    }

    void clear() {
    }

    private void mdct_butterflies(float[] x, int px, int points) {
        int j;
        float[] T = this.trig;
        int stages = this.log2n - 5;
        if (--stages > 0) {
            Mdct.mdct_butterfly_first(T, x, px, points);
        }
        int i = 1;
        while (--stages > 0) {
            j = 0;
            while (j < 1 << i) {
                Mdct.mdct_butterfly_generic(T, x, px + (points >> i) * j, points >> i, 4 << i);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < points) {
            Mdct.mdct_butterfly_32(x, px + j);
            j += 32;
        }
    }

    static void mdct_butterfly_8(float[] x, int px) {
        float r0 = x[6 + px] + x[2 + px];
        float r1 = x[6 + px] - x[2 + px];
        float r2 = x[4 + px] + x[0 + px];
        float r3 = x[4 + px] - x[0 + px];
        x[6 + px] = r0 + r2;
        x[4 + px] = r0 - r2;
        r0 = x[5 + px] - x[1 + px];
        r2 = x[7 + px] - x[3 + px];
        x[0 + px] = r1 + r0;
        x[2 + px] = r1 - r0;
        r0 = x[5 + px] + x[1 + px];
        r1 = x[7 + px] + x[3 + px];
        x[3 + px] = r2 + r3;
        x[1 + px] = r2 - r3;
        x[7 + px] = r1 + r0;
        x[5 + px] = r1 - r0;
    }

    static void mdct_butterfly_16(float[] x, int px) {
        float r0 = x[1 + px] - x[9 + px];
        float r1 = x[0 + px] - x[8 + px];
        int n = 8 + px;
        x[n] = x[n] + x[0 + px];
        int n2 = 9 + px;
        x[n2] = x[n2] + x[1 + px];
        x[0 + px] = Mdct.MULT_NORM((r0 + r1) * 0.70710677f);
        x[1 + px] = Mdct.MULT_NORM((r0 - r1) * 0.70710677f);
        r0 = x[3 + px] - x[11 + px];
        r1 = x[10 + px] - x[2 + px];
        int n3 = 10 + px;
        x[n3] = x[n3] + x[2 + px];
        int n4 = 11 + px;
        x[n4] = x[n4] + x[3 + px];
        x[2 + px] = r0;
        x[3 + px] = r1;
        r0 = x[12 + px] - x[4 + px];
        r1 = x[13 + px] - x[5 + px];
        int n5 = 12 + px;
        x[n5] = x[n5] + x[4 + px];
        int n6 = 13 + px;
        x[n6] = x[n6] + x[5 + px];
        x[4 + px] = Mdct.MULT_NORM((r0 - r1) * 0.70710677f);
        x[5 + px] = Mdct.MULT_NORM((r0 + r1) * 0.70710677f);
        r0 = x[14 + px] - x[6 + px];
        r1 = x[15 + px] - x[7 + px];
        int n7 = 14 + px;
        x[n7] = x[n7] + x[6 + px];
        int n8 = 15 + px;
        x[n8] = x[n8] + x[7 + px];
        x[6 + px] = r0;
        x[7 + px] = r1;
        Mdct.mdct_butterfly_8(x, px);
        Mdct.mdct_butterfly_8(x, px + 8);
    }

    static void mdct_butterfly_32(float[] x, int px) {
        float r0 = x[30 + px] - x[14 + px];
        float r1 = x[31 + px] - x[15 + px];
        int n = 30 + px;
        x[n] = x[n] + x[14 + px];
        int n2 = 31 + px;
        x[n2] = x[n2] + x[15 + px];
        x[14 + px] = r0;
        x[15 + px] = r1;
        r0 = x[28 + px] - x[12 + px];
        r1 = x[29 + px] - x[13 + px];
        int n3 = 28 + px;
        x[n3] = x[n3] + x[12 + px];
        int n4 = 29 + px;
        x[n4] = x[n4] + x[13 + px];
        x[12 + px] = Mdct.MULT_NORM(r0 * 0.9238795f - r1 * 0.38268343f);
        x[13 + px] = Mdct.MULT_NORM(r0 * 0.38268343f + r1 * 0.9238795f);
        r0 = x[26 + px] - x[10 + px];
        r1 = x[27 + px] - x[11 + px];
        int n5 = 26 + px;
        x[n5] = x[n5] + x[10 + px];
        int n6 = 27 + px;
        x[n6] = x[n6] + x[11 + px];
        x[10 + px] = Mdct.MULT_NORM((r0 - r1) * 0.70710677f);
        x[11 + px] = Mdct.MULT_NORM((r0 + r1) * 0.70710677f);
        r0 = x[24 + px] - x[8 + px];
        r1 = x[25 + px] - x[9 + px];
        int n7 = 24 + px;
        x[n7] = x[n7] + x[8 + px];
        int n8 = 25 + px;
        x[n8] = x[n8] + x[9 + px];
        x[8 + px] = Mdct.MULT_NORM(r0 * 0.38268343f - r1 * 0.9238795f);
        x[9 + px] = Mdct.MULT_NORM(r1 * 0.38268343f + r0 * 0.9238795f);
        r0 = x[22 + px] - x[6 + px];
        r1 = x[7 + px] - x[23 + px];
        int n9 = 22 + px;
        x[n9] = x[n9] + x[6 + px];
        int n10 = 23 + px;
        x[n10] = x[n10] + x[7 + px];
        x[6 + px] = r1;
        x[7 + px] = r0;
        r0 = x[4 + px] - x[20 + px];
        r1 = x[5 + px] - x[21 + px];
        int n11 = 20 + px;
        x[n11] = x[n11] + x[4 + px];
        int n12 = 21 + px;
        x[n12] = x[n12] + x[5 + px];
        x[4 + px] = Mdct.MULT_NORM(r1 * 0.9238795f + r0 * 0.38268343f);
        x[5 + px] = Mdct.MULT_NORM(r1 * 0.38268343f - r0 * 0.9238795f);
        r0 = x[2 + px] - x[18 + px];
        r1 = x[3 + px] - x[19 + px];
        int n13 = 18 + px;
        x[n13] = x[n13] + x[2 + px];
        int n14 = 19 + px;
        x[n14] = x[n14] + x[3 + px];
        x[2 + px] = Mdct.MULT_NORM((r1 + r0) * 0.70710677f);
        x[3 + px] = Mdct.MULT_NORM((r1 - r0) * 0.70710677f);
        r0 = x[0 + px] - x[16 + px];
        r1 = x[1 + px] - x[17 + px];
        int n15 = 16 + px;
        x[n15] = x[n15] + x[0 + px];
        int n16 = 17 + px;
        x[n16] = x[n16] + x[1 + px];
        x[0 + px] = Mdct.MULT_NORM(r1 * 0.38268343f + r0 * 0.9238795f);
        x[1 + px] = Mdct.MULT_NORM(r1 * 0.9238795f - r0 * 0.38268343f);
        Mdct.mdct_butterfly_16(x, px);
        Mdct.mdct_butterfly_16(x, px + 16);
    }

    static void mdct_butterfly_first(float[] T, float[] x, int px, int points) {
        int px1 = points - 8 + px;
        int px2 = (points >> 1) - 8 + px;
        int pT = 0;
        do {
            float r0 = x[6 + px1] - x[6 + px2];
            float r1 = x[7 + px1] - x[7 + px2];
            int n = 6 + px1;
            x[n] = x[n] + x[6 + px2];
            int n2 = 7 + px1;
            x[n2] = x[n2] + x[7 + px2];
            x[6 + px2] = Mdct.MULT_NORM(r1 * T[1 + pT] + r0 * T[0 + pT]);
            x[7 + px2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            r0 = x[4 + px1] - x[4 + px2];
            r1 = x[5 + px1] - x[5 + px2];
            int n3 = 4 + px1;
            x[n3] = x[n3] + x[4 + px2];
            int n4 = 5 + px1;
            x[n4] = x[n4] + x[5 + px2];
            x[4 + px2] = Mdct.MULT_NORM(r1 * T[5 + pT] + r0 * T[4 + pT]);
            x[5 + px2] = Mdct.MULT_NORM(r1 * T[4 + pT] - r0 * T[5 + pT]);
            r0 = x[2 + px1] - x[2 + px2];
            r1 = x[3 + px1] - x[3 + px2];
            int n5 = 2 + px1;
            x[n5] = x[n5] + x[2 + px2];
            int n6 = 3 + px1;
            x[n6] = x[n6] + x[3 + px2];
            x[2 + px2] = Mdct.MULT_NORM(r1 * T[9 + pT] + r0 * T[8 + pT]);
            x[3 + px2] = Mdct.MULT_NORM(r1 * T[8 + pT] - r0 * T[9 + pT]);
            r0 = x[0 + px1] - x[0 + px2];
            r1 = x[1 + px1] - x[1 + px2];
            int n7 = 0 + px1;
            x[n7] = x[n7] + x[0 + px2];
            int n8 = 1 + px1;
            x[n8] = x[n8] + x[1 + px2];
            x[0 + px2] = Mdct.MULT_NORM(r1 * T[13 + pT] + r0 * T[12 + pT]);
            x[1 + px2] = Mdct.MULT_NORM(r1 * T[12 + pT] - r0 * T[13 + pT]);
            px1 -= 8;
            pT += 16;
        } while ((px2 -= 8) >= x.length - px);
    }

    static void mdct_butterfly_generic(float[] T, float[] x, int px, int points, int trigint) {
        int px1 = points - 8 + px;
        int px2 = (points >> 1) - 8 + px;
        int pT = 0;
        do {
            float r0 = x[6 + px1] - x[6 + px2];
            float r1 = x[7 + px1] - x[7 + px2];
            int n = 6 + px1;
            x[n] = x[n] + x[6 + px2];
            int n2 = 7 + px1;
            x[n2] = x[n2] + x[7 + px2];
            x[6 + px2] = Mdct.MULT_NORM(r1 * T[1 + pT] + r0 * T[0 + pT]);
            x[7 + px2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            pT += trigint;
            r0 = x[4 + px1] - x[4 + px2];
            r1 = x[5 + px1] - x[5 + px2];
            int n3 = 4 + px1;
            x[n3] = x[n3] + x[4 + px2];
            int n4 = 5 + px1;
            x[n4] = x[n4] + x[5 + px2];
            x[4 + px2] = Mdct.MULT_NORM(r1 * T[1 + pT] + r0 * T[0 + pT]);
            x[5 + px2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            pT += trigint;
            r0 = x[2 + px1] - x[2 + px2];
            r1 = x[3 + px1] - x[3 + px2];
            int n5 = 2 + px1;
            x[n5] = x[n5] + x[2 + px2];
            int n6 = 3 + px1;
            x[n6] = x[n6] + x[3 + px2];
            x[2 + px2] = Mdct.MULT_NORM(r1 * T[1 + pT] + r0 * T[0 + pT]);
            x[3 + px2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            pT += trigint;
            r0 = x[0 + px1] - x[0 + px2];
            r1 = x[1 + px1] - x[1 + px2];
            int n7 = 0 + px1;
            x[n7] = x[n7] + x[0 + px2];
            int n8 = 1 + px1;
            x[n8] = x[n8] + x[1 + px2];
            x[0 + px2] = Mdct.MULT_NORM(r1 * T[1 + pT] + r0 * T[0 + pT]);
            x[1 + px2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            pT += trigint;
            px1 -= 8;
        } while ((px2 -= 8) >= px);
    }

    private void mdct_bitreverse(float[] x) {
        int n = this.n;
        int[] bit = this.bitrev;
        int pbit = 0;
        int pw0 = 0;
        int pw1 = n >> 1;
        float[] T = this.trig;
        int pT = n;
        do {
            int px0 = bit[0 + pbit] + (n >> 1);
            int px1 = bit[1 + pbit] + (n >> 1);
            float r0 = x[1 + px0] - x[1 + px1];
            float r1 = x[0 + px0] + x[0 + px1];
            float r2 = Mdct.MULT_NORM(r1 * T[0 + pT] + r0 * T[1 + pT]);
            float r3 = Mdct.MULT_NORM(r1 * T[1 + pT] - r0 * T[0 + pT]);
            r0 = Mdct.HALVE(x[1 + px0] + x[1 + px1]);
            r1 = Mdct.HALVE(x[0 + px0] - x[0 + px1]);
            x[0 + pw0] = r0 + r2;
            x[2 + (pw1 -= 4)] = r0 - r2;
            x[1 + pw0] = r1 + r3;
            x[3 + pw1] = r3 - r1;
            px0 = bit[2 + pbit] + (n >> 1);
            px1 = bit[3 + pbit] + (n >> 1);
            r0 = x[1 + px0] - x[1 + px1];
            r1 = x[0 + px0] + x[0 + px1];
            r2 = Mdct.MULT_NORM(r1 * T[2 + pT] + r0 * T[3 + pT]);
            r3 = Mdct.MULT_NORM(r1 * T[3 + pT] - r0 * T[2 + pT]);
            r0 = Mdct.HALVE(x[1 + px0] + x[1 + px1]);
            r1 = Mdct.HALVE(x[0 + px0] - x[0 + px1]);
            x[2 + pw0] = r0 + r2;
            x[0 + pw1] = r0 - r2;
            x[3 + pw0] = r1 + r3;
            x[1 + pw1] = r3 - r1;
            pT += 4;
            pbit += 4;
        } while ((pw0 += 4) < pw1);
    }

    public void mdct_forward(float[] in, float[] out) {
        float r1;
        float r0;
        int n = this.n;
        int n2 = n >> 1;
        int n4 = n >> 2;
        int n8 = n >> 3;
        float[] w = new float[n];
        int pw2 = n2;
        int px0 = n2 + n4;
        int px1 = px0 + 1;
        float[] T = this.trig;
        int pT = n2;
        int i = 0;
        i = 0;
        while (i < n8) {
            r0 = in[2 + (px0 -= 4)] + in[0 + px1];
            r1 = in[0 + px0] + in[2 + px1];
            w[i + pw2] = Mdct.MULT_NORM(r1 * T[1 + (pT -= 2)] + r0 * T[0 + pT]);
            w[i + 1 + pw2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            px1 += 4;
            i += 2;
        }
        px1 = 1;
        while (i < n2 - n8) {
            r0 = in[2 + (px0 -= 4)] - in[0 + px1];
            r1 = in[0 + px0] - in[2 + px1];
            w[i + pw2] = Mdct.MULT_NORM(r1 * T[1 + (pT -= 2)] + r0 * T[0 + pT]);
            w[i + 1 + pw2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            px1 += 4;
            i += 2;
        }
        px0 = n;
        while (i < n2) {
            r0 = -in[2 + (px0 -= 4)] - in[0 + px1];
            r1 = -in[0 + px0] - in[2 + px1];
            w[i + pw2] = Mdct.MULT_NORM(r1 * T[1 + (pT -= 2)] + r0 * T[0 + pT]);
            w[i + 1 + pw2] = Mdct.MULT_NORM(r1 * T[0 + pT] - r0 * T[1 + pT]);
            px1 += 4;
            i += 2;
        }
        this.mdct_butterflies(w, n2, n2);
        this.mdct_bitreverse(w);
        pT = n2;
        px0 = n2;
        int pw = 0;
        i = 0;
        while (i < n4) {
            out[i] = Mdct.MULT_NORM((w[0 + pw] * T[0 + pT] + w[1 + pw] * T[1 + pT]) * this.scale);
            out[0 + --px0] = Mdct.MULT_NORM((w[0 + pw] * T[1 + pT] - w[1 + pw] * T[0 + pT]) * this.scale);
            pw += 2;
            pT += 2;
            ++i;
        }
    }

    synchronized void backward(float[] in, float[] out) {
        if (this._x.length < this.n / 2) {
            this._x = new float[this.n / 2];
        }
        if (this._w.length < this.n / 2) {
            this._w = new float[this.n / 2];
        }
        float[] x = this._x;
        float[] w = this._w;
        int n2 = this.n >>> 1;
        int n4 = this.n >>> 2;
        int n8 = this.n >>> 3;
        int inO = 1;
        int xO = 0;
        int A = n2;
        int i = 0;
        while (i < n8) {
            x[xO++] = -in[inO + 2] * this.trig[(A -= 2) + 1] - in[inO] * this.trig[A];
            x[xO++] = in[inO] * this.trig[A + 1] - in[inO + 2] * this.trig[A];
            inO += 4;
            ++i;
        }
        inO = n2 - 4;
        i = 0;
        while (i < n8) {
            x[xO++] = in[inO] * this.trig[(A -= 2) + 1] + in[inO + 2] * this.trig[A];
            x[xO++] = in[inO] * this.trig[A] - in[inO + 2] * this.trig[A + 1];
            inO -= 4;
            ++i;
        }
        float[] xxx = this.mdct_kernel(x, w, this.n, n2, n4, n8);
        int xx = 0;
        int B = n2;
        int o1 = n4;
        int o2 = o1 - 1;
        int o3 = n4 + n2;
        int o4 = o3 - 1;
        int i2 = 0;
        while (i2 < n4) {
            float temp1 = xxx[xx] * this.trig[B + 1] - xxx[xx + 1] * this.trig[B];
            float temp2 = -(xxx[xx] * this.trig[B] + xxx[xx + 1] * this.trig[B + 1]);
            out[o1] = -temp1;
            out[o2] = temp1;
            out[o3] = temp2;
            out[o4] = temp2;
            ++o1;
            --o2;
            ++o3;
            --o4;
            xx += 2;
            B += 2;
            ++i2;
        }
    }

    private float[] mdct_kernel(float[] x, float[] w, int n, int n2, int n4, int n8) {
        int xA = n4;
        int xB = 0;
        int w2 = n4;
        int A = n2;
        int i = 0;
        while (i < n4) {
            float x0 = x[xA] - x[xB];
            w[w2 + i] = x[xA++] + x[xB++];
            float x1 = x[xA] - x[xB];
            w[i++] = x0 * this.trig[A -= 4] + x1 * this.trig[A + 1];
            w[i] = x1 * this.trig[A] - x0 * this.trig[A + 1];
            w[w2 + i] = x[xA++] + x[xB++];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.log2n - 3) {
            int k0 = n >>> i2 + 2;
            int k1 = 1 << i2 + 3;
            int wbase = n2 - 2;
            A = 0;
            int r = 0;
            while (r < k0 >>> 2) {
                int w1 = wbase;
                w2 = w1 - (k0 >> 1);
                float AEv = this.trig[A];
                float AOv = this.trig[A + 1];
                wbase -= 2;
                ++k0;
                int s = 0;
                while (s < 2 << i2) {
                    float wB = w[w1] - w[w2];
                    x[w1] = w[w1] + w[w2];
                    float wA = w[++w1] - w[++w2];
                    x[w1] = w[w1] + w[w2];
                    x[w2] = wA * AEv - wB * AOv;
                    x[w2 - 1] = wB * AEv + wA * AOv;
                    w1 -= k0;
                    w2 -= k0;
                    ++s;
                }
                --k0;
                A += k1;
                ++r;
            }
            float[] temp = w;
            w = x;
            x = temp;
            ++i2;
        }
        int C = n;
        int bit = 0;
        int x1 = 0;
        int x2 = n2 - 1;
        int i3 = 0;
        while (i3 < n8) {
            int t1 = this.bitrev[bit++];
            int t2 = this.bitrev[bit++];
            float wA = w[t1] - w[t2 + 1];
            float wB = w[t1 - 1] + w[t2];
            float wC = w[t1] + w[t2 + 1];
            float wD = w[t1 - 1] - w[t2];
            float wACE = wA * this.trig[C];
            float wBCE = wB * this.trig[C++];
            float wACO = wA * this.trig[C];
            float wBCO = wB * this.trig[C++];
            x[x1++] = (wC + wACO + wBCE) * 0.5f;
            x[x2--] = (-wD + wBCO - wACE) * 0.5f;
            x[x1++] = (wD + wBCO - wACE) * 0.5f;
            x[x2--] = (wC - wACO - wBCE) * 0.5f;
            ++i3;
        }
        return x;
    }
}

