/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.vorbis.Block;
import biniu.vorbis.CodeBook;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.DspState;
import biniu.vorbis.EncodeAuxThreshMatch;
import biniu.vorbis.FuncResidue;
import biniu.vorbis.Info;
import biniu.vorbis.InfoMode;
import biniu.vorbis.InfoResidue0;
import biniu.vorbis.LookResidue;
import biniu.vorbis.StaticCodeBook;

class Residue0
extends FuncResidue {
    private int[][][] partword = new int[2][][];

    Residue0() {
    }

    void pack(Object vr, Buffer opb) {
        InfoResidue0 info = (InfoResidue0)vr;
        int acc = 0;
        opb.write(info.begin, 24);
        opb.write(info.end, 24);
        opb.write(info.grouping - 1, 24);
        opb.write(info.partitions - 1, 6);
        opb.write(info.groupbook, 8);
        int j = 0;
        while (j < info.partitions) {
            if (this.iLog(info.secondstages[j]) > 3) {
                opb.write(info.secondstages[j], 3);
                opb.write(1, 1);
                opb.write(info.secondstages[j] >>> 3, 5);
            } else {
                opb.write(info.secondstages[j], 4);
            }
            acc += this.iCount(info.secondstages[j]);
            ++j;
        }
        int j2 = 0;
        while (j2 < acc) {
            opb.write(info.booklist[j2], 8);
            ++j2;
        }
    }

    LookResidue unpack(Info vi, Buffer opb) {
        int acc = 0;
        InfoResidue0 info = new InfoResidue0();
        info.begin = opb.read(24);
        info.end = opb.read(24);
        info.grouping = opb.read(24) + 1;
        info.partitions = opb.read(6) + 1;
        info.groupbook = opb.read(8);
        int j = 0;
        while (j < info.partitions) {
            int cascade = opb.read(3);
            if (opb.read(1) != 0) {
                cascade |= opb.read(5) << 3;
            }
            info.secondstages[j] = cascade;
            acc += this.iCount(cascade);
            ++j;
        }
        int j2 = 0;
        while (j2 < acc) {
            info.booklist[j2] = opb.read(8);
            ++j2;
        }
        if (info.groupbook >= vi.books) {
            this.clear(info);
            return null;
        }
        int j3 = 0;
        while (j3 < acc) {
            if (info.booklist[j3] >= vi.books) {
                this.clear(info);
                return null;
            }
            ++j3;
        }
        return null;
    }

    public LookResidue look(DspState vd, Object vr) {
        int k;
        InfoResidue0 info = (InfoResidue0)vr;
        LookResidue look = new LookResidue();
        CodecSetupInfo ci = vd.vi.getCodecSetup();
        int acc = 0;
        int maxstage = 0;
        look.info = info;
        look.parts = info.partitions;
        look.fullbooks = ci.fullBooks;
        look.phrasebook = ci.fullBooks[info.groupbook];
        int dim = look.phrasebook.dim;
        look.partbooks = new CodeBook[look.parts][];
        int j = 0;
        while (j < look.parts) {
            int stages = this.iLog(info.secondstages[j]);
            if (stages != 0) {
                if (stages > maxstage) {
                    maxstage = stages;
                }
                look.partbooks[j] = new CodeBook[stages];
                k = 0;
                while (k < stages) {
                    if ((info.secondstages[j] & 1 << k) != 0) {
                        look.partbooks[j][k] = ci.fullBooks[info.booklist[acc++]];
                    }
                    ++k;
                }
            }
            ++j;
        }
        look.partvals = (int)Math.rint(Math.pow(look.parts, dim));
        look.stages = maxstage;
        look.decodemap = new int[look.partvals][];
        j = 0;
        while (j < look.partvals) {
            int val = j;
            int mult = look.partvals / look.parts;
            look.decodemap[j] = new int[dim];
            k = 0;
            while (k < dim) {
                int deco = val / mult;
                val -= deco * mult;
                mult /= look.parts;
                look.decodemap[j][k] = deco;
                ++k;
            }
            ++j;
        }
        return look;
    }

    public LookResidue look(DspState vd, InfoMode vm, Object vr) {
        InfoResidue0 info = (InfoResidue0)vr;
        LookResidue look = new LookResidue();
        int acc = 0;
        int maxstage = 0;
        look.info = info;
        look.map = vm.mapping;
        look.parts = info.partitions;
        look.fullbooks = vd.fullbooks;
        look.phrasebook = vd.fullbooks[info.groupbook];
        int dim = look.phrasebook.dim;
        look.partbooks = new CodeBook[look.parts][];
        int j = 0;
        while (j < look.parts) {
            int stages = this.iLog(info.secondstages[j]);
            if (stages != 0) {
                if (stages > maxstage) {
                    maxstage = stages;
                }
                look.partbooks[j] = new CodeBook[stages];
                int k = 0;
                while (k < stages) {
                    if ((info.secondstages[j] & 1 << k) != 0) {
                        look.partbooks[j][k] = look.fullbooks[info.booklist[acc++]];
                    }
                    ++k;
                }
            }
            ++j;
        }
        look.partvals = (int)Math.rint(Math.pow(look.parts, dim));
        look.stages = maxstage;
        look.decodemap = new int[look.partvals][];
        int j2 = 0;
        while (j2 < look.partvals) {
            int val = j2;
            int mult = look.partvals / look.parts;
            look.decodemap[j2] = new int[dim];
            int k = 0;
            while (k < dim) {
                int deco = val / mult;
                val -= deco * mult;
                mult /= look.parts;
                look.decodemap[j2][k] = deco;
                ++k;
            }
            ++j2;
        }
        return look;
    }

    void clear(Object i) {
    }

    protected int _01inverse(Block vb, LookResidue look, float[][] in, int ch, int decodepart) {
        int j;
        InfoResidue0 info = look.info;
        int samples_per_partition = info.grouping;
        int partitions_per_word = look.phrasebook.dim;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int partwords = (partvals + partitions_per_word - 1) / partitions_per_word;
        if (this.partword.length < ch) {
            this.partword = new int[ch][][];
            j = 0;
            while (j < ch) {
                this.partword[j] = new int[partwords][];
                ++j;
            }
        } else {
            j = 0;
            while (j < ch) {
                if (this.partword[j] == null || this.partword[j].length < partwords) {
                    this.partword[j] = new int[partwords][];
                }
                ++j;
            }
        }
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            int l = 0;
            while (i < partvals) {
                if (s == 0) {
                    j = 0;
                    while (j < ch) {
                        int temp = look.phrasebook.decode(vb.opb);
                        if (temp == -1) {
                            return 0;
                        }
                        this.partword[j][l] = look.decodemap[temp];
                        if (this.partword[j][l] == null) {
                            return 0;
                        }
                        ++j;
                    }
                }
                int k = 0;
                while (k < partitions_per_word && i < partvals) {
                    j = 0;
                    while (j < ch) {
                        CodeBook stagebook;
                        int offset = info.begin + i * samples_per_partition;
                        if ((info.secondstages[this.partword[j][l][k]] & 1 << s) != 0 && (stagebook = look.partbooks[this.partword[j][l][k]][s]) != null && (decodepart == 0 ? stagebook.decodevs_add(in[j], offset, vb.opb, samples_per_partition) == -1 : decodepart == 1 && stagebook.decodev_add(in[j], offset, vb.opb, samples_per_partition) == -1)) {
                            return 0;
                        }
                        ++j;
                    }
                    ++k;
                    ++i;
                }
                ++l;
            }
            ++s;
        }
        return 0;
    }

    protected int _2inverse(Block vb, Object vl, float[][] in, int ch) {
        LookResidue look = (LookResidue)vl;
        InfoResidue0 info = look.info;
        int samples_per_partition = info.grouping;
        int partitions_per_word = look.phrasebook.dim;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int partwords = (partvals + partitions_per_word - 1) / partitions_per_word;
        int[][] partword = new int[partwords][];
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            int l = 0;
            while (i < partvals) {
                if (s == 0) {
                    int temp = look.phrasebook.decode(vb.opb);
                    if (temp == -1) {
                        return 0;
                    }
                    partword[l] = look.decodemap[temp];
                    if (partword[l] == null) {
                        return 0;
                    }
                }
                int k = 0;
                while (k < partitions_per_word && i < partvals) {
                    CodeBook stagebook;
                    int offset = info.begin + i * samples_per_partition;
                    if ((info.secondstages[partword[l][k]] & 1 << s) != 0 && (stagebook = look.partbooks[partword[l][k]][s]) != null && stagebook.decodevv_add(in, offset, ch, vb.opb, samples_per_partition) == -1) {
                        return 0;
                    }
                    ++k;
                    ++i;
                }
                ++l;
            }
            ++s;
        }
        return 0;
    }

    public int inverse(Block vb, LookResidue vl, float[][] in, int[] nonzero, int ch) {
        int used = 0;
        int i = 0;
        while (i < ch) {
            if (nonzero[i] != 0) {
                in[used++] = in[i];
            }
            ++i;
        }
        if (used != 0) {
            return this._01inverse(vb, vl, in, used, 0);
        }
        return 0;
    }

    private int iLog(int v) {
        int ret = 0;
        while (v != 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    private int iCount(int v) {
        int ret = 0;
        while (v != 0) {
            ret += v & 1;
            v >>>= 1;
        }
        return ret;
    }

    public int[][] clas(LookResidue vl, float[][] in, int pin, int[] nonzero, int ch) {
        int used = 0;
        int i = 0;
        while (i < ch) {
            if (nonzero[i] != 0) {
                in[used++] = in[i];
            }
            ++i;
        }
        if (used != 0) {
            return this._01class(vl, in, pin, used);
        }
        return null;
    }

    protected final int[][] _01class(LookResidue vl, float[][] in, int pin, int ch) {
        LookResidue look = vl;
        InfoResidue0 info = look.info;
        int samples_per_partition = info.grouping;
        int possible_partitions = info.partitions;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int[][] partword = new int[ch][];
        float scale = 100.0f / (float)samples_per_partition;
        int i = 0;
        while (i < ch) {
            partword[i] = new int[n / samples_per_partition];
            ++i;
        }
        i = 0;
        while (i < partvals) {
            int offset = i * samples_per_partition + info.begin + pin;
            int j = 0;
            while (j < ch) {
                float max = 0.0f;
                float ent = 0.0f;
                int k = 0;
                while (k < samples_per_partition) {
                    if (Math.abs(in[j][offset + k]) > max) {
                        max = Math.abs(in[j][offset + k]);
                    }
                    ent = (float)((double)ent + Math.abs(Math.rint(in[j][offset + k])));
                    ++k;
                }
                ent *= scale;
                k = 0;
                while (k < possible_partitions - 1) {
                    if (max <= info.classmetric1[k] && (info.classmetric2[k] < 0.0f || (float)((int)ent) < info.classmetric2[k])) break;
                    ++k;
                }
                partword[j][i] = k;
                ++j;
            }
            ++i;
        }
        ++look.frames;
        return partword;
    }

    public int forward(Buffer opb, Block vb, LookResidue vl, float[][] in, float[][] out, int[] nonzero, int ch, int[][] partword) {
        int j;
        int used = 0;
        int n = vb.pcmEnd / 2;
        int i = 0;
        while (i < ch) {
            if (nonzero[i] != 0) {
                if (out != null) {
                    j = 0;
                    while (j < n) {
                        float[] fArray = out[i];
                        int n2 = j;
                        fArray[n2] = fArray[n2] + in[i][j];
                        ++j;
                    }
                }
                in[used++] = in[i];
            }
            ++i;
        }
        if (used != 0) {
            int ret = this._01forward(opb, vb, vl, in, used, partword);
            if (out != null) {
                used = 0;
                i = 0;
                while (i < ch) {
                    if (nonzero[i] != 0) {
                        j = 0;
                        while (j < n) {
                            float[] fArray = out[i];
                            int n3 = j;
                            fArray[n3] = fArray[n3] - in[used][j];
                            ++j;
                        }
                        ++used;
                    }
                    ++i;
                }
            }
            return ret;
        }
        return 0;
    }

    public int _01forward(Buffer opb, Block vb, LookResidue look, float[][] in, int ch, int[][] partword) {
        DspState vd = vb.dspState;
        int samples_per_partition = look.info.grouping;
        int possible_partitions = look.info.partitions;
        int partitions_per_word = look.phrasebook.dim;
        int n = look.info.end - look.info.begin;
        int partvals = n / samples_per_partition;
        int[] resbits = new int[128];
        int[] resvals = new int[128];
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            while (i < partvals) {
                int k;
                int j;
                if (s == 0) {
                    j = 0;
                    while (j < ch) {
                        int val = partword[j][i];
                        k = 1;
                        while (k < partitions_per_word) {
                            val *= possible_partitions;
                            if (i + k < partvals) {
                                val += partword[j][i + k];
                            }
                            ++k;
                        }
                        if (val < look.phrasebook.entries) {
                            look.phrasebits += look.phrasebook.bookEncode(val, opb);
                        }
                        ++j;
                    }
                }
                k = 0;
                while (k < partitions_per_word && i < partvals) {
                    int offset = i * samples_per_partition + look.info.begin;
                    j = 0;
                    while (j < ch) {
                        CodeBook statebook;
                        if (s == 0) {
                            int n2 = partword[j][i];
                            resvals[n2] = resvals[n2] + samples_per_partition;
                        }
                        if ((look.info.secondstages[partword[j][i]] & 1 << s) != 0 && (statebook = look.partbooks[partword[j][i]][s]) != null) {
                            int[] accumulator = null;
                            int ret = this._encodepart(opb, in[j], offset, samples_per_partition, statebook, accumulator);
                            look.postbits += ret;
                            int n3 = partword[j][i];
                            resbits[n3] = resbits[n3] + ret;
                        }
                        ++j;
                    }
                    ++k;
                    ++i;
                }
            }
            ++s;
        }
        return 0;
    }

    private int _encodepart(Buffer opb, float[] vec, int pvec, int n, CodeBook book, int[] acc) {
        int bits = 0;
        int dim = book.dim;
        int step = n / dim;
        int i = 0;
        while (i < step) {
            int entry = this.bookBestError(book, vec, i * dim + pvec);
            bits += book.bookEncode(entry, opb);
            ++i;
        }
        return bits;
    }

    private int bookBestError(CodeBook book, float[] a, int pa) {
        int i;
        int dim = book.dim;
        int best = 0;
        EncodeAuxThreshMatch tt = book.c.thresh_tree;
        int k = 0;
        int o = dim;
        while (k < dim) {
            float val;
            i = tt.threshvals >> 1;
            if ((val = a[--o + pa]) < tt.quantthresh[i]) {
                if (val < tt.quantthresh[i - 1]) {
                    --i;
                    while (i > 0) {
                        if (!(val >= tt.quantthresh[i - 1])) {
                            --i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                ++i;
                while (i < tt.threshvals - 1) {
                    if (!(val < tt.quantthresh[i])) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            best = best * tt.quantvals + tt.quantmap[i];
            ++k;
        }
        if (book.c.lengthlist[best] <= 0) {
            StaticCodeBook c = book.c;
            i = 0;
            float bestf = 0.0f;
            float[] e = book.valuelist;
            best = -1;
            int g = 0;
            i = 0;
            while (i < book.entries) {
                if (c.lengthlist[i] > 0) {
                    float thisx = 0.0f;
                    int j = 0;
                    while (j < dim) {
                        float val = e[j + g] - a[j + pa];
                        thisx += val * val;
                        ++j;
                    }
                    if (best == -1 || thisx < bestf) {
                        bestf = thisx;
                        best = i;
                    }
                }
                g += dim;
                ++i;
            }
        }
        i = 0;
        while (i < dim) {
            int n = i + pa;
            a[n] = a[n] - book.valuelist[i + best * dim];
            ++i;
        }
        return best;
    }
}

