/*
 * Decompiled with CFR 0.152.
 */
package com.petersalomonsen.jjack.javasound;

import com.petersalomonsen.jjack.javasound.JJackLine;
import com.petersalomonsen.jjack.javasound.JJackMixerInfo;
import com.petersalomonsen.jjack.javasound.SourceJJackLine;
import com.petersalomonsen.jjack.javasound.TargetJJackLine;
import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackClient;
import de.gulden.framework.jjack.JJackSystem;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JJackMixer
extends JJackClient
implements Mixer {
    private static final long serialVersionUID = 1L;
    Vector targetLines = new Vector();
    Vector sourceLines = new Vector();
    AudioFormat[] audioFormatsOut;
    AudioFormat[] audioFormatsIn;

    public JJackMixer() {
        int outputs = JJackSystem.countPorts(1);
        this.audioFormatsOut = new AudioFormat[8 * outputs];
        this.fillAudioFormats(this.audioFormatsOut);
        int inputs = JJackSystem.countPorts(0);
        this.audioFormatsIn = new AudioFormat[8 * inputs];
        this.fillAudioFormats(this.audioFormatsIn);
        try {
            JJackSystem.setProcessor(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillAudioFormats(AudioFormat[] audioFormats) {
        for (int n = 0; n < audioFormats.length; ++n) {
            audioFormats[n] = new AudioFormat(JJackSystem.getSampleRate(), 8 + 8 * (n % 4), n / 8 + 1, true, n % 8 / 4 != 0);
        }
    }

    public void process(JJackAudioEvent e) {
        int n;
        float[] lineBuffer;
        int length;
        int channels;
        JJackLine line;
        int lineIndex;
        int channelIndex = 0;
        for (lineIndex = 0; lineIndex < this.sourceLines.size(); ++lineIndex) {
            line = (SourceJJackLine)this.sourceLines.get(lineIndex);
            channels = line.getFormat().getChannels();
            length = e.getOutput().capacity() * channels;
            if (((SourceJJackLine)line).canReadFloat(length)) {
                lineBuffer = ((SourceJJackLine)line).readFloat(length);
                for (n = 0; n < length; ++n) {
                    e.getOutputs()[n % channels + channelIndex].put(n / channels, lineBuffer[n]);
                }
            }
            channelIndex += channels;
        }
        channelIndex = 0;
        for (lineIndex = 0; lineIndex < this.targetLines.size(); ++lineIndex) {
            line = (TargetJJackLine)this.targetLines.get(lineIndex);
            channels = line.getFormat().getChannels();
            length = e.getInput().capacity() * channels;
            if (((TargetJJackLine)line).canWriteFloat(length)) {
                lineBuffer = ((TargetJJackLine)line).getFloatBuffer(length);
                for (n = 0; n < length; ++n) {
                    lineBuffer[n] = e.getInputs()[n % channels + channelIndex].get(n / channels);
                }
                ((TargetJJackLine)line).writeFloatBuffer();
            }
            channelIndex += channels;
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        JJackLine line = null;
        if (SourceDataLine.class.isAssignableFrom(info.getLineClass())) {
            line = new SourceJJackLine(this);
        } else if (TargetDataLine.class.isAssignableFrom(info.getLineClass())) {
            line = new TargetJJackLine(this);
        } else {
            throw new LineUnavailableException();
        }
        return line;
    }

    void registerOpenLine(JJackLine line) {
        if (line.getClass() == SourceJJackLine.class) {
            this.sourceLines.add(line);
        } else if (line.getClass() == TargetJJackLine.class) {
            this.targetLines.add(line);
        }
    }

    void unregisterLine(JJackLine line) {
        if (line.getClass() == SourceJJackLine.class) {
            this.sourceLines.remove(line);
        } else if (line.getClass() == TargetJJackLine.class) {
            this.targetLines.remove(line);
        }
    }

    public int getMaxLines(Line.Info info) {
        return 0;
    }

    public Mixer.Info getMixerInfo() {
        return JJackMixerInfo.getInfo();
    }

    public Line.Info[] getSourceLineInfo() {
        return new Line.Info[]{new DataLine.Info(SourceJJackLine.class, this.audioFormatsOut, 32, -1)};
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Line.Info[] infos = this.getSourceLineInfo();
        Vector<Line.Info> matchedInfos = new Vector<Line.Info>();
        for (int n = 0; n < infos.length; ++n) {
            info.matches(infos[n]);
            matchedInfos.add(info);
        }
        return (Line.Info[])matchedInfos.toArray();
    }

    public Line[] getSourceLines() {
        return null;
    }

    public Line.Info[] getTargetLineInfo() {
        return new Line.Info[]{new DataLine.Info(TargetJJackLine.class, this.audioFormatsIn, 32, -1)};
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Line.Info[] infos = this.getTargetLineInfo();
        Vector<Line.Info> matchedInfos = new Vector<Line.Info>();
        for (int n = 0; n < infos.length; ++n) {
            info.matches(infos[n]);
            matchedInfos.add(info);
        }
        return (Line.Info[])matchedInfos.toArray();
    }

    public Line[] getTargetLines() {
        return null;
    }

    public boolean isLineSupported(Line.Info info) {
        return true;
    }

    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    public void synchronize(Line[] lines, boolean maintainSync) {
    }

    public void unsynchronize(Line[] lines) {
    }

    public void addLineListener(LineListener listener) {
    }

    public void close() {
    }

    public Control getControl(Control.Type control) {
        return null;
    }

    public Control[] getControls() {
        return null;
    }

    public Line.Info getLineInfo() {
        return null;
    }

    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public void open() throws LineUnavailableException {
    }

    public void removeLineListener(LineListener listener) {
    }
}

