/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.application.jjack;

import de.gulden.application.jjack.JJackInfoBoxMouseListener;
import de.gulden.framework.jjack.JJackAudioConsumer;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackAudioProducer;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackMonitor;
import de.gulden.framework.jjack.JJackSystem;
import de.gulden.util.Toolbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;

public class JJack {
    protected static final String USAGE = "usage: ... java ... JJack {-i <package-import>} <client> { '[' { <monitor-client> } ']' } { <client> { '[' { <monitor-client> } ']' } } | -c <config-file> | -help";
    protected static final String ICON = "de/gulden/application/jjack/res/icon.png";
    protected static Font FONT = new Font("Dialog", 0, 9);
    protected static Font FONT_BIG = new Font("Dialog", 0, 10);
    private static Collection imports;
    private static boolean visibleMode;
    private static StringTokenizer st;
    private static String tok;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) {
        JJack.initSwing();
        String a = Toolbox.implode(args, " ");
        JJack.initTokenizer(a);
        visibleMode = false;
        imports = new TreeSet();
        JJack.nextToken();
        while (tok != null && tok.startsWith("-")) {
            JJack.parseOption();
        }
        JJack.requireToken();
        JJackAudioProcessor firstProcessor = JJack.parseChain();
        if (visibleMode) {
            JFrame frame = new JFrame(JJackSystem.getJackClientName());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    try {
                        JJackSystem.shutdown();
                    }
                    catch (JJackException jJackException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            });
            ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource(ICON));
            frame.setIconImage(icon.getImage());
            JComponent l = JJack.layout(firstProcessor);
            frame.getContentPane().add(l);
            Point framepos = new Point(100, 100);
            int rnd = (int)(20.0 * Math.random());
            framepos.x += rnd;
            framepos.y += rnd;
            frame.setLocation(framepos);
            frame.pack();
            frame.setVisible(true);
        }
        JJackSystem.setProcessor(firstProcessor);
    }

    private static void usage() {
        System.out.println(USAGE);
        System.exit(1);
    }

    private static void help() {
        System.out.println(USAGE);
        System.out.println("clients are Java classes that implement interface de.gulden.framework.jjack.JJackAudioProducer");
        System.out.println("monitor-clients are classes that implement interface de.gulden.framework.jjack.JJackAudioConsumer");
        System.exit(1);
    }

    private static JComponent layout(JJackAudioProcessor p) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 10;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = -1;
        while (p != null) {
            JComponent pComponent;
            if (p instanceof JComponent) {
                pComponent = (JComponent)((Object)p);
            } else {
                String name = p instanceof JJackMonitor ? ((JJackMonitor)p).getName() : "(invisible)";
                pComponent = new JLabel(name);
            }
            if (p instanceof JJackAudioProducer) {
                Collection monitors = ((JJackAudioProducer)p).getMonitors();
                if (!monitors.isEmpty()) {
                    JJack.addAsToolbar(panel, pComponent, gc);
                    Iterator it = monitors.iterator();
                    while (it.hasNext()) {
                        JJackAudioProcessor m = (JJackAudioProcessor)it.next();
                        JComponent c = JJack.layout(m);
                        int gcAnchorBack = gc.anchor;
                        if (!it.hasNext()) {
                            gc.gridheight = 0;
                            gc.anchor = 11;
                        }
                        panel.add((Component)c, gc);
                        gc.anchor = gcAnchorBack;
                    }
                } else {
                    gc.gridheight = 0;
                    JJack.addAsToolbar(panel, pComponent, gc);
                }
                p = ((JJackAudioProducer)p).getChained();
            } else {
                JJack.addAsToolbar(panel, pComponent, gc);
                p = null;
            }
            gc.gridx = -1;
            gc.gridheight = 1;
        }
        return panel;
    }

    private static void addAsToolbar(Container parent, JComponent p, Object constraints) {
        JJackInfoBoxMouseListener ml;
        JToolBar tb;
        String name;
        if (p instanceof JJackMonitor) {
            name = ((JJackMonitor)p).getName();
            tb = new JToolBar(name);
            ml = new JJackInfoBoxMouseListener((JJackMonitor)p);
        } else {
            name = null;
            tb = new JToolBar();
            ml = null;
        }
        tb.setBorderPainted(true);
        TitledBorder border = new TitledBorder(name);
        border.setTitleFont(FONT);
        p.setBorder(border);
        tb.add(p);
        JPanel panel = new JPanel();
        panel.add(tb);
        if (ml != null) {
            panel.addMouseListener(ml);
            tb.addMouseListener(ml);
        }
        parent.add((Component)panel, constraints);
    }

    private static JJackAudioProcessor parseChain() {
        JJackAudioProcessor p2;
        if (tok == null || tok.equals("]")) {
            if (tok != null) {
                JJack.nextToken();
            }
            return null;
        }
        JJackAudioProcessor p = JJack.create(tok);
        JJack.nextToken();
        JJack.parseParameters(p);
        while (tok != null && tok.equals("[")) {
            JJack.nextTokenRequired();
            JJackAudioProcessor m = JJack.parseChain();
            JJack.connectMonitor(p, m);
        }
        if (tok != null && (p2 = JJack.parseChain()) != null) {
            JJack.connectChain(p, p2);
        }
        return p;
    }

    private static void connectMonitor(JJackAudioProcessor a, JJackAudioProcessor b) {
        JJackAudioProducer pa = (JJackAudioProducer)JJack.cast(a, JJackAudioProducer.class);
        JJackAudioConsumer pb = (JJackAudioConsumer)JJack.cast(b, JJackAudioConsumer.class);
        pa.addMonitor(pb);
    }

    private static void connectChain(JJackAudioProcessor a, JJackAudioProcessor b) {
        JJackAudioProducer pa = (JJackAudioProducer)JJack.cast(a, JJackAudioProducer.class);
        JJackAudioProducer pb = (JJackAudioProducer)JJack.cast(b, JJackAudioProducer.class);
        pa.setChained(pb);
    }

    private static void parseParameters(JJackAudioProcessor p) {
        if (tok != null && tok.equals("(")) {
            JJack.nextTokenRequired();
            boolean close = false;
            do {
                if (close = tok.equals(")")) continue;
                String pName = tok;
                String pValue = null;
                JJack.nextTokenRequired();
                if (tok.equals("=")) {
                    JJack.nextTokenRequired();
                    pValue = tok;
                    JJack.nextTokenRequired();
                }
                JJack.assignParameter(p, pName, pValue);
                if (!tok.equals(",")) continue;
                JJack.nextTokenRequired();
            } while (!close);
            JJack.nextToken();
        }
    }

    private static JJackAudioProcessor create(String classname) {
        Class cl = JJack.findClass(classname);
        try {
            Object o = cl.newInstance();
            if (o instanceof Component) {
                visibleMode = true;
            }
            return (JJackAudioProcessor)JJack.cast(o, JJackAudioProcessor.class);
        }
        catch (Exception e) {
            JJack.error("cannot create instance of class '" + cl.getName() + "'");
            return null;
        }
    }

    private static Class findClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            Iterator it = imports.iterator();
            while (it.hasNext()) {
                String packagePrefix = (String)it.next();
                try {
                    return Class.forName(packagePrefix + "." + classname);
                }
                catch (ClassNotFoundException cnfe2) {
                }
            }
            JJack.error("cannot find class '" + classname + "'");
            return null;
        }
    }

    private static void assignParameter(Object o, String paramname, String valueStr) {
        Class<?> cl = o.getClass();
        String settername = "set" + Toolbox.capitalize(paramname);
        Method[] mm = cl.getMethods();
        for (int i = 0; i < mm.length; ++i) {
            Class<?>[] sig;
            Method m = mm[i];
            if (!m.getName().equals(settername) || (sig = mm[i].getParameterTypes()).length != 1) continue;
            Class<?> type = sig[0];
            try {
                if ((class$java$lang$Boolean == null ? JJack.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type)) {
                    if (valueStr == null) {
                        valueStr = "true";
                    }
                    boolean b = Toolbox.isTrue(valueStr);
                    m.invoke(o, b ? Boolean.TRUE : Boolean.FALSE);
                    return;
                }
                if (valueStr == null) {
                    JJack.error("cannot assign an empty value to parameter '" + paramname + "'");
                }
                if ((class$java$lang$String == null ? JJack.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type)) {
                    m.invoke(o, valueStr);
                    return;
                }
                if (Integer.TYPE.isAssignableFrom(type)) {
                    int n = Integer.parseInt(valueStr);
                    m.invoke(o, new Integer(n));
                    return;
                }
                if (Float.TYPE.isAssignableFrom(type)) {
                    float n = Float.parseFloat(valueStr);
                    m.invoke(o, new Float(n));
                    return;
                }
                if (!Double.TYPE.isAssignableFrom(type)) continue;
                double n = Double.parseDouble(valueStr);
                m.invoke(o, new Double(n));
                return;
            }
            catch (NumberFormatException nfe) {
                JJack.error("cannot set '" + paramname + "=" + (valueStr != null ? valueStr : "true") + "' - not a valid number");
                continue;
            }
            catch (IllegalAccessException iae) {
                JJack.error("cannot set '" + paramname + "=" + (valueStr != null ? valueStr : "true") + "' - illegal access");
                continue;
            }
            catch (InvocationTargetException ite) {
                JJack.error("cannot set '" + paramname + "=" + (valueStr != null ? valueStr : "true") + "' - invocation target exception: " + ite.getCause().getClass().getName() + ": " + ite.getCause().getMessage());
            }
        }
        JJack.error("cannot set '" + paramname + "=" + (valueStr != null ? valueStr : "true") + "' - no setter method '" + settername + "'");
    }

    private static void parseOption() {
        if (tok.equals("-i")) {
            JJack.nextTokenRequired();
            imports.add(tok);
            JJack.nextTokenRequired();
        } else if (tok.equals("-c")) {
            JJack.nextTokenRequired();
            try {
                int len;
                FileReader f = new FileReader(tok);
                StringBuffer sb = new StringBuffer();
                do {
                    char[] cc;
                    if ((len = f.read(cc = new char[10000])) != -1) {
                        sb.append(cc, 0, len);
                        continue;
                    }
                    sb.append(cc);
                } while (len == -1);
                JJack.initTokenizer(sb.toString());
                JJack.nextTokenRequired();
            }
            catch (IOException ioe) {
                JJack.error("cannot read configuration from file - " + ioe.getClass().getName() + ": " + ioe.getMessage());
            }
        } else if (tok.equals("-h") || tok.equals("-help") || tok.equals("--h") || tok.equals("--help") || tok.equals("-?") || tok.equals("/?")) {
            JJack.help();
        } else {
            JJack.error("unknown option '" + tok + "'");
        }
    }

    private static void initTokenizer(String s) {
        st = new StringTokenizer(s, " \t\n\r[]()=,", true);
    }

    private static void nextToken() {
        try {
            while ((tok = st.nextToken()).trim().length() == 0) {
            }
        }
        catch (NoSuchElementException e) {
            tok = null;
        }
    }

    private static void requireToken() {
        if (tok == null) {
            JJack.usage();
        }
    }

    private static void nextTokenRequired() {
        JJack.nextToken();
        JJack.requireToken();
    }

    private static Object cast(Object o, Class castTo) {
        if (!castTo.isAssignableFrom(o.getClass())) {
            JJack.error("cannot use " + o.getClass().getName() + " as " + castTo.getName());
        }
        return o;
    }

    private static void message(String msg) {
        System.out.println(msg);
    }

    private static void error(String msg) {
        JJack.message(msg);
        System.exit(1);
    }

    private static void initSwing() {
        UIDefaults ui = UIManager.getDefaults();
        FontUIResource font = new FontUIResource(FONT_BIG);
        ui.put("Menu.font", font);
        ui.put("MenuItem.font", font);
        ui.put("PopupMenu.font", font);
        ui.put("Label.font", font);
    }
}

