/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.framework.jjack;

import de.gulden.framework.jjack.JJackAudioChannel;
import de.gulden.framework.jjack.JJackAudioPort;
import de.gulden.framework.jjack.JJackConstants;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Stack;

public class JJackAudioEvent
extends EventObject {
    protected long timestamp;
    protected FloatBuffer[] inputBuffer;
    protected FloatBuffer[] outputBuffer;
    protected int monoInputPort;
    protected int monoOutputPort;
    Stack stack = new Stack();

    public JJackAudioEvent(long timestamp, Object client, FloatBuffer[] inputBuffer, FloatBuffer[] outputBuffer) {
        super(client);
        this.timestamp = timestamp;
        this.inputBuffer = inputBuffer;
        this.outputBuffer = outputBuffer;
        this.monoInputPort = 0;
        this.monoOutputPort = 0;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public FloatBuffer getInput() {
        return this.getInput(this.getMonoInputPort());
    }

    public void setInput(FloatBuffer buf) {
        this.setInput(this.getMonoInputPort(), buf);
    }

    public FloatBuffer getOutput() {
        return this.getOutput(this.getMonoOutputPort());
    }

    public void setOutput(FloatBuffer buf) {
        this.setOutput(this.getMonoOutputPort(), buf);
    }

    public FloatBuffer getInput(int chan) {
        return this.inputBuffer[chan];
    }

    public void setInput(int chan, FloatBuffer buf) {
        this.inputBuffer[chan] = buf;
    }

    public FloatBuffer getOutput(int chan) {
        return this.outputBuffer[chan];
    }

    public void setOutput(int chan, FloatBuffer buf) {
        this.outputBuffer[chan] = buf;
    }

    public int countInputPorts() {
        return this.inputBuffer.length;
    }

    public int countOutputPorts() {
        return this.outputBuffer.length;
    }

    public int countChannels() {
        return Math.min(this.countInputPorts(), this.countOutputPorts());
    }

    public FloatBuffer[] getInputs() {
        return this.inputBuffer;
    }

    public FloatBuffer[] getOutputs() {
        return this.outputBuffer;
    }

    public int getMonoInputPort() {
        return this.monoInputPort;
    }

    public int getMonoOutputPort() {
        return this.monoOutputPort;
    }

    public void setMonoInputPort(int port) {
        this.monoInputPort = port;
    }

    public void setMonoOutputPort(int port) {
        this.monoOutputPort = port;
    }

    public Collection getChannels() {
        ArrayList<ChannelImpl> list = new ArrayList<ChannelImpl>();
        for (int i = 0; i < this.countChannels(); ++i) {
            list.add(new ChannelImpl(i, this.getInput(i), this.getOutput(i)));
        }
        return list;
    }

    protected class PortImpl
    implements JJackAudioPort,
    JJackConstants {
        protected int port;
        protected FloatBuffer buf;

        PortImpl(int port, FloatBuffer buf) {
            this.port = port;
            this.buf = buf;
        }

        public FloatBuffer getBuffer() {
            return this.buf;
        }
    }

    protected class ChannelImpl
    implements JJackAudioChannel,
    JJackConstants {
        protected int index;
        protected JJackAudioPort in;
        protected JJackAudioPort out;

        ChannelImpl(int index, FloatBuffer in, FloatBuffer out) {
            this.index = index;
            this.in = new PortImpl(0, in);
            this.out = new PortImpl(1, out);
        }

        public JJackAudioPort getPort(int port) {
            switch (port) {
                case 0: {
                    return this.in;
                }
                case 1: {
                    return this.out;
                }
            }
            return null;
        }

        public FloatBuffer getPortBuffer(int port) {
            return this.getPort(port).getBuffer();
        }

        public int getIndex() {
            return this.index;
        }
    }
}

