/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.FloatSampleTools;

public class FloatSampleBuffer {
    private static final boolean LAZY_DEFAULT = true;
    private ArrayList<float[]> channels = new ArrayList();
    private int sampleCount = 0;
    private int channelCount = 0;
    private float sampleRate = 0.0f;
    private int originalFormatType = 0;
    public static final int DITHER_MODE_AUTOMATIC = 0;
    public static final int DITHER_MODE_ON = 1;
    public static final int DITHER_MODE_OFF = 2;
    private float ditherBits = 0.7f;
    private int ditherMode = 0;

    public FloatSampleBuffer() {
        this(0, 0, 1.0f);
    }

    public FloatSampleBuffer(int channelCount, int sampleCount, float sampleRate) {
        this.init(channelCount, sampleCount, sampleRate, true);
    }

    public FloatSampleBuffer(byte[] buffer, int offset, int byteCount, AudioFormat format) {
        this(format.getChannels(), byteCount / (format.getSampleSizeInBits() / 8 * format.getChannels()), format.getSampleRate());
        this.initFromByteArray(buffer, offset, byteCount, format);
    }

    protected void init(int channelCount, int sampleCount, float sampleRate) {
        this.init(channelCount, sampleCount, sampleRate, true);
    }

    protected void init(int channelCount, int sampleCount, float sampleRate, boolean lazy) {
        if (channelCount < 0 || sampleCount < 0) {
            throw new IllegalArgumentException("invalid parameters in initialization of FloatSampleBuffer.");
        }
        this.setSampleRate(sampleRate);
        if (this.getSampleCount() != sampleCount || this.getChannelCount() != channelCount) {
            this.createChannels(channelCount, sampleCount, lazy);
        }
    }

    private void createChannels(int channelCount, int sampleCount, boolean lazy) {
        this.sampleCount = sampleCount;
        this.channelCount = 0;
        int ch = 0;
        while (ch < channelCount) {
            this.insertChannel(ch, false, lazy);
            ++ch;
        }
        if (!lazy) {
            while (this.channels.size() > channelCount) {
                this.channels.remove(this.channels.size() - 1);
            }
        }
    }

    public void initFromByteArray(byte[] buffer, int offset, int byteCount, AudioFormat format) {
        this.initFromByteArray(buffer, offset, byteCount, format, true);
    }

    public void initFromByteArray(byte[] buffer, int offset, int byteCount, AudioFormat format, boolean lazy) {
        if (offset + byteCount > buffer.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.initFromByteArray: buffer too small.");
        }
        int thisSampleCount = byteCount / format.getFrameSize();
        this.init(format.getChannels(), thisSampleCount, format.getSampleRate(), lazy);
        this.originalFormatType = FloatSampleTools.getFormatType(format);
        FloatSampleTools.byte2float(buffer, offset, this.channels, 0, this.sampleCount, format);
    }

    public void initFromFloatSampleBuffer(FloatSampleBuffer source) {
        this.init(source.getChannelCount(), source.getSampleCount(), source.getSampleRate());
        int ch = 0;
        while (ch < this.getChannelCount()) {
            System.arraycopy(source.getChannel(ch), 0, this.getChannel(ch), 0, this.sampleCount);
            ++ch;
        }
    }

    public void reset() {
        this.init(0, 0, 1.0f, false);
    }

    public void reset(int channels, int sampleCount, float sampleRate) {
        this.init(channels, sampleCount, sampleRate, false);
    }

    public int getByteArrayBufferSize(AudioFormat format) {
        return this.getByteArrayBufferSize(format, this.getSampleCount());
    }

    public int getByteArrayBufferSize(AudioFormat format, int lenInSamples) {
        FloatSampleTools.getFormatType(format);
        return format.getFrameSize() * lenInSamples;
    }

    public int convertToByteArray(byte[] buffer, int offset, AudioFormat format) {
        return this.convertToByteArray(0, this.getSampleCount(), buffer, offset, format);
    }

    public int convertToByteArray(int readOffset, int lenInSamples, byte[] buffer, int writeOffset, AudioFormat format) {
        int byteCount = this.getByteArrayBufferSize(format, lenInSamples);
        if (writeOffset + byteCount > buffer.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: buffer too small.");
        }
        if (format.getSampleRate() != this.getSampleRate()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different samplerates.");
        }
        if (format.getChannels() != this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different channel count.");
        }
        FloatSampleTools.float2byte(this.channels, readOffset, buffer, writeOffset, lenInSamples, format, this.getConvertDitherBits(FloatSampleTools.getFormatType(format)));
        return byteCount;
    }

    public byte[] convertToByteArray(AudioFormat format) {
        byte[] res = new byte[this.getByteArrayBufferSize(format)];
        this.convertToByteArray(res, 0, format);
        return res;
    }

    public void changeSampleCount(int newSampleCount, boolean keepOldSamples) {
        int oldSampleCount = this.getSampleCount();
        if (oldSampleCount == newSampleCount) {
            return;
        }
        Object[] oldChannels = null;
        if (keepOldSamples) {
            oldChannels = this.getAllChannels();
        }
        this.init(this.getChannelCount(), newSampleCount, this.getSampleRate());
        if (keepOldSamples) {
            int copyCount = newSampleCount < oldSampleCount ? newSampleCount : oldSampleCount;
            int ch = 0;
            while (ch < this.getChannelCount()) {
                float[] oldSamples = (float[])oldChannels[ch];
                float[] newSamples = this.getChannel(ch);
                if (oldSamples != newSamples) {
                    System.arraycopy(oldSamples, 0, newSamples, 0, copyCount);
                }
                if (oldSampleCount < newSampleCount) {
                    int i = oldSampleCount;
                    while (i < newSampleCount) {
                        newSamples[i] = 0.0f;
                        ++i;
                    }
                }
                ++ch;
            }
        }
    }

    public void makeSilence() {
        if (this.getChannelCount() > 0) {
            this.makeSilence(0);
            int ch = 1;
            while (ch < this.getChannelCount()) {
                this.copyChannel(0, ch);
                ++ch;
            }
        }
    }

    public void makeSilence(int channel) {
        float[] samples = this.getChannel(channel);
        int i = 0;
        while (i < this.getSampleCount()) {
            samples[i] = 0.0f;
            ++i;
        }
    }

    public void addChannel(boolean silent) {
        this.insertChannel(this.getChannelCount(), silent);
    }

    public void insertChannel(int index, boolean silent) {
        this.insertChannel(index, silent, true);
    }

    public void insertChannel(int index, boolean silent, boolean lazy) {
        int physSize = this.channels.size();
        int virtSize = this.getChannelCount();
        float[] newChannel = null;
        if (physSize > virtSize) {
            int ch = virtSize;
            while (ch < physSize) {
                float[] thisChannel = this.channels.get(ch);
                if (lazy && thisChannel.length >= this.getSampleCount() || !lazy && thisChannel.length == this.getSampleCount()) {
                    newChannel = thisChannel;
                    this.channels.remove(ch);
                    break;
                }
                ++ch;
            }
        }
        if (newChannel == null) {
            newChannel = new float[this.getSampleCount()];
        }
        this.channels.add(index, newChannel);
        ++this.channelCount;
        if (silent) {
            this.makeSilence(index);
        }
    }

    public void removeChannel(int channel) {
        this.removeChannel(channel, true);
    }

    public void removeChannel(int channel, boolean lazy) {
        if (!lazy) {
            this.channels.remove(channel);
        } else if (channel < this.getChannelCount() - 1) {
            this.channels.add(this.channels.remove(channel));
        }
        --this.channelCount;
    }

    public void copyChannel(int sourceChannel, int targetChannel) {
        float[] source = this.getChannel(sourceChannel);
        float[] target = this.getChannel(targetChannel);
        System.arraycopy(source, 0, target, 0, this.getSampleCount());
    }

    public void copy(int sourceIndex, int destIndex, int length) {
        int i = 0;
        while (i < this.getChannelCount()) {
            this.copy(i, sourceIndex, destIndex, length);
            ++i;
        }
    }

    public void copy(int channel, int sourceIndex, int destIndex, int length) {
        float[] data = this.getChannel(channel);
        int bufferCount = this.getSampleCount();
        if (sourceIndex + length > bufferCount || destIndex + length > bufferCount || sourceIndex < 0 || destIndex < 0 || length < 0) {
            throw new IndexOutOfBoundsException("parameters exceed buffer size");
        }
        System.arraycopy(data, sourceIndex, data, destIndex, length);
    }

    public void expandChannel(int targetChannelCount) {
        if (this.getChannelCount() != 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: can only expand channels for mono signals.");
        }
        int ch = 1;
        while (ch < targetChannelCount) {
            this.addChannel(false);
            this.copyChannel(0, ch);
            ++ch;
        }
    }

    public void mixDownChannels() {
        float[] firstChannel = this.getChannel(0);
        int sampleCount = this.getSampleCount();
        int channelCount = this.getChannelCount();
        int ch = channelCount - 1;
        while (ch > 0) {
            float[] thisChannel = this.getChannel(ch);
            int i = 0;
            while (i < sampleCount) {
                int n = i;
                firstChannel[n] = firstChannel[n] + thisChannel[i];
                ++i;
            }
            this.removeChannel(ch);
            --ch;
        }
    }

    public void setSamplesFromBytes(byte[] input, int inByteOffset, AudioFormat format, int floatOffset, int frameCount) {
        if (floatOffset < 0 || frameCount < 0 || inByteOffset < 0) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: negative inByteOffset, floatOffset, or frameCount");
        }
        if (inByteOffset + frameCount * format.getFrameSize() > input.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: input buffer too small.");
        }
        if (floatOffset + frameCount > this.getSampleCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: frameCount too large");
        }
        FloatSampleTools.byte2float(input, inByteOffset, this.channels, floatOffset, frameCount, format);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        if (sampleRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid samplerate for FloatSampleBuffer.");
        }
        this.sampleRate = sampleRate;
    }

    public float[] getChannel(int channel) {
        if (channel < 0 || channel >= this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer: invalid channel number.");
        }
        return this.channels.get(channel);
    }

    public Object[] getAllChannels() {
        Object[] res = new Object[this.getChannelCount()];
        int ch = 0;
        while (ch < this.getChannelCount()) {
            res[ch] = this.getChannel(ch);
            ++ch;
        }
        return res;
    }

    public void setDitherBits(float ditherBits) {
        if (ditherBits <= 0.0f) {
            throw new IllegalArgumentException("DitherBits must be greater than 0");
        }
        this.ditherBits = ditherBits;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Illegal DitherMode");
        }
        this.ditherMode = mode;
    }

    public int getDitherMode() {
        return this.ditherMode;
    }

    protected float getConvertDitherBits(int newFormatType) {
        boolean doDither = false;
        switch (this.ditherMode) {
            case 0: {
                doDither = (this.originalFormatType & 7) > (newFormatType & 7);
                break;
            }
            case 1: {
                doDither = true;
                break;
            }
            case 2: {
                doDither = false;
            }
        }
        return doDither ? this.ditherBits : 0.0f;
    }
}

