/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.basic.stereoImage;

import java.awt.Color;
import uk.org.toot.audio.basic.stereoImage.StereoImageProcessVariables;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.localisation.Localisation;

public class StereoImageControls
extends AudioControls
implements StereoImageProcessVariables {
    public static final int STEREO_IMAGE = 48;
    public static final int LR_SWAP = 1;
    public static final int LR_WIDTH = 2;
    private BooleanControl swap;
    private FloatControl width = new FloatControl(2, Localisation.getString("Width"), WIDTH_LAW, 0.01f, 1.0f);
    private static final ControlLaw WIDTH_LAW = new LinearLaw(0.0f, 2.0f, "");

    public StereoImageControls() {
        super(48, Localisation.getString("Stereo"));
        this.width.setInsertColor(Color.orange);
        this.add(this.width);
        this.swap = new BooleanControl(1, Localisation.getString("Swap"), false);
        this.swap.setStateColor(true, Color.red);
        this.add(this.swap);
    }

    public float getWidthFactor() {
        return -(this.width.getValue() - 1.0f);
    }

    public boolean isLRSwapped() {
        return this.swap.getValue();
    }

    public boolean isAlwaysVertical() {
        return true;
    }
}

