/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import org.tritonus.share.sampled.FloatSampleBuffer;
import uk.org.toot.audio.core.FloatDenormals;

public class DelayBuffer
extends FloatSampleBuffer {
    private int writeIndex = 0;
    private int readIndex = 0;

    public DelayBuffer(int channelCount, int sampleCount, float sampleRate) {
        super(channelCount, sampleCount, sampleRate);
    }

    public void nudge(int on) {
        this.readIndex = this.writeIndex;
        this.writeIndex += on;
        this.writeIndex %= this.getSampleCount();
    }

    public void append(int chan, float value) {
        this.getChannel((int)chan)[this.writeIndex] = value;
    }

    public void append(FloatSampleBuffer source) {
        this.conform(source);
        int count = source.getSampleCount();
        int count2 = 0;
        if (this.writeIndex + count > this.getSampleCount()) {
            count = this.getSampleCount() - this.writeIndex;
            count2 = source.getSampleCount() - count;
        }
        int ch = 0;
        while (ch < source.getChannelCount()) {
            System.arraycopy(source.getChannel(ch), 0, this.getChannel(ch), this.writeIndex, count);
            ++ch;
        }
        if (count2 > 0) {
            ch = 0;
            while (ch < source.getChannelCount()) {
                System.arraycopy(source.getChannel(ch), count, this.getChannel(ch), 0, count2);
                ++ch;
            }
        }
        this.nudge(source.getSampleCount());
    }

    public void append(FloatSampleBuffer source1, FloatSampleBuffer source2, float level2) {
        int i;
        float[] src2;
        float[] src1;
        float[] dest;
        this.conform(source1);
        int count = source1.getSampleCount();
        int count2 = 0;
        if (this.writeIndex + count >= this.getSampleCount()) {
            count = this.getSampleCount() - this.writeIndex;
            count2 = source1.getSampleCount() - count;
        }
        int ch = 0;
        while (ch < source1.getChannelCount()) {
            dest = this.getChannel(ch);
            src1 = source1.getChannel(ch);
            src2 = source2.getChannel(ch);
            i = 0;
            while (i < count) {
                dest[i + this.writeIndex] = src1[i] + level2 * src2[i];
                ++i;
            }
            ++ch;
        }
        if (count2 > 0) {
            ch = 0;
            while (ch < source1.getChannelCount()) {
                dest = this.getChannel(ch);
                src1 = source1.getChannel(ch);
                src2 = source2.getChannel(ch);
                i = 0;
                int j = count;
                while (i < count2) {
                    dest[i] = src1[j] + level2 * src2[j];
                    ++i;
                    ++j;
                }
                ++ch;
            }
        }
        this.nudge(source1.getSampleCount());
    }

    public float out(int chan, float delay) {
        int ns = this.getSampleCount();
        float[] samples = this.getChannel(chan);
        int d1 = (int)delay;
        int d2 = d1 + 1;
        float w2 = delay - (float)d1;
        float w1 = 1.0f - w2;
        int pos = this.readIndex + ns;
        return samples[(pos - d1) % ns] * w1 + samples[(pos - d2) % ns] * w2;
    }

    public void tap(FloatSampleBuffer buf, int delay, float weight) {
        int ch = 0;
        while (ch < buf.getChannelCount()) {
            this.tap(ch, buf, delay, weight);
            ++ch;
        }
    }

    public void tap(int ch, FloatSampleBuffer buf, int delay, float weight) {
        if (weight < 0.001f) {
            return;
        }
        int ns = this.getSampleCount();
        float[] dest = buf.getChannel(ch);
        float[] source = this.getChannel(ch);
        int j = this.readIndex - delay + ns;
        int i = 0;
        while (i < buf.getSampleCount()) {
            float out = source[(j + i) % ns] * weight;
            if (!FloatDenormals.isDenormalOrZero(out)) {
                int n = i;
                dest[n] = dest[n] + out;
            }
            ++i;
        }
    }

    public void conform(FloatSampleBuffer buf) {
        while (this.getChannelCount() < buf.getChannelCount()) {
            this.addChannel(true);
        }
        if (this.getSampleRate() != buf.getSampleRate()) {
            this.setSampleRate(buf.getSampleRate());
            this.makeSilence();
        }
    }

    public float msToSamples(float ms) {
        return ms * this.getSampleRate() / 1000.0f;
    }
}

