/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.SimpleAudioProcess;

public abstract class DynamicsProcess
extends SimpleAudioProcess {
    protected float envelope = 0.0f;
    protected boolean isPeak = false;
    protected float threshold;
    protected float thresholddB;
    protected float ratio;
    protected float attack;
    protected float release;
    protected float makeupGain;
    protected ProcessVariables vars;
    private boolean wasBypassed;

    public DynamicsProcess(ProcessVariables vars) {
        this(vars, false);
        this.wasBypassed = !vars.isBypassed();
    }

    public DynamicsProcess(ProcessVariables vars, boolean peak) {
        this.vars = vars;
        this.isPeak = peak;
    }

    public void clear() {
        this.envelope = 1.0f;
        this.vars.setDynamicGain(1.0f);
    }

    protected void cacheProcessVariables() {
        this.threshold = this.vars.getThreshold();
        this.thresholddB = this.vars.getThresholddB();
        this.ratio = this.vars.getRatio();
        this.attack = this.vars.getAttack();
        this.release = this.vars.getRelease();
        this.makeupGain = this.vars.getGain();
    }

    public int processAudio(AudioBuffer buffer) {
        boolean bypassed = this.vars.isBypassed();
        if (bypassed) {
            if (!this.wasBypassed) {
                this.clear();
            }
            this.wasBypassed = true;
            return 0;
        }
        this.vars.update(buffer.getSampleRate());
        this.cacheProcessVariables();
        int nc = buffer.getChannelCount();
        int len = buffer.getSampleCount();
        int mslen = (int)(buffer.getSampleRate() / 1000.0f);
        float dynamicGain = 1.0f;
        float gain = dynamicGain * this.makeupGain;
        int i = 0;
        while (i < len) {
            if (i % mslen == 0) {
                float[] samples;
                double key = 0.0;
                if (this.isPeak) {
                    int c = 0;
                    while (c < nc) {
                        samples = buffer.getChannel(c);
                        int j = 0;
                        while (j < mslen) {
                            key = Math.max(key, (double)Math.abs(samples[i + j]));
                            ++j;
                        }
                        ++c;
                    }
                } else {
                    float sumOfSquares = 0.0f;
                    int c = 0;
                    while (c < nc) {
                        samples = buffer.getChannel(c);
                        int j = 0;
                        while (j < mslen) {
                            float sample = samples[i + j];
                            sumOfSquares += sample * sample;
                            ++j;
                        }
                        ++c;
                    }
                    key = Math.sqrt(sumOfSquares / (float)(mslen * nc));
                }
                dynamicGain = this.evaluateSideChain((float)key);
                gain = dynamicGain * this.makeupGain;
            }
            int c = 0;
            while (c < nc) {
                float[] fArray = buffer.getChannel(c);
                int n = i;
                fArray[n] = fArray[n] * gain;
                ++c;
            }
            ++i;
        }
        this.vars.setDynamicGain(dynamicGain);
        this.wasBypassed = bypassed;
        return 0;
    }

    protected float evaluateSideChain(float key) {
        return this.dynamics(this.function(key));
    }

    protected abstract float function(float var1);

    protected float dynamics(float target) {
        float factor = target < this.envelope ? this.attack : this.release;
        this.envelope = factor * (this.envelope - target) + target;
        return this.envelope;
    }

    public static interface ProcessVariables {
        public void update(float var1);

        public boolean isBypassed();

        public float getThreshold();

        public float getThresholddB();

        public float getRatio();

        public float getKnee();

        public float getAttack();

        public int getHold();

        public float getRelease();

        public float getDepth();

        public float getGain();

        public void setDynamicGain(float var1);
    }
}

