/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import uk.org.toot.audio.dynamics.DynamicsControls;
import uk.org.toot.audio.dynamics.DynamicsProcess;
import uk.org.toot.localisation.Localisation;

public class Gate
extends DynamicsProcess {
    private int hold = 0;
    private boolean wasOpen = false;

    public Gate(DynamicsProcess.ProcessVariables vars) {
        super(vars, true);
    }

    protected float function(float value) {
        if (value < this.threshold) {
            return this.vars.getDepth();
        }
        return 1.0f;
    }

    protected float dynamics(float target) {
        boolean isOpen;
        if (this.hold > 0) {
            --this.hold;
            return super.dynamics(1.0f);
        }
        boolean bl = isOpen = target > 0.9f;
        if (!isOpen && this.wasOpen) {
            this.hold = this.vars.getHold();
            this.wasOpen = false;
            return super.dynamics(1.0f);
        }
        this.wasOpen = isOpen;
        return super.dynamics(target);
    }

    public static class Controls
    extends DynamicsControls {
        public Controls() {
            super(36, Localisation.getString("Gate"));
        }

        protected float getMinimumThreshold() {
            return -60.0f;
        }

        protected boolean hasHold() {
            return true;
        }

        protected boolean hasDepth() {
            return true;
        }
    }
}

